/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.lang.reflect.Field;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesLeafRecordData;
import org.catacombae.hfs.types.hfsplus.HFSPlusForkData;
import org.catacombae.util.Util;

public class HFSPlusAttributesForkData
extends HFSPlusAttributesLeafRecordData
implements StaticStruct,
PrintableStruct {
    public static final int STRUCTSIZE = 88;
    private int reserved;
    private final HFSPlusForkData theFork;

    public HFSPlusAttributesForkData(byte[] data, int offset) {
        super(data, offset);
        this.reserved = Util.readIntBE(data, offset + 4);
        this.theFork = new HFSPlusForkData(data, offset + 8);
    }

    public static int length() {
        return 88;
    }

    public int size() {
        return HFSPlusAttributesForkData.length();
    }

    public final long getReserved() {
        return Util.unsign(this.getRawReserved());
    }

    public final HFSPlusForkData getTheFork() {
        return this.theFork;
    }

    public final int getRawReserved() {
        return this.reserved;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " recordType: " + this.getRecordType());
        ps.println(prefix + " reserved: " + this.getReserved());
        ps.println(prefix + " theFork: ");
        this.getTheFork().print(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusAttrForkData:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[HFSPlusAttributesForkData.length()];
        int offset = 0;
        offset += super.getBytes(result, offset);
        Util.arrayPutBE(result, offset, this.reserved);
        byte[] tempData = this.theFork.getBytes();
        System.arraycopy(tempData, 0, result, offset += 4, tempData.length);
        offset += tempData.length;
        return result;
    }

    public Dictionary getStructElements() {
        Class<HFSPlusAttributesForkData> thisClass = HFSPlusAttributesForkData.class;
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(thisClass.getSimpleName(), "HFS+ attribute fork data");
        try {
            Field reservedField = thisClass.getDeclaredField("reserved");
            reservedField.setAccessible(true);
            db.addAll(super.getStructElements());
            db.addUIntBE("reserved", reservedField, (Object)this, "Reserved", IntegerFieldRepresentation.HEXADECIMAL);
            db.add("theFork", this.theFork.getStructElements());
            return db.getResult();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

