/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.lang.reflect.Field;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesLeafRecordData;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentRecord;
import org.catacombae.util.Util;

public class HFSPlusAttributesExtents
extends HFSPlusAttributesLeafRecordData
implements StaticStruct,
PrintableStruct {
    public static final int STRUCTSIZE = 72;
    private int reserved;
    private final HFSPlusExtentRecord extents;

    public HFSPlusAttributesExtents(byte[] data, int offset) {
        super(data, offset);
        this.reserved = Util.readIntBE(data, offset + 4);
        this.extents = new HFSPlusExtentRecord(data, offset + 8);
    }

    public static int length() {
        return 72;
    }

    public int size() {
        return HFSPlusAttributesExtents.length();
    }

    public final long getReserved() {
        return Util.unsign(this.getRawReserved());
    }

    public final HFSPlusExtentRecord getExtents() {
        return this.extents;
    }

    public final int getRawReserved() {
        return this.reserved;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " recordType: " + this.getRecordType());
        ps.println(prefix + " reserved: " + this.getReserved());
        ps.println(prefix + " extents: ");
        this.getExtents().print(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusAttrExtents:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[HFSPlusAttributesExtents.length()];
        this.getBytes(result, 0);
        return result;
    }

    protected int getBytes(byte[] result, int offset) {
        int originalOffset = offset;
        offset += super.getBytes(result, offset);
        Util.arrayPutBE(result, offset, this.reserved);
        byte[] tempData = this.extents.getBytes();
        System.arraycopy(tempData, 0, result, offset += 4, tempData.length);
        return (offset += tempData.length) - originalOffset;
    }

    public Dictionary getStructElements() {
        Class<HFSPlusAttributesExtents> thisClass = HFSPlusAttributesExtents.class;
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(thisClass.getSimpleName(), "HFS+ attribute extents");
        try {
            Field reservedField = thisClass.getDeclaredField("reserved");
            reservedField.setAccessible(true);
            db.addAll(super.getStructElements());
            db.addUIntBE("reserved", reservedField, (Object)this, "Reserved", IntegerFieldRepresentation.HEXADECIMAL);
            db.add("extents", this.extents.getStructElement(), "Extents");
            return db.getResult();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

