/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.lang.reflect.Field;
import org.catacombae.csjc.DynamicStruct;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesLeafRecordData;
import org.catacombae.hfsexplorer.Util;

public class HFSPlusAttributesData
extends HFSPlusAttributesLeafRecordData
implements DynamicStruct,
PrintableStruct {
    public static final int STATIC_SIZE = 16;
    private long reserved;
    private int attrSize;
    private final byte[] attrData1;
    private final byte[] attrData2;

    public HFSPlusAttributesData(byte[] data, int offset) {
        super(data, offset);
        this.reserved = Util.readLongBE(data, offset + 4);
        this.attrSize = Util.readIntBE(data, offset + 12);
        long unsignedAttrSize = Util.unsign(this.attrSize);
        if (unsignedAttrSize > Integer.MAX_VALUE) {
            this.attrData1 = new byte[Integer.MAX_VALUE];
            this.attrData2 = new byte[(int)(unsignedAttrSize - Integer.MAX_VALUE)];
        } else {
            this.attrData1 = new byte[(int)unsignedAttrSize];
            this.attrData2 = null;
        }
        System.arraycopy(data, offset + 16, this.attrData1, 0, this.attrData1.length);
        if (this.attrData2 != null) {
            System.arraycopy(data, offset + 16 + this.attrData1.length, this.attrData2, 0, this.attrData2.length);
        }
    }

    public int size() {
        return this.occupiedSize();
    }

    public int occupiedSize() {
        long trueSize = 16 + this.attrData1.length + (this.attrData2 != null ? this.attrData2.length : 0);
        return trueSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)trueSize;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public final long[] getReserved() {
        return Util.unsign(this.getRawReserved());
    }

    public final long getAttrSize() {
        return Util.unsign(this.getRawAttrSize());
    }

    public final int readAttrData(long pos, byte[] b, int offset, int length) {
        int length2;
        int length1;
        long unsignedAttrSize = this.getAttrSize();
        if (pos > unsignedAttrSize) {
            return 0;
        }
        if (pos + (long)length > unsignedAttrSize) {
            length = (int)(unsignedAttrSize - pos);
        }
        if (pos > Integer.MAX_VALUE) {
            length1 = 0;
            length2 = length;
        } else if (pos + (long)length > Integer.MAX_VALUE) {
            length1 = (int)(Integer.MAX_VALUE - pos);
            length2 = (int)(pos + (long)length - Integer.MAX_VALUE);
        } else {
            length1 = length;
            length2 = 0;
        }
        if (length1 != 0) {
            System.arraycopy(this.attrData1, (int)pos, b, offset, length1);
            pos += (long)length1;
            offset += length1;
        }
        if (length2 != 0) {
            System.arraycopy(this.attrData2, (int)(pos - Integer.MAX_VALUE), b, offset, length2);
            pos += (long)length2;
            offset += length2;
        }
        return length;
    }

    public final int[] getRawReserved() {
        return Util.readIntArrayBE(Util.toByteArrayBE(this.reserved));
    }

    public final int getRawAttrSize() {
        return this.attrSize;
    }

    public void printFields(PrintStream ps, String prefix) {
        int _i;
        ps.println(prefix + " recordType: " + this.getRecordType());
        ps.println(prefix + " reserved: ");
        Object[] _array = this.getReserved();
        for (_i = 0; _i < 2; ++_i) {
            ps.println(prefix + "  [" + _i + "]:");
            ps.println(prefix + "    " + _array[_i]);
        }
        ps.println(prefix + " attrSize: " + this.getAttrSize());
        ps.println(prefix + " attrData: ");
        _array = this.attrData1;
        for (_i = 0; _i < _array.length; ++_i) {
            ps.println(prefix + "  [" + _i + "]:");
            ps.println(prefix + "    " + (int)_array[_i]);
        }
        if (this.attrData2 != null) {
            _array = this.attrData2;
            for (_i = 0; _i < this.attrData1.length; ++_i) {
                ps.println(prefix + "  [" + _i + "]:");
                ps.println(prefix + "    " + (int)_array[_i]);
            }
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusAttrData:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        if (this.attrData1.length > 0x7FFFFFEF) {
            throw new RuntimeException("Struct is too large to fit within a Java byte array (limited by 2147483647 bytes). Would need " + (16 + this.attrData1.length + (this.attrData2 != null ? this.attrData2.length : 0)) + " bytes.");
        }
        byte[] result = new byte[this.occupiedSize()];
        int offset = 0;
        offset += super.getBytes(result, offset);
        Util.arrayPutBE(result, offset, this.reserved);
        Util.arrayPutBE(result, offset += 8, this.attrSize);
        System.arraycopy(this.attrData1, 0, result, offset += 4, this.attrData1.length);
        offset += this.attrData1.length;
        return result;
    }

    public Dictionary getStructElements() {
        Class<HFSPlusAttributesData> thisClass = HFSPlusAttributesData.class;
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(thisClass.getSimpleName(), "HFS+ attributes data");
        try {
            Field reservedField = thisClass.getDeclaredField("reserved");
            Field attrSizeField = thisClass.getDeclaredField("attrSize");
            reservedField.setAccessible(true);
            attrSizeField.setAccessible(true);
            db.addAll(super.getStructElements());
            db.addUIntBE("reserved", reservedField, (Object)this, "Reserved", IntegerFieldRepresentation.HEXADECIMAL);
            db.addUIntBE("attrSize", attrSizeField, this, "Attribute size");
            if (this.attrData2 == null) {
                db.addByteArray("attrData", this.attrData1, 0, this.attrData1.length, "Attribute data");
            } else {
                db.addByteArray("attrData1", this.attrData1, 0, this.attrData1.length, "Attribute data (part 1)");
                db.addByteArray("attrData2", this.attrData2, 0, this.attrData2.length, "Attribute data (part 2)");
            }
            return db.getResult();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

