/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.lang.reflect.Field;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.structelements.Endianness;
import org.catacombae.csjc.structelements.IntegerField;
import org.catacombae.csjc.structelements.IntegerFieldBits;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.csjc.structelements.Signedness;
import org.catacombae.csjc.structelements.StructElement;
import org.catacombae.util.Util;

public class HFSCatalogNodeID
implements PrintableStruct {
    public static final HFSCatalogNodeID kHFSRootParentID = new HFSCatalogNodeID(1);
    public static final HFSCatalogNodeID kHFSRootFolderID = new HFSCatalogNodeID(2);
    public static final HFSCatalogNodeID kHFSExtentsFileID = new HFSCatalogNodeID(3);
    public static final HFSCatalogNodeID kHFSCatalogFileID = new HFSCatalogNodeID(4);
    public static final HFSCatalogNodeID kHFSBadBlockFileID = new HFSCatalogNodeID(5);
    public static final HFSCatalogNodeID kHFSAllocationFileID = new HFSCatalogNodeID(6);
    public static final HFSCatalogNodeID kHFSStartupFileID = new HFSCatalogNodeID(7);
    public static final HFSCatalogNodeID kHFSAttributesFileID = new HFSCatalogNodeID(8);
    public static final HFSCatalogNodeID kHFSRepairCatalogFileID = new HFSCatalogNodeID(14);
    public static final HFSCatalogNodeID kHFSBogusExtentFileID = new HFSCatalogNodeID(15);
    public static final HFSCatalogNodeID kHFSFirstUserCatalogNodeID = new HFSCatalogNodeID(16);
    private int hfsCatalogNodeID;

    public HFSCatalogNodeID(byte[] data, int offset) {
        this.hfsCatalogNodeID = Util.readIntBE(data, offset);
    }

    public HFSCatalogNodeID(int nodeID) {
        this.hfsCatalogNodeID = nodeID;
    }

    public static int length() {
        return 4;
    }

    public int toInt() {
        return this.hfsCatalogNodeID;
    }

    public long toLong() {
        return Util.unsign(this.toInt());
    }

    public String getDescription() {
        String result;
        switch (this.toInt()) {
            case 1: {
                result = "kHFSRootParentID";
                break;
            }
            case 2: {
                result = "kHFSRootFolderID";
                break;
            }
            case 3: {
                result = "kHFSExtentsFileID";
                break;
            }
            case 4: {
                result = "kHFSCatalogFileID";
                break;
            }
            case 5: {
                result = "kHFSBadBlockFileID";
                break;
            }
            case 6: {
                result = "kHFSAllocationFileID";
                break;
            }
            case 7: {
                result = "kHFSStartupFileID";
                break;
            }
            case 8: {
                result = "kHFSAttributesFileID";
                break;
            }
            case 14: {
                result = "kHFSRepairCatalogFileID";
                break;
            }
            case 15: {
                result = "kHFSBogusExtentFileID";
                break;
            }
            case 16: {
                result = "kHFSFirstUserCatalogNodeID";
                break;
            }
            default: {
                result = "User Defined ID";
            }
        }
        return result;
    }

    public String toString() {
        return "" + this.toLong();
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " hfsCatalogNodeID: " + this.toString() + " (" + this.getDescription() + ")");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSCatalogNodeID:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        return Util.toByteArrayBE(this.hfsCatalogNodeID);
    }

    private Field getPrivateField(String name) throws NoSuchFieldException {
        Field f = this.getClass().getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    public StructElement getOpaqueStructElement() {
        try {
            return new IntegerField(this, this.getPrivateField("hfsCatalogNodeID"), 0, IntegerFieldBits.BITS_32, Signedness.UNSIGNED, Endianness.BIG_ENDIAN, IntegerFieldRepresentation.DECIMAL, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void _setValue(int nodeID) {
        this.hfsCatalogNodeID = nodeID;
    }

    public static class Mutable
    extends HFSCatalogNodeID {
        public Mutable(byte[] data, int offset) {
            super(data, offset);
        }

        public Mutable(int nodeID) {
            super(nodeID);
        }

        public void setValue(int nodeID) {
            ((HFSCatalogNodeID)this)._setValue(nodeID);
        }
    }
}

