/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.hfs.types.hfsplus.BlockInfo;
import org.catacombae.util.Util;

public class BlockListHeader
implements StaticStruct,
PrintableStruct {
    public static final int STRUCTSIZE = 16;
    private final boolean littleEndian;
    private short maxBlocks;
    private short numBlocks;
    private int bytesUsed;
    private int checksum;
    private int pad;

    public BlockListHeader(byte[] data, int offset, boolean littleEndian) {
        this.littleEndian = littleEndian;
        if (!littleEndian) {
            this.maxBlocks = Util.readShortBE(data, offset + 0);
            this.numBlocks = Util.readShortBE(data, offset + 2);
            this.bytesUsed = Util.readIntBE(data, offset + 4);
            this.checksum = Util.readIntBE(data, offset + 8);
            this.pad = Util.readIntBE(data, offset + 12);
        } else {
            this.maxBlocks = Util.readShortLE(data, offset + 0);
            this.numBlocks = Util.readShortLE(data, offset + 2);
            this.bytesUsed = Util.readIntLE(data, offset + 4);
            this.checksum = Util.readIntLE(data, offset + 8);
            this.pad = Util.readIntLE(data, offset + 12);
        }
    }

    public static int length() {
        return 16;
    }

    public int size() {
        return BlockListHeader.length();
    }

    public final boolean isLittleEndian() {
        return this.littleEndian;
    }

    public final int getMaxBlocks() {
        return Util.unsign(this.getRawMaxBlocks());
    }

    public final int getNumBlocks() {
        return Util.unsign(this.getRawNumBlocks());
    }

    public final long getBytesUsed() {
        return Util.unsign(this.getRawBytesUsed());
    }

    public final long getChecksum() {
        return Util.unsign(this.getRawChecksum());
    }

    public final long getPad() {
        return Util.unsign(this.getRawPad());
    }

    public final short getRawMaxBlocks() {
        return this.maxBlocks;
    }

    public final short getRawNumBlocks() {
        return this.numBlocks;
    }

    public final int getRawBytesUsed() {
        return this.bytesUsed;
    }

    public final int getRawChecksum() {
        return this.checksum;
    }

    public final int getRawPad() {
        return this.pad;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " maxBlocks: " + this.getMaxBlocks());
        ps.println(prefix + " numBlocks: " + this.getNumBlocks());
        ps.println(prefix + " bytesUsed: " + this.getBytesUsed());
        ps.println(prefix + " checksum: 0x" + Util.toHexStringBE(this.getChecksum()));
        ps.println(prefix + " pad: 0x" + Util.toHexStringBE(this.getPad()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BlockListHeader:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[BlockListHeader.length()];
        this.getBytes(result, 0);
        return result;
    }

    public int getBytes(byte[] result, int offset) {
        int originalOffset = offset;
        if (!this.littleEndian) {
            Util.arrayPutBE(result, offset, this.maxBlocks);
            Util.arrayPutBE(result, offset += 2, this.numBlocks);
            Util.arrayPutBE(result, offset += 2, this.bytesUsed);
            Util.arrayPutBE(result, offset += 4, this.checksum);
            Util.arrayPutBE(result, offset += 4, this.pad);
            offset += 4;
        } else {
            Util.arrayPutLE(result, offset, this.maxBlocks);
            Util.arrayPutLE(result, offset += 2, this.numBlocks);
            Util.arrayPutLE(result, offset += 2, this.bytesUsed);
            Util.arrayPutLE(result, offset += 4, this.checksum);
            Util.arrayPutLE(result, offset += 4, this.pad);
            offset += 4;
        }
        return offset - originalOffset;
    }

    public int calculateChecksum(BlockInfo firstBlockInfo) {
        byte[] data = new byte[BlockListHeader.length() + BlockInfo.length()];
        this.getBytes(data, 0);
        firstBlockInfo.getBytes(data, BlockListHeader.length());
        int cksum = 0;
        data[8] = 0;
        data[9] = 0;
        data[10] = 0;
        data[11] = 0;
        for (int i = 0; i < data.length; ++i) {
            cksum = cksum << 8 ^ cksum + Util.unsign(data[i]);
        }
        return ~cksum;
    }
}

