/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.DynamicStruct;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.types.hfsplus.BlockInfo;
import org.catacombae.hfs.types.hfsplus.BlockListHeader;

public class BlockList
implements DynamicStruct,
PrintableStruct {
    public final BlockListHeader header;
    public final BlockInfo[] binfo;
    public final byte[] reserved;
    public final byte[][] bdata;

    public BlockList(BlockListHeader header, BlockInfo[] binfo, byte[] reserved, byte[][] data) {
        this.header = header;
        this.binfo = binfo;
        this.reserved = reserved;
        this.bdata = data;
    }

    public BlockList(byte[] data, int offset, int blockListHeaderSize, boolean littleEndian) {
        int i;
        int curOffset = offset;
        this.header = new BlockListHeader(data, curOffset, littleEndian);
        curOffset += this.header.size();
        this.binfo = new BlockInfo[this.header.getNumBlocks()];
        for (i = 0; i < this.binfo.length; ++i) {
            this.binfo[i] = new BlockInfo(data, curOffset, littleEndian);
            curOffset += this.binfo[i].size();
        }
        this.reserved = new byte[blockListHeaderSize - (curOffset - offset)];
        System.arraycopy(data, curOffset, this.reserved, 0, this.reserved.length);
        this.bdata = new byte[this.header.getNumBlocks()][];
        for (i = 0; i < this.binfo.length; ++i) {
            int bsize = this.binfo[i].getRawBsize();
            if (bsize < 0) {
                throw new RuntimeException("'int' overflow in 'bsize' (" + bsize + ").");
            }
            this.bdata[i] = new byte[bsize];
            System.arraycopy(data, curOffset, this.bdata[i], 0, bsize);
            curOffset += bsize;
        }
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public int occupiedSize() {
        int occupiedSize = BlockListHeader.length() + this.binfo.length * BlockInfo.length() + this.reserved.length;
        for (byte[] curData : this.bdata) {
            occupiedSize += curData.length;
        }
        return occupiedSize;
    }

    public BlockListHeader getHeader() {
        return this.header;
    }

    public int getBlockInfoCount() {
        return this.binfo.length;
    }

    public BlockInfo getBlockInfo(int index) {
        return this.binfo[index];
    }

    public void printFields(PrintStream ps, String prefix) {
        int i;
        ps.println(prefix + " header: ");
        this.header.print(ps, prefix + "  ");
        ps.println(prefix + " binfo: ");
        for (i = 0; i < this.binfo.length; ++i) {
            ps.println(prefix + "  [" + i + "]: ");
            this.binfo[i].print(ps, prefix + "   ");
        }
        ps.println(prefix + " reserved: { ... [length=" + this.reserved.length + "] }");
        ps.println(prefix + " bdata: ");
        for (i = 0; i < this.bdata.length; ++i) {
            ps.println(prefix + "  [" + i + "]: ");
            ps.println(prefix + "   { ... [length=" + this.bdata[i].length + "] }");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BlockList:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.occupiedSize()];
        this.getBytes(result, 0);
        return result;
    }

    public int getBytes(byte[] result, int offset) {
        int originalOffset = offset;
        offset += this.header.getBytes(result, offset);
        for (BlockInfo bi : this.binfo) {
            offset += bi.getBytes(result, offset);
        }
        System.arraycopy(this.reserved, 0, result, offset, this.reserved.length);
        offset += this.reserved.length;
        for (byte[] data : this.bdata) {
            System.arraycopy(data, 0, result, offset, data.length);
            offset += data.length;
        }
        return offset - originalOffset;
    }
}

