/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.math.BigInteger;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.util.Util;

public class BlockInfo
implements StaticStruct,
PrintableStruct {
    public static final int STRUCTSIZE = 16;
    private final boolean littleEndian;
    private long bnum;
    private int bsize;
    private int next;

    public BlockInfo(byte[] data, int offset, boolean littleEndian) {
        this.littleEndian = littleEndian;
        if (!littleEndian) {
            this.bnum = Util.readLongBE(data, offset + 0);
            this.bsize = Util.readIntBE(data, offset + 8);
            this.next = Util.readIntBE(data, offset + 12);
        } else {
            this.bnum = Util.readLongLE(data, offset + 0);
            this.bsize = Util.readIntLE(data, offset + 8);
            this.next = Util.readIntLE(data, offset + 12);
        }
    }

    public static int length() {
        return 16;
    }

    public int size() {
        return BlockInfo.length();
    }

    public final boolean isLittleEndian() {
        return this.littleEndian;
    }

    public final BigInteger getBnum() {
        return Util.unsign(this.getRawBnum());
    }

    public final long getBsize() {
        return Util.unsign(this.getRawBsize());
    }

    public final long getNext() {
        return Util.unsign(this.getRawNext());
    }

    public final long getRawBnum() {
        return this.bnum;
    }

    public final int getRawBsize() {
        return this.bsize;
    }

    public final int getRawNext() {
        return this.next;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " bnum: " + this.getBnum());
        ps.println(prefix + " bsize: " + this.getBsize());
        ps.println(prefix + " next: " + this.getNext());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BlockInfo:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[BlockInfo.length()];
        this.getBytes(result, 0);
        return result;
    }

    public int getBytes(byte[] result, int offset) {
        int originalOffset = offset;
        if (!this.littleEndian) {
            Util.arrayPutBE(result, offset, this.bnum);
            Util.arrayPutBE(result, offset += 8, this.bsize);
            Util.arrayPutBE(result, offset += 4, this.next);
            offset += 4;
        } else {
            Util.arrayPutLE(result, offset, this.bnum);
            Util.arrayPutLE(result, offset += 8, this.bsize);
            Util.arrayPutLE(result, offset += 4, this.next);
            offset += 4;
        }
        return offset - originalOffset;
    }
}

