/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.types.hfsplus.BTKey;
import org.catacombae.util.Util;

public class BTIndexRecord
implements PrintableStruct {
    private final BTKey key;
    private final byte[] index = new byte[4];

    public BTIndexRecord(BTKey key, byte[] data, int offset) {
        this.key = key;
        System.arraycopy(data, offset + key.length(), this.index, 0, 4);
    }

    public BTKey getKey() {
        return this.key;
    }

    public int getIndex() {
        return Util.readIntBE(this.index);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " key:");
        this.key.print(ps, prefix + "  ");
        ps.println(prefix + " index: " + Util.unsign(this.getIndex()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BTIndexRecord:");
        this.printFields(ps, prefix);
    }
}

