/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.hfs.types.hfsplus.BTIndexRecord;
import org.catacombae.hfs.types.hfsplus.BTNode;
import org.catacombae.util.Util;

public abstract class BTIndexNode
extends BTNode {
    protected final BTIndexRecord[] records;
    protected final short[] offsets;

    protected BTIndexNode(byte[] data, int offset, int nodeSize) {
        super(data, offset, nodeSize);
        this.offsets = new short[Util.unsign(this.nodeDescriptor.getNumRecords()) + 1];
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = Util.readShortBE(data, offset + nodeSize - (i + 1) * 2);
        }
        this.records = new BTIndexRecord[this.offsets.length - 1];
    }

    public BTIndexRecord getIndexRecord(int index) {
        return this.records[index];
    }

    public BTIndexRecord[] getIndexRecords() {
        BTIndexRecord[] copy = new BTIndexRecord[this.records.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = this.records[i];
        }
        return copy;
    }

    public void printFields(PrintStream ps, String prefix) {
        super.printFields(ps, prefix);
        ps.println(prefix + " records:");
        for (int i = 0; i < this.records.length; ++i) {
            ps.println(prefix + "  [" + i + "]:");
            this.records[i].printFields(ps, prefix + "   ");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BTIndexNode:");
        this.printFields(ps, prefix);
    }
}

