/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.types.hfs.ExtDataRec;
import org.catacombae.hfs.types.hfs.ExtDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentDescriptor;
import org.catacombae.hfs.types.hfsplus.HFSPlusForkData;

public abstract class CommonHFSForkData
implements PrintableStruct {
    public abstract long getLogicalSize();

    public abstract CommonHFSExtentDescriptor[] getBasicExtents();

    public static CommonHFSForkData create(ExtDataRec edr, long logicalSize) {
        return new HFSImplementation(edr, logicalSize);
    }

    public static CommonHFSForkData create(HFSPlusForkData hper) {
        return new HFSPlusImplementation(hper);
    }

    public static class HFSPlusImplementation
    extends CommonHFSForkData {
        private final HFSPlusForkData hper;

        public HFSPlusImplementation(HFSPlusForkData hper) {
            this.hper = hper;
        }

        public long getLogicalSize() {
            return this.hper.getLogicalSize();
        }

        public CommonHFSExtentDescriptor[] getBasicExtents() {
            HFSPlusExtentDescriptor[] src = this.hper.getExtents().getExtentDescriptors();
            CommonHFSExtentDescriptor[] result = new CommonHFSExtentDescriptor[src.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = CommonHFSExtentDescriptor.create(src[i]);
            }
            return result;
        }

        public void print(PrintStream ps, String prefix) {
            this.hper.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.hper.printFields(ps, prefix);
        }
    }

    public static class HFSImplementation
    extends CommonHFSForkData {
        private final ExtDataRec edr;
        private final long logicalSize;

        public HFSImplementation(ExtDataRec edr, long logicalSize) {
            this.edr = edr;
            this.logicalSize = logicalSize;
        }

        public long getLogicalSize() {
            return this.logicalSize;
        }

        public CommonHFSExtentDescriptor[] getBasicExtents() {
            ExtDescriptor[] src = this.edr.getExtDataRecs();
            CommonHFSExtentDescriptor[] result = new CommonHFSExtentDescriptor[src.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = CommonHFSExtentDescriptor.create(src[i]);
            }
            return result;
        }

        public void print(PrintStream ps, String prefix) {
            this.edr.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.edr.printFields(ps, prefix);
        }
    }
}

