/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.types.hfs.CdrDirRec;
import org.catacombae.hfs.types.hfs.CdrFilRec;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogFolder;

public abstract class CommonHFSFinderInfo
implements PrintableStruct {
    public abstract byte[] getBytes();

    public abstract void setBytes(byte[] var1);

    public static CommonHFSFinderInfo create(CdrFilRec rec) {
        return new HFSFileImplementation(rec);
    }

    public static CommonHFSFinderInfo create(CdrDirRec rec) {
        return new HFSFolderImplementation(rec);
    }

    public static CommonHFSFinderInfo create(HFSPlusCatalogFile rec) {
        return new HFSPlusFileImplementation(rec);
    }

    public static CommonHFSFinderInfo create(HFSPlusCatalogFolder rec) {
        return new HFSPlusFolderImplementation(rec);
    }

    private static class HFSPlusFolderImplementation
    extends CommonHFSFinderInfo {
        private HFSPlusCatalogFolder folder;

        public HFSPlusFolderImplementation(HFSPlusCatalogFolder folder) {
            this.folder = folder;
        }

        public byte[] getBytes() {
            byte[] res = new byte[32];
            System.arraycopy(this.folder.getUserInfo().getBytes(), 0, res, 0, 16);
            System.arraycopy(this.folder.getFinderInfo().getBytes(), 0, res, 16, 16);
            return res;
        }

        public void setBytes(byte[] finderInfo) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void print(PrintStream ps, String prefix) {
            this.folder.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.folder.printFields(ps, prefix);
        }
    }

    private static class HFSPlusFileImplementation
    extends CommonHFSFinderInfo {
        private HFSPlusCatalogFile file;

        public HFSPlusFileImplementation(HFSPlusCatalogFile file) {
            this.file = file;
        }

        public byte[] getBytes() {
            byte[] res = new byte[32];
            System.arraycopy(this.file.getUserInfo().getBytes(), 0, res, 0, 16);
            System.arraycopy(this.file.getFinderInfo().getBytes(), 0, res, 16, 16);
            return res;
        }

        public void setBytes(byte[] finderInfo) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void print(PrintStream ps, String prefix) {
            this.file.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.file.printFields(ps, prefix);
        }
    }

    private static class HFSFolderImplementation
    extends CommonHFSFinderInfo {
        private CdrDirRec dirRec;

        public HFSFolderImplementation(CdrDirRec dirRec) {
            this.dirRec = dirRec;
        }

        public byte[] getBytes() {
            byte[] res = new byte[32];
            System.arraycopy(this.dirRec.getDirUsrInfo().getBytes(), 0, res, 0, 16);
            System.arraycopy(this.dirRec.getDirFndrInfo().getBytes(), 0, res, 16, 16);
            return res;
        }

        public void setBytes(byte[] finderInfo) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void print(PrintStream ps, String prefix) {
            this.dirRec.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.dirRec.printFields(ps, prefix);
        }
    }

    private static class HFSFileImplementation
    extends CommonHFSFinderInfo {
        private CdrFilRec filRec;

        public HFSFileImplementation(CdrFilRec filRec) {
            this.filRec = filRec;
        }

        public byte[] getBytes() {
            byte[] res = new byte[32];
            System.arraycopy(this.filRec.getFilUsrWds().getBytes(), 0, res, 0, 16);
            System.arraycopy(this.filRec.getFilFndrInfo().getBytes(), 0, res, 16, 16);
            return res;
        }

        public void setBytes(byte[] finderInfo) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void print(PrintStream ps, String prefix) {
            this.filRec.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.filRec.printFields(ps, prefix);
        }
    }
}

