/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfs.ExtDataRec;
import org.catacombae.hfs.types.hfs.ExtDescriptor;
import org.catacombae.hfs.types.hfs.ExtKeyRec;
import org.catacombae.hfs.types.hfscommon.CommonBTRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentDescriptor;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentKey;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentRecord;

public abstract class CommonHFSExtentLeafRecord
extends CommonBTRecord
implements StructElements {
    public static CommonHFSExtentLeafRecord create(ExtKeyRec key, ExtDataRec recordData) {
        return new HFSImplementation(key, recordData);
    }

    public static CommonHFSExtentLeafRecord create(HFSPlusExtentKey key, HFSPlusExtentRecord recordData) {
        return new HFSPlusImplementation(key, recordData);
    }

    public abstract CommonHFSExtentKey getKey();

    public abstract CommonHFSExtentDescriptor[] getRecordData();

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    private static class HFSPlusImplementation
    extends CommonHFSExtentLeafRecord {
        private final HFSPlusExtentKey key;
        private final HFSPlusExtentRecord recordData;

        public HFSPlusImplementation(HFSPlusExtentKey key, HFSPlusExtentRecord recordData) {
            this.key = key;
            this.recordData = recordData;
        }

        public CommonHFSExtentKey getKey() {
            return CommonHFSExtentKey.create(this.key);
        }

        public CommonHFSExtentDescriptor[] getRecordData() {
            HFSPlusExtentDescriptor[] extDescs = this.recordData.getExtentDescriptors();
            CommonHFSExtentDescriptor[] res = new CommonHFSExtentDescriptor[extDescs.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = CommonHFSExtentDescriptor.create(extDescs[i]);
            }
            return res;
        }

        public int getSize() {
            return this.key.length() + this.recordData.length();
        }

        public byte[] getBytes() {
            byte[] res = new byte[this.getSize()];
            int i = 0;
            byte[] tempArray = this.key.getBytes();
            System.arraycopy(tempArray, 0, res, i, tempArray.length);
            i += tempArray.length;
            tempArray = this.recordData.getBytes();
            System.arraycopy(tempArray, 0, res, 0, tempArray.length);
            if ((i += tempArray.length) != res.length) {
                throw new RuntimeException("Internal error. See stacktrace.");
            }
            return res;
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "key:");
            this.key.print(ps, prefix + " ");
            ps.println(prefix + "recordData:");
            this.recordData.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("CommonHFSExtentLeafRecord.HFSPlusImplementation", "HFS+ extents overflow file leaf record");
            db.add("key", this.key.getStructElements(), "Key");
            db.add("recordData", this.recordData.getStructElement(), "Record data");
            return db.getResult();
        }
    }

    private static class HFSImplementation
    extends CommonHFSExtentLeafRecord {
        private final ExtKeyRec key;
        private final ExtDataRec recordData;

        public HFSImplementation(ExtKeyRec key, ExtDataRec recordData) {
            this.key = key;
            this.recordData = recordData;
        }

        public CommonHFSExtentKey getKey() {
            return CommonHFSExtentKey.create(this.key);
        }

        public CommonHFSExtentDescriptor[] getRecordData() {
            ExtDescriptor[] extDescs = this.recordData.getExtDataRecs();
            CommonHFSExtentDescriptor[] res = new CommonHFSExtentDescriptor[extDescs.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = CommonHFSExtentDescriptor.create(extDescs[i]);
            }
            return res;
        }

        public int getSize() {
            HFSImplementation hFSImplementation = this;
            HFSImplementation hFSImplementation2 = this;
            return hFSImplementation.key.length() + hFSImplementation2.recordData.length();
        }

        public byte[] getBytes() {
            byte[] res = new byte[this.getSize()];
            int i = 0;
            byte[] tempArray = this.key.getBytes();
            System.arraycopy(tempArray, 0, res, i, tempArray.length);
            i += tempArray.length;
            tempArray = this.recordData.getBytes();
            System.arraycopy(tempArray, 0, res, 0, tempArray.length);
            if ((i += tempArray.length) != res.length) {
                throw new RuntimeException("Internal error. See stacktrace.");
            }
            return res;
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "key:");
            this.key.print(ps, prefix + " ");
            ps.println(prefix + "recordData:");
            this.recordData.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("CommonHFSExtentLeafRecord.HFSImplementation", "HFS extents overflow file leaf record");
            db.add("key", this.key.getStructElements(), "Key");
            db.add("recordData", this.recordData.getStructElements(), "Record data");
            return db.getResult();
        }
    }
}

