/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfs.ExtDescriptor;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentDescriptor;
import org.catacombae.util.Util;

public abstract class CommonHFSExtentDescriptor
implements StructElements,
PrintableStruct {
    public abstract long getStartBlock();

    public abstract long getBlockCount();

    public static CommonHFSExtentDescriptor create(HFSPlusExtentDescriptor hped) {
        return new HFSPlusImplementation(hped);
    }

    public static CommonHFSExtentDescriptor create(ExtDescriptor hped) {
        return new HFSImplementation(hped);
    }

    public static class HFSImplementation
    extends CommonHFSExtentDescriptor {
        private final ExtDescriptor hped;

        public HFSImplementation(ExtDescriptor hped) {
            this.hped = hped;
        }

        public long getStartBlock() {
            return Util.unsign(this.hped.getXdrStABN());
        }

        public long getBlockCount() {
            return Util.unsign(this.hped.getXdrNumABlks());
        }

        public void printFields(PrintStream ps, String prefix) {
            this.hped.printFields(ps, prefix);
        }

        public void print(PrintStream ps, String prefix) {
            this.hped.print(ps, prefix);
        }

        public Dictionary getStructElements() {
            return this.hped.getStructElements();
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSExtentDescriptor {
        private final HFSPlusExtentDescriptor hped;

        public HFSPlusImplementation(HFSPlusExtentDescriptor hped) {
            this.hped = hped;
        }

        public long getStartBlock() {
            return Util.unsign(this.hped.getStartBlock());
        }

        public long getBlockCount() {
            return Util.unsign(this.hped.getBlockCount());
        }

        public void printFields(PrintStream ps, String prefix) {
            this.hped.printFields(ps, prefix);
        }

        public void print(PrintStream ps, String prefix) {
            this.hped.print(ps, prefix);
        }

        public Dictionary getStructElements() {
            return this.hped.getStructElements();
        }
    }
}

