/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import org.catacombae.hfs.types.hfsplus.HFSUniStr255;
import org.catacombae.util.Util;

public abstract class CommonHFSCatalogString {
    public static CommonHFSCatalogString createHFSPlus(HFSUniStr255 nodeName) {
        return new HFSPlusImplementation(nodeName);
    }

    public static CommonHFSCatalogString createHFS(byte[] ckrCName) {
        return new HFSImplementation(ckrCName);
    }

    public abstract byte[] getStringBytes();

    public abstract byte[] getStructBytes();

    public static class HFSImplementation
    extends CommonHFSCatalogString {
        private final byte[] ckrCName;

        private HFSImplementation(byte[] ckrCName) {
            this.ckrCName = ckrCName;
        }

        public byte[] getStringBytes() {
            return Util.createCopy(this.ckrCName);
        }

        public byte[] getStructBytes() {
            return Util.createCopy(this.ckrCName);
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSCatalogString {
        private HFSUniStr255 nodeName;

        private HFSPlusImplementation(HFSUniStr255 nodeName) {
            this.nodeName = nodeName;
        }

        public HFSUniStr255 getInternal() {
            return this.nodeName;
        }

        public byte[] getStringBytes() {
            return this.nodeName.getRawUnicode();
        }

        public byte[] getStructBytes() {
            return this.nodeName.getBytes();
        }
    }
}

