/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import org.catacombae.csjc.StructElements;
import org.catacombae.hfs.types.hfs.CatDataRec;
import org.catacombae.hfs.types.hfs.CatKeyRec;
import org.catacombae.hfs.types.hfs.CdrDirRec;
import org.catacombae.hfs.types.hfs.CdrFThdRec;
import org.catacombae.hfs.types.hfs.CdrFilRec;
import org.catacombae.hfs.types.hfs.CdrThdRec;
import org.catacombae.hfs.types.hfscommon.CommonBTRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileThreadRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderThreadRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfs.types.hfsplus.BTHeaderRec;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogFolder;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogLeafRecordData;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogThread;
import org.catacombae.hfs.types.hfsx.HFSXCatalogKey;
import org.catacombae.util.Util;

public abstract class CommonHFSCatalogLeafRecord
extends CommonBTRecord
implements StructElements {
    public static CommonHFSCatalogLeafRecord createHFS(byte[] data, int offset, int length) {
        CatDataRec recordData;
        CatKeyRec key = new CatKeyRec(data, offset);
        int recordOffset = offset + key.occupiedSize();
        if (recordOffset % 2 != 0) {
            ++recordOffset;
        }
        byte recordType = data[recordOffset];
        switch (recordType) {
            case 1: {
                recordData = new CdrDirRec(data, recordOffset);
                break;
            }
            case 2: {
                recordData = new CdrFilRec(data, recordOffset);
                break;
            }
            case 3: {
                recordData = new CdrThdRec(data, recordOffset);
                break;
            }
            case 4: {
                recordData = new CdrFThdRec(data, recordOffset);
                break;
            }
            default: {
                System.err.println("key:");
                key.print(System.err, " ");
                System.err.println("data: " + Util.byteArrayToHexString(data, offset, length));
                throw new RuntimeException("Invalid HFS record type: " + recordType);
            }
        }
        return CommonHFSCatalogLeafRecord.create(key, recordData);
    }

    public static CommonHFSCatalogLeafRecord createHFSPlus(byte[] data, int offset, int length) {
        HFSPlusCatalogLeafRecordData recordData;
        HFSPlusCatalogKey key = new HFSPlusCatalogKey(data, offset);
        short recordType = Util.readShortBE(data, offset + key.length());
        switch (recordType) {
            case 1: {
                recordData = new HFSPlusCatalogFolder(data, offset + key.length());
                break;
            }
            case 2: {
                recordData = new HFSPlusCatalogFile(data, offset + key.length());
                break;
            }
            case 3: 
            case 4: {
                recordData = new HFSPlusCatalogThread(data, offset + key.length());
                break;
            }
            default: {
                throw new RuntimeException("Invalid record type!");
            }
        }
        return CommonHFSCatalogLeafRecord.create(key, recordData);
    }

    public static CommonHFSCatalogLeafRecord createHFSX(byte[] data, int offset, int length, BTHeaderRec bthr) {
        HFSPlusCatalogLeafRecordData recordData;
        if (bthr == null) {
            throw new IllegalArgumentException("bthr == null");
        }
        HFSXCatalogKey key = new HFSXCatalogKey(data, offset, bthr);
        short recordType = Util.readShortBE(data, offset + key.length());
        switch (recordType) {
            case 1: {
                recordData = new HFSPlusCatalogFolder(data, offset + key.length());
                break;
            }
            case 2: {
                recordData = new HFSPlusCatalogFile(data, offset + key.length());
                break;
            }
            case 3: 
            case 4: {
                recordData = new HFSPlusCatalogThread(data, offset + key.length());
                break;
            }
            default: {
                throw new RuntimeException("Invalid record type!");
            }
        }
        return CommonHFSCatalogLeafRecord.create(key, recordData);
    }

    public abstract CommonHFSCatalogKey getKey();

    public static CommonHFSCatalogLeafRecord create(HFSPlusCatalogKey key, HFSPlusCatalogLeafRecordData data) {
        if (data instanceof HFSPlusCatalogFolder) {
            return CommonHFSCatalogFolderRecord.create(key, (HFSPlusCatalogFolder)data);
        }
        if (data instanceof HFSPlusCatalogFile) {
            return CommonHFSCatalogFileRecord.create(key, (HFSPlusCatalogFile)data);
        }
        if (data instanceof HFSPlusCatalogThread) {
            if (data.getRecordType() == 4) {
                return CommonHFSCatalogFileThreadRecord.create(key, (HFSPlusCatalogThread)data);
            }
            if (data.getRecordType() == 3) {
                return CommonHFSCatalogFolderThreadRecord.create(key, (HFSPlusCatalogThread)data);
            }
            throw new RuntimeException("Unknown catalog thread type: " + data.getRecordType());
        }
        throw new RuntimeException("Unknown type of HFSPlusCatalogLeafRecordData: " + data.getClass());
    }

    public static CommonHFSCatalogLeafRecord create(CatKeyRec key, CatDataRec data) {
        if (data instanceof CdrDirRec) {
            return CommonHFSCatalogFolderRecord.create(key, (CdrDirRec)data);
        }
        if (data instanceof CdrFilRec) {
            return CommonHFSCatalogFileRecord.create(key, (CdrFilRec)data);
        }
        if (data instanceof CdrFThdRec) {
            return CommonHFSCatalogFileThreadRecord.create(key, (CdrFThdRec)data);
        }
        if (data instanceof CdrThdRec) {
            return CommonHFSCatalogFolderThreadRecord.create(key, (CdrThdRec)data);
        }
        throw new RuntimeException("Unknown type of CatDataRec: " + data.getClass());
    }
}

