/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfs.CatKeyRec;
import org.catacombae.hfs.types.hfs.CdrFThdRec;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileThread;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogThread;

public class CommonHFSCatalogFileThreadRecord
extends CommonHFSCatalogLeafRecord
implements PrintableStruct {
    private CommonHFSCatalogKey key;
    private CommonHFSCatalogFileThread data;

    private CommonHFSCatalogFileThreadRecord(CommonHFSCatalogKey key, CommonHFSCatalogFileThread data) {
        this.key = key;
        this.data = data;
    }

    public CommonHFSCatalogKey getKey() {
        return this.key;
    }

    public CommonHFSCatalogFileThread getData() {
        return this.data;
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + CommonHFSCatalogFileThreadRecord.class.getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + "key:");
        this.key.print(ps, prefix + " ");
        ps.println(prefix + "data:");
        this.data.print(ps, prefix + " ");
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CommonHFSCatalogFileThreadRecord.class.getSimpleName(), "File thread record");
        db.add("key", this.key.getStructElements(), "Catalog key");
        db.add("data", this.data.getStructElements(), "File thread data");
        return db.getResult();
    }

    public static CommonHFSCatalogFileThreadRecord create(HFSPlusCatalogKey key, HFSPlusCatalogThread data) {
        return new CommonHFSCatalogFileThreadRecord(CommonHFSCatalogKey.create(key), CommonHFSCatalogFileThread.create(data));
    }

    public static CommonHFSCatalogFileThreadRecord create(CatKeyRec key, CdrFThdRec data) {
        return new CommonHFSCatalogFileThreadRecord(CommonHFSCatalogKey.create(key), CommonHFSCatalogFileThread.create(data));
    }

    public int getSize() {
        return this.key.occupiedSize() + this.data.length();
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.getSize()];
        int offset = 0;
        byte[] tempData = this.getKey().getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        tempData = this.data.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        return result;
    }
}

