/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfs.CdrFThdRec;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogThread;

public abstract class CommonHFSCatalogFileThread
implements PrintableStruct,
StructElements {
    public abstract CommonHFSCatalogNodeID getParentID();

    public abstract CommonHFSCatalogString getNodeName();

    public abstract int length();

    public abstract byte[] getBytes();

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + CommonHFSCatalogFileThread.class.getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public static CommonHFSCatalogFileThread create(HFSPlusCatalogThread data) {
        return new HFSPlusImplementation(data);
    }

    public static CommonHFSCatalogFileThread create(CdrFThdRec data) {
        return new HFSImplementation(data);
    }

    private static class HFSImplementation
    extends CommonHFSCatalogFileThread {
        private final CdrFThdRec data;

        public HFSImplementation(CdrFThdRec data) {
            this.data = data;
        }

        public int length() {
            HFSImplementation hFSImplementation = this;
            return hFSImplementation.data.length();
        }

        public CommonHFSCatalogNodeID getParentID() {
            return CommonHFSCatalogNodeID.create(this.data.getFthdParID());
        }

        public CommonHFSCatalogString getNodeName() {
            return CommonHFSCatalogString.createHFS(this.data.getFthdCName());
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "data:");
            this.data.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.data.getStructElements();
        }
    }

    private static class HFSPlusImplementation
    extends CommonHFSCatalogFileThread {
        private final HFSPlusCatalogThread data;

        public HFSPlusImplementation(HFSPlusCatalogThread data) {
            this.data = data;
        }

        public int length() {
            return this.data.length();
        }

        public CommonHFSCatalogNodeID getParentID() {
            return CommonHFSCatalogNodeID.create(this.data.getParentID());
        }

        public CommonHFSCatalogString getNodeName() {
            return CommonHFSCatalogString.createHFSPlus(this.data.getNodeName());
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "data:");
            this.data.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.data.getStructElements();
        }
    }
}

