/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import java.util.Date;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfs.CdrFilRec;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogAttributes;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSFinderInfo;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfs.types.hfsplus.HFSPlusBSDInfo;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.hfs.types.hfsplus.HFSPlusDate;

public abstract class CommonHFSCatalogFile
implements StaticStruct,
PrintableStruct,
StructElements,
CommonHFSCatalogAttributes {
    public abstract CommonHFSCatalogNodeID getFileID();

    public abstract CommonHFSForkData getDataFork();

    public abstract CommonHFSForkData getResourceFork();

    public abstract byte[] getBytes();

    public abstract boolean isHardFileLink();

    public abstract boolean isHardDirectoryLink();

    public abstract boolean isSymbolicLink();

    public abstract int getHardLinkInode();

    public CommonHFSCatalogNodeID getCatalogNodeID() {
        return this.getFileID();
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + CommonHFSCatalogFile.class.getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public abstract void printFields(PrintStream var1, String var2);

    public static CommonHFSCatalogFile create(HFSPlusCatalogFile data) {
        return new HFSPlusImplementation(data);
    }

    public static CommonHFSCatalogFile create(CdrFilRec data) {
        return new HFSImplementation(data);
    }

    public static class HFSImplementation
    extends CommonHFSCatalogFile {
        private CdrFilRec data;

        private HFSImplementation(CdrFilRec data) {
            this.data = data;
        }

        public CommonHFSCatalogNodeID getFileID() {
            return CommonHFSCatalogNodeID.create(this.data.getFilFlNum());
        }

        public CommonHFSForkData getDataFork() {
            return CommonHFSForkData.create(this.data.getFilExtRec(), this.data.getFilLgLen());
        }

        public CommonHFSForkData getResourceFork() {
            return CommonHFSForkData.create(this.data.getFilRExtRec(), this.data.getFilRLgLen());
        }

        public int size() {
            return this.data.size();
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }

        public short getRecordType() {
            return this.data.getCdrType();
        }

        public short getFlags() {
            return this.data.getFilFlags();
        }

        public int getCreateDate() {
            return this.data.getFilCrDat();
        }

        public int getContentModDate() {
            return this.data.getFilMdDat();
        }

        public int getAttributeModDate() {
            return this.data.getFilMdDat();
        }

        public int getAccessDate() {
            return this.data.getFilMdDat();
        }

        public int getBackupDate() {
            return this.data.getFilBkDat();
        }

        public Date getCreateDateAsDate() {
            return HFSPlusDate.localTimestampToDate(this.getCreateDate());
        }

        public Date getContentModDateAsDate() {
            return HFSPlusDate.localTimestampToDate(this.getContentModDate());
        }

        public Date getAttributeModDateAsDate() {
            return HFSPlusDate.localTimestampToDate(this.getAttributeModDate());
        }

        public Date getAccessDateAsDate() {
            return HFSPlusDate.localTimestampToDate(this.getAccessDate());
        }

        public Date getBackupDateAsDate() {
            return HFSPlusDate.localTimestampToDate(this.getBackupDate());
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "data:");
            this.data.print(ps, prefix + " ");
        }

        public boolean isSymbolicLink() {
            return false;
        }

        public Dictionary getStructElements() {
            return this.data.getStructElements();
        }

        public boolean hasPermissions() {
            return false;
        }

        public HFSPlusBSDInfo getPermissions() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean isHardFileLink() {
            return false;
        }

        public boolean isHardDirectoryLink() {
            return false;
        }

        public int getHardLinkInode() {
            throw new UnsupportedOperationException("Not supported for HFS.");
        }

        public boolean hasCreateDate() {
            return true;
        }

        public boolean hasContentModDate() {
            return true;
        }

        public boolean hasAttributeModDate() {
            return false;
        }

        public boolean hasAccessDate() {
            return false;
        }

        public boolean hasBackupDate() {
            return true;
        }

        public CommonHFSFinderInfo getFinderInfo() {
            return CommonHFSFinderInfo.create(this.data);
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSCatalogFile {
        private static final int HARD_FILE_LINK_FILE_TYPE = 1751936619;
        private static final int HARD_FILE_LINK_CREATOR = 1751544619;
        private static final int HARD_DIRECTORY_LINK_FILE_TYPE = 1717858928;
        private static final int HARD_DIRECTORY_LINK_CREATOR = 1296122707;
        private HFSPlusCatalogFile data;

        private HFSPlusImplementation(HFSPlusCatalogFile data) {
            this.data = data;
        }

        public HFSPlusCatalogFile getUnderlying() {
            return this.data;
        }

        public CommonHFSCatalogNodeID getFileID() {
            return CommonHFSCatalogNodeID.create(this.data.getFileID());
        }

        public CommonHFSForkData getDataFork() {
            return CommonHFSForkData.create(this.data.getDataFork());
        }

        public CommonHFSForkData getResourceFork() {
            return CommonHFSForkData.create(this.data.getResourceFork());
        }

        public int size() {
            return this.data.size();
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }

        public short getRecordType() {
            return this.data.getRecordType();
        }

        public short getFlags() {
            return this.data.getFlags();
        }

        public int getCreateDate() {
            return this.data.getCreateDate();
        }

        public int getContentModDate() {
            return this.data.getContentModDate();
        }

        public int getAttributeModDate() {
            return this.data.getAttributeModDate();
        }

        public int getAccessDate() {
            return this.data.getAccessDate();
        }

        public int getBackupDate() {
            return this.data.getBackupDate();
        }

        public Date getCreateDateAsDate() {
            return this.data.getCreateDateAsDate();
        }

        public Date getContentModDateAsDate() {
            return this.data.getContentModDateAsDate();
        }

        public Date getAttributeModDateAsDate() {
            return this.data.getAttributeModDateAsDate();
        }

        public Date getAccessDateAsDate() {
            return this.data.getAccessDateAsDate();
        }

        public Date getBackupDateAsDate() {
            return this.data.getBackupDateAsDate();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "data:");
            this.data.print(ps, prefix + " ");
        }

        public boolean isSymbolicLink() {
            return this.data.getPermissions().getFileModeFileType() == 10;
        }

        public Dictionary getStructElements() {
            return this.data.getStructElements();
        }

        public boolean hasPermissions() {
            return true;
        }

        public HFSPlusBSDInfo getPermissions() {
            return this.data.getPermissions();
        }

        public boolean isHardFileLink() {
            int fileType = this.data.getUserInfo().getFileType().getOSType().getFourCharCode();
            int creator = this.data.getUserInfo().getFileCreator().getOSType().getFourCharCode();
            return fileType == 1751936619 && creator == 1751544619;
        }

        public boolean isHardDirectoryLink() {
            int fileType = this.data.getUserInfo().getFileType().getOSType().getFourCharCode();
            int creator = this.data.getUserInfo().getFileCreator().getOSType().getFourCharCode();
            return fileType == 1717858928 && creator == 1296122707 && this.data.getHasLinkChainFlag();
        }

        public int getHardLinkInode() {
            return this.data.getPermissions().getSpecial();
        }

        public boolean hasCreateDate() {
            return true;
        }

        public boolean hasContentModDate() {
            return true;
        }

        public boolean hasAttributeModDate() {
            return true;
        }

        public boolean hasAccessDate() {
            return true;
        }

        public boolean hasBackupDate() {
            return true;
        }

        public CommonHFSFinderInfo getFinderInfo() {
            return CommonHFSFinderInfo.create(this.data);
        }
    }
}

