/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfscommon.CommonBTKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesKey;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHFSAttributesKey
extends CommonBTKey<CommonHFSAttributesKey>
implements StructElements {
    @Override
    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public static CommonHFSAttributesKey create(HFSPlusAttributesKey key) {
        return new HFSPlusImplementation(key);
    }

    private static int commonCompare(CommonHFSAttributesKey k1, CommonHFSAttributesKey k2) {
        long fileID2;
        long fileID1 = k1.getFileID().toLong();
        if (fileID1 == (fileID2 = k2.getFileID().toLong())) {
            long startBlock2;
            int attrNameLen1 = k1.getAttrNameLen();
            int attrNameLen2 = k2.getAttrNameLen();
            int minAttrNameLen = Math.min(attrNameLen1, attrNameLen2);
            char[] attrName1 = k1.getAttrName();
            char[] attrName2 = k2.getAttrName();
            for (int i = 0; i < minAttrNameLen; ++i) {
                int curChar2;
                int curChar1 = Util.unsign(attrName1[i]);
                if (curChar1 < (curChar2 = Util.unsign(attrName2[i]))) {
                    return -1;
                }
                if (curChar1 <= curChar2) continue;
                return 1;
            }
            if (attrNameLen1 < attrNameLen2) {
                return -1;
            }
            if (attrNameLen1 > attrNameLen2) {
                return 1;
            }
            long startBlock1 = k1.getStartBlock();
            if (startBlock1 == (startBlock2 = k2.getStartBlock())) {
                return 0;
            }
            if (startBlock1 < startBlock2) {
                return -1;
            }
            return 1;
        }
        if (fileID1 < fileID2) {
            return -1;
        }
        return 1;
    }

    public abstract CommonHFSCatalogNodeID getFileID();

    public abstract long getStartBlock();

    public abstract int getAttrNameLen();

    public abstract char[] getAttrName();

    public static class HFSPlusImplementation
    extends CommonHFSAttributesKey {
        private final HFSPlusAttributesKey key;

        public HFSPlusImplementation(HFSPlusAttributesKey key) {
            this.key = key;
        }

        public CommonHFSCatalogNodeID getFileID() {
            return CommonHFSCatalogNodeID.create(this.key.getFileID());
        }

        public final long getStartBlock() {
            return this.key.getStartBlock();
        }

        public final int getAttrNameLen() {
            return this.key.getAttrNameLen();
        }

        public final char[] getAttrName() {
            return this.key.getAttrName();
        }

        public final byte[] getBytes() {
            return this.key.getBytes();
        }

        public final int maxSize() {
            return this.key.length();
        }

        public final int occupiedSize() {
            return this.key.length();
        }

        public final void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "key:");
            this.key.print(ps, prefix + " ");
        }

        public final Dictionary getStructElements() {
            return this.key.getStructElements();
        }

        public int compareTo(CommonHFSAttributesKey o) {
            if (o instanceof HFSPlusImplementation) {
                return CommonHFSAttributesKey.commonCompare((CommonHFSAttributesKey)this, o);
            }
            if (o != null) {
                throw new RuntimeException("Can't compare a " + o.getClass() + " with a " + this.getClass());
            }
            throw new RuntimeException("o == null !!");
        }
    }
}

