/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import org.catacombae.hfs.types.hfscommon.CommonBTIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSAttributesKey;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHFSAttributesIndexNode
extends CommonBTIndexNode<CommonHFSAttributesKey> {
    protected CommonHFSAttributesIndexNode(byte[] data, int offset, int nodeSize, CommonBTNode.FSType type) {
        super(data, offset, nodeSize, type);
    }

    public static CommonHFSAttributesIndexNode createHFSPlus(byte[] data, int offset, int nodeSize) {
        return new HFSPlusImplementation(data, offset, nodeSize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HFSPlusImplementation
    extends CommonHFSAttributesIndexNode {
        public HFSPlusImplementation(byte[] data, int offset, int nodeSize) {
            super(data, offset, nodeSize, CommonBTNode.FSType.HFS_PLUS);
        }

        @Override
        protected CommonBTIndexRecord<CommonHFSAttributesKey> createBTRecord(int recordNumber, byte[] data, int offset, int length) {
            CommonHFSAttributesKey key = CommonHFSAttributesKey.create(new HFSPlusAttributesKey(data, offset));
            return CommonBTIndexRecord.createHFSPlus(key, data, offset);
        }
    }
}

