/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.types.hfs.NodeDescriptor;
import org.catacombae.hfs.types.hfsplus.BTNodeDescriptor;
import org.catacombae.util.Util;

public abstract class CommonBTNodeDescriptor
implements PrintableStruct {
    public abstract long getForwardLink();

    public abstract long getBackwardLink();

    public abstract NodeType getNodeType();

    public abstract short getHeight();

    public abstract int getNumberOfRecords();

    public static CommonBTNodeDescriptor create(BTNodeDescriptor btnd) {
        return new HFSPlusImplementation(btnd);
    }

    public static CommonBTNodeDescriptor create(NodeDescriptor nd) {
        return new HFSImplementation(nd);
    }

    public static class HFSImplementation
    extends CommonBTNodeDescriptor {
        private final NodeDescriptor nd;

        public HFSImplementation(NodeDescriptor nd) {
            this.nd = nd;
        }

        public long getForwardLink() {
            return Util.unsign(this.nd.getNdFLink());
        }

        public long getBackwardLink() {
            return Util.unsign(this.nd.getNdBLink());
        }

        public NodeType getNodeType() {
            byte b = this.nd.getNdType();
            switch (b) {
                case 1: {
                    return NodeType.HEADER;
                }
                case 0: {
                    return NodeType.INDEX;
                }
                case 2: {
                    return NodeType.MAP;
                }
                case -1: {
                    return NodeType.LEAF;
                }
            }
            throw new RuntimeException("Unknown HFS node type: " + b);
        }

        public short getHeight() {
            return Util.unsign(this.nd.getNdNHeight());
        }

        public int getNumberOfRecords() {
            return Util.unsign(this.nd.getNdNRecs());
        }

        public void print(PrintStream ps, String prefix) {
            this.nd.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.nd.printFields(ps, prefix);
        }
    }

    private static class HFSPlusImplementation
    extends CommonBTNodeDescriptor {
        private final BTNodeDescriptor btnd;

        public HFSPlusImplementation(BTNodeDescriptor btnd) {
            this.btnd = btnd;
        }

        public long getForwardLink() {
            return Util.unsign(this.btnd.getFLink());
        }

        public long getBackwardLink() {
            return Util.unsign(this.btnd.getBLink());
        }

        public NodeType getNodeType() {
            byte b = this.btnd.getKind();
            switch (b) {
                case 1: {
                    return NodeType.HEADER;
                }
                case 0: {
                    return NodeType.INDEX;
                }
                case 2: {
                    return NodeType.MAP;
                }
                case -1: {
                    return NodeType.LEAF;
                }
            }
            throw new RuntimeException("Unknown HFS+ node type: " + b);
        }

        public short getHeight() {
            return Util.unsign(this.btnd.getHeight());
        }

        public int getNumberOfRecords() {
            return Util.unsign(this.btnd.getNumRecords());
        }

        public void print(PrintStream ps, String prefix) {
            this.btnd.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.btnd.printFields(ps, prefix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        INDEX,
        HEADER,
        MAP,
        LEAF;

    }
}

