/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.types.hfs.NodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonBTRecord;
import org.catacombae.hfs.types.hfsplus.BTNodeDescriptor;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonBTNode<R extends CommonBTRecord>
implements PrintableStruct {
    protected final InternalContainer ic;

    protected CommonBTNode(byte[] data, int offset, int nodeSize, FSType type) {
        switch (type) {
            case HFS: {
                this.ic = new HFSImplementation(data, offset, nodeSize);
                break;
            }
            case HFS_PLUS: {
                this.ic = new HFSPlusImplementation(data, offset, nodeSize);
                break;
            }
            default: {
                throw new RuntimeException("unknown HFSType: " + (Object)((Object)type));
            }
        }
    }

    public CommonBTNodeDescriptor getNodeDescriptor() {
        return this.ic.getNodeDescriptor();
    }

    public R getBTRecord(int index) {
        return this.ic.getBTRecord(index);
    }

    public List<R> getBTRecords() {
        return this.ic.getBTRecords();
    }

    public int[] getRecordOffsets() {
        int[] result = new int[this.ic.offsets.length];
        for (int i = 0; i < this.ic.offsets.length; ++i) {
            result[i] = Util.unsign(this.ic.offsets[i]);
        }
        return result;
    }

    protected abstract R createBTRecord(int var1, byte[] var2, int var3, int var4);

    @Override
    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CommonBTNode:");
        this.printFields(ps, prefix);
    }

    @Override
    public void printFields(PrintStream ps, String prefix) {
        this.ic.printFields(ps, prefix);
    }

    private class HFSPlusImplementation
    extends InternalContainer {
        public HFSPlusImplementation(byte[] data, int offset, int nodeSize) {
            super(CommonBTNodeDescriptor.create(new BTNodeDescriptor(data, offset)), data, offset, nodeSize);
        }
    }

    private class HFSImplementation
    extends InternalContainer {
        public HFSImplementation(byte[] data, int offset, int nodeSize) {
            super(CommonBTNodeDescriptor.create(new NodeDescriptor(data, offset)), data, offset, nodeSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class InternalContainer {
        protected final CommonBTNodeDescriptor nodeDescriptor;
        protected final List<R> records;
        protected final short[] offsets;

        protected InternalContainer(CommonBTNodeDescriptor nodeDescriptor, byte[] data, int offset, int nodeSize) {
            this.nodeDescriptor = nodeDescriptor;
            this.offsets = new short[nodeDescriptor.getNumberOfRecords() + 1];
            for (int i = 0; i < this.offsets.length; ++i) {
                this.offsets[i] = Util.readShortBE(data, offset + nodeSize - (i + 1) * 2);
            }
            ArrayList tmpRecords = new ArrayList(this.offsets.length - 1);
            for (int i = 0; i < this.offsets.length - 1; ++i) {
                int len = this.offsets[i + 1] - this.offsets[i];
                tmpRecords.add(CommonBTNode.this.createBTRecord(i, data, offset + this.offsets[i], len));
            }
            this.records = Collections.unmodifiableList(tmpRecords);
        }

        public CommonBTNodeDescriptor getNodeDescriptor() {
            return this.nodeDescriptor;
        }

        public R getBTRecord(int index) {
            return (CommonBTRecord)this.records.get(index);
        }

        public List<R> getBTRecords() {
            return this.records;
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + " nodeDescriptor: ");
            this.nodeDescriptor.print(ps, prefix + "  ");
            ps.println(prefix + " records (CommonBTRecord[" + this.records.size() + "]):");
            int i = 0;
            for (CommonBTRecord record : this.records) {
                ps.println(prefix + "  [" + i++ + "]:");
                record.print(ps, prefix + "   ");
            }
            ps.println(prefix + " offsets (short[" + this.offsets.length + "]):");
            for (i = 0; i < this.offsets.length; ++i) {
                ps.println(prefix + "  [" + i + "]: " + this.offsets[i]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FSType {
        HFS,
        HFS_PLUS;

    }
}

