/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.hfs.types.hfscommon.CommonBTKey;
import org.catacombae.hfs.types.hfscommon.CommonBTRecord;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonBTIndexRecord<K extends CommonBTKey<K>>
extends CommonBTRecord {
    protected final K key;
    protected final byte[] index = new byte[4];

    public static <K extends CommonBTKey<K>> CommonBTIndexRecord<K> createHFS(K key, byte[] data, int offset) {
        return new HFSImplementation<K>(key, data, offset);
    }

    public static <K extends CommonBTKey<K>> CommonBTIndexRecord<K> createHFSPlus(K key, byte[] data, int offset) {
        return new HFSPlusImplementation<K>(key, data, offset);
    }

    protected CommonBTIndexRecord(K key, byte[] data, int offset) {
        this.key = key;
        System.arraycopy(data, offset + key.occupiedSize(), this.index, 0, this.index.length);
    }

    public K getKey() {
        return this.key;
    }

    public long getIndex() {
        return Util.unsign(Util.readIntBE(this.index));
    }

    @Override
    public byte[] getBytes() {
        byte[] res = new byte[this.getSize()];
        Util.zero(new byte[][]{res});
        byte[] keyData = ((CommonBTKey)this.key).getBytes();
        int i = 0;
        System.arraycopy(keyData, 0, res, i, keyData.length);
        System.arraycopy(this.index, 0, res, i += keyData.length, this.index.length);
        if ((i += this.index.length) != res.length) {
            throw new RuntimeException("Assertion failed: i == res.length (i=" + i + ",res.length=" + res.length + ")");
        }
        return res;
    }

    @Override
    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CommonBTIndexRecord:");
        this.printFields(ps, prefix);
    }

    @Override
    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " key:");
        this.key.print(ps, prefix + "  ");
        ps.println(prefix + " index: " + this.getIndex());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HFSPlusImplementation<K extends CommonBTKey<K>>
    extends CommonBTIndexRecord<K> {
        public HFSPlusImplementation(K key, byte[] data, int offset) {
            super(key, data, offset);
        }

        @Override
        public int getSize() {
            return this.key.occupiedSize() + this.index.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HFSImplementation<K extends CommonBTKey<K>>
    extends CommonBTIndexRecord<K> {
        public HFSImplementation(K key, byte[] data, int offset) {
            super(key, data, offset);
        }

        @Override
        public int getSize() {
            return this.key.occupiedSize() + this.index.length;
        }
    }
}

