/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfs.BTHdrRec;
import org.catacombae.hfs.types.hfscommon.CommonBTRecord;
import org.catacombae.hfs.types.hfsplus.BTHeaderRec;
import org.catacombae.util.Util;

public abstract class CommonBTHeaderRecord
extends CommonBTRecord
implements PrintableStruct,
StructElements {
    public abstract int getTreeDepth();

    public abstract long getRootNodeNumber();

    public abstract long getNumberOfLeafRecords();

    public abstract long getFirstLeafNodeNumber();

    public abstract long getLastLeafNodeNumber();

    public abstract int getNodeSize();

    public abstract int getMaximumKeyLength();

    public abstract long getTotalNodes();

    public abstract long getFreeNodes();

    public abstract CompareType getKeyCompareType();

    public abstract byte[] getBytes();

    public static CommonBTHeaderRecord create(BTHeaderRec bthr) {
        return new HFSPlusImplementation(bthr);
    }

    public static CommonBTHeaderRecord create(BTHdrRec bthr) {
        return new HFSImplementation(bthr);
    }

    public static class HFSImplementation
    extends CommonBTHeaderRecord {
        private BTHdrRec bthr;

        public HFSImplementation(BTHdrRec bthr) {
            this.bthr = bthr;
        }

        public int getTreeDepth() {
            return Util.unsign(this.bthr.getBthDepth());
        }

        public long getRootNodeNumber() {
            return Util.unsign(this.bthr.getBthRoot());
        }

        public long getNumberOfLeafRecords() {
            return Util.unsign(this.bthr.getBthNRecs());
        }

        public long getFirstLeafNodeNumber() {
            return Util.unsign(this.bthr.getBthFNode());
        }

        public long getLastLeafNodeNumber() {
            return Util.unsign(this.bthr.getBthLNode());
        }

        public int getNodeSize() {
            return Util.unsign(this.bthr.getBthNodeSize());
        }

        public int getMaximumKeyLength() {
            return Util.unsign(this.bthr.getBthKeyLen());
        }

        public long getTotalNodes() {
            return Util.unsign(this.bthr.getBthNNodes());
        }

        public long getFreeNodes() {
            return Util.unsign(this.bthr.getBthFree());
        }

        public CompareType getKeyCompareType() {
            return CompareType.BINARY_COMPARE;
        }

        public byte[] getBytes() {
            return this.bthr.getBytes();
        }

        public void print(PrintStream ps, String prefix) {
            this.bthr.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.bthr.printFields(ps, prefix);
        }

        public int getSize() {
            return BTHdrRec.length();
        }

        public Dictionary getStructElements() {
            return this.bthr.getStructElements();
        }
    }

    public static class HFSPlusImplementation
    extends CommonBTHeaderRecord {
        private BTHeaderRec bthr;

        public HFSPlusImplementation(BTHeaderRec bthr) {
            this.bthr = bthr;
        }

        public int getTreeDepth() {
            return Util.unsign(this.bthr.getTreeDepth());
        }

        public long getRootNodeNumber() {
            return Util.unsign(this.bthr.getRootNode());
        }

        public long getNumberOfLeafRecords() {
            return Util.unsign(this.bthr.getLeafRecords());
        }

        public long getFirstLeafNodeNumber() {
            return Util.unsign(this.bthr.getFirstLeafNode());
        }

        public long getLastLeafNodeNumber() {
            return Util.unsign(this.bthr.getLastLeafNode());
        }

        public int getNodeSize() {
            return Util.unsign(this.bthr.getNodeSize());
        }

        public int getMaximumKeyLength() {
            return Util.unsign(this.bthr.getMaxKeyLength());
        }

        public long getTotalNodes() {
            return Util.unsign(this.bthr.getTotalNodes());
        }

        public long getFreeNodes() {
            return Util.unsign(this.bthr.getFreeNodes());
        }

        public CompareType getKeyCompareType() {
            if (this.bthr.getKeyCompareType() == -68) {
                return CompareType.BINARY_COMPARE;
            }
            if (this.bthr.getKeyCompareType() == -49) {
                return CompareType.CASE_FOLDING;
            }
            throw new RuntimeException("Unknown key compare type!");
        }

        public byte[] getBytes() {
            return this.bthr.getBytes();
        }

        public void print(PrintStream ps, String prefix) {
            this.bthr.print(ps, prefix);
        }

        public void printFields(PrintStream ps, String prefix) {
            this.bthr.printFields(ps, prefix);
        }

        public int getSize() {
            return BTHeaderRec.length();
        }

        public BTHeaderRec getInternal() {
            return this.bthr;
        }

        public Dictionary getStructElements() {
            return this.bthr.getStructElements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompareType {
        CASE_FOLDING,
        BINARY_COMPARE;

    }
}

