/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.util.Util;

public class NodeDescriptor
implements PrintableStruct {
    public static final int STRUCTSIZE = 14;
    public static final byte ndIndxNode = 0;
    public static final byte ndHdrNode = 1;
    public static final byte ndMapNode = 2;
    public static final byte ndLeafNode = -1;
    private final byte[] ndFLink = new byte[4];
    private final byte[] ndBLink = new byte[4];
    private final byte[] ndType = new byte[1];
    private final byte[] ndNHeight = new byte[1];
    private final byte[] ndNRecs = new byte[2];
    private final byte[] ndResv2 = new byte[2];

    public NodeDescriptor(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.ndFLink, 0, 4);
        System.arraycopy(data, offset + 4, this.ndBLink, 0, 4);
        System.arraycopy(data, offset + 8, this.ndType, 0, 1);
        System.arraycopy(data, offset + 9, this.ndNHeight, 0, 1);
        System.arraycopy(data, offset + 10, this.ndNRecs, 0, 2);
        System.arraycopy(data, offset + 12, this.ndResv2, 0, 2);
    }

    public static int length() {
        return 14;
    }

    public int getNdFLink() {
        return Util.readIntBE(this.ndFLink);
    }

    public int getNdBLink() {
        return Util.readIntBE(this.ndBLink);
    }

    public byte getNdType() {
        return Util.readByteBE(this.ndType);
    }

    public byte getNdNHeight() {
        return Util.readByteBE(this.ndNHeight);
    }

    public short getNdNRecs() {
        return Util.readShortBE(this.ndNRecs);
    }

    public short getNdResv2() {
        return Util.readShortBE(this.ndResv2);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " ndFLink: " + this.getNdFLink());
        ps.println(prefix + " ndBLink: " + this.getNdBLink());
        ps.println(prefix + " ndType: " + this.getNdType());
        ps.println(prefix + " ndNHeight: " + this.getNdNHeight());
        ps.println(prefix + " ndNRecs: " + this.getNdNRecs());
        ps.println(prefix + " ndResv2: " + this.getNdResv2());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "NodeDescriptor:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[14];
        int offset = 0;
        System.arraycopy(this.ndFLink, 0, result, offset, this.ndFLink.length);
        System.arraycopy(this.ndBLink, 0, result, offset += this.ndFLink.length, this.ndBLink.length);
        System.arraycopy(this.ndType, 0, result, offset += this.ndBLink.length, this.ndType.length);
        System.arraycopy(this.ndNHeight, 0, result, offset += this.ndType.length, this.ndNHeight.length);
        System.arraycopy(this.ndNRecs, 0, result, offset += this.ndNHeight.length, this.ndNRecs.length);
        System.arraycopy(this.ndResv2, 0, result, offset += this.ndNRecs.length, this.ndResv2.length);
        offset += this.ndResv2.length;
        return result;
    }
}

