/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.hfs.types.hfs.MasterDirectoryBlock;
import org.catacombae.util.Util;

public class HFSVolumeFinderInfo
implements StaticStruct,
PrintableStruct,
StructElements {
    public static final int STRUCTSIZE = 32;
    private int blessedSystemFolder;
    private int startupApplicationParentFolder;
    private int openFolderList;
    private int alternateMacOSBlessedSystemFolder;
    private int reserved;
    private int alternateMacOSXBlessedSystemFolder;
    private long volumeUUID;

    public HFSVolumeFinderInfo(byte[] data, int offset) {
        this.blessedSystemFolder = Util.readIntBE(data, offset + 0);
        this.startupApplicationParentFolder = Util.readIntBE(data, offset + 4);
        this.openFolderList = Util.readIntBE(data, offset + 8);
        this.alternateMacOSBlessedSystemFolder = Util.readIntBE(data, offset + 12);
        this.reserved = Util.readIntBE(data, offset + 16);
        this.alternateMacOSXBlessedSystemFolder = Util.readIntBE(data, offset + 20);
        this.volumeUUID = Util.readLongBE(data, offset + 24);
    }

    public static int length() {
        return 32;
    }

    public int size() {
        return HFSVolumeFinderInfo.length();
    }

    public final long getBlessedSystemFolder() {
        return Util.unsign(this.getRawBlessedSystemFolder());
    }

    public final long getStartupApplicationParentFolder() {
        return Util.unsign(this.getRawStartupApplicationParentFolder());
    }

    public final long getOpenFolderList() {
        return Util.unsign(this.getRawOpenFolderList());
    }

    public final long getAlternateMacOSBlessedSystemFolder() {
        return Util.unsign(this.getRawAlternateMacOSBlessedSystemFolder());
    }

    public final long getReserved() {
        return Util.unsign(this.getRawReserved());
    }

    public final long getAlternateMacOSXBlessedSystemFolder() {
        return Util.unsign(this.getRawAlternateMacOSXBlessedSystemFolder());
    }

    public final BigInteger getVolumeUUID() {
        return Util.unsign(this.getRawVolumeUUID());
    }

    public final int getRawBlessedSystemFolder() {
        return this.blessedSystemFolder;
    }

    public final int getRawStartupApplicationParentFolder() {
        return this.startupApplicationParentFolder;
    }

    public final int getRawOpenFolderList() {
        return this.openFolderList;
    }

    public final int getRawAlternateMacOSBlessedSystemFolder() {
        return this.alternateMacOSBlessedSystemFolder;
    }

    public final int getRawReserved() {
        return this.reserved;
    }

    public final int getRawAlternateMacOSXBlessedSystemFolder() {
        return this.alternateMacOSXBlessedSystemFolder;
    }

    public final long getRawVolumeUUID() {
        return this.volumeUUID;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " blessedSystemFolder: " + this.getBlessedSystemFolder());
        ps.println(prefix + " startupApplicationParentFolder: " + this.getStartupApplicationParentFolder());
        ps.println(prefix + " openFolderList: " + this.getOpenFolderList());
        ps.println(prefix + " alternateMacOSBlessedSystemFolder: " + this.getAlternateMacOSBlessedSystemFolder());
        ps.println(prefix + " reserved: " + this.getReserved());
        ps.println(prefix + " alternateMacOSXBlessedSystemFolder: " + this.getAlternateMacOSXBlessedSystemFolder());
        ps.println(prefix + " volumeUUID: " + this.getVolumeUUID());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSVolumeFinderInfo:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[HFSVolumeFinderInfo.length()];
        this.getBytes(result, 0);
        return result;
    }

    public int getBytes(byte[] result, int offset) {
        int startOffset = offset;
        Util.arrayPutBE(result, offset, this.blessedSystemFolder);
        Util.arrayPutBE(result, offset += 4, this.startupApplicationParentFolder);
        Util.arrayPutBE(result, offset += 4, this.openFolderList);
        Util.arrayPutBE(result, offset += 4, this.alternateMacOSBlessedSystemFolder);
        Util.arrayPutBE(result, offset += 4, this.reserved);
        Util.arrayPutBE(result, offset += 4, this.alternateMacOSXBlessedSystemFolder);
        Util.arrayPutBE(result, offset += 4, this.volumeUUID);
        return (offset += 8) - startOffset;
    }

    private Field getPrivateField(String name) throws NoSuchFieldException {
        Field f = this.getClass().getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(MasterDirectoryBlock.class.getSimpleName());
        try {
            db.addUIntBE("blessedSystemFolder", this.getPrivateField("blessedSystemFolder"), (Object)this, "System folder ID", IntegerFieldRepresentation.DECIMAL);
            db.addUIntBE("startupApplicationParentFolder", this.getPrivateField("startupApplicationParentFolder"), (Object)this, "Startup application's parent folder ID", IntegerFieldRepresentation.DECIMAL);
            db.addUIntBE("openFolderList", this.getPrivateField("openFolderList"), (Object)this, "Folder ID of first folder in open folder list", IntegerFieldRepresentation.DECIMAL);
            db.addUIntBE("alternateMacOSBlessedSystemFolder", this.getPrivateField("alternateMacOSBlessedSystemFolder"), (Object)this, "Alternate Mac OS Classic system folder ID", IntegerFieldRepresentation.DECIMAL);
            db.addUIntBE("reserved", this.getPrivateField("reserved"), (Object)this, "Reserved", IntegerFieldRepresentation.HEXADECIMAL);
            db.addUIntBE("alternateMacOSXBlessedSystemFolder", this.getPrivateField("alternateMacOSXBlessedSystemFolder"), (Object)this, "Alternate Mac OS X system folder ID", IntegerFieldRepresentation.DECIMAL);
            db.addUIntBE("volumeUUID", this.getPrivateField("volumeUUID"), (Object)this, "Volume UUID", IntegerFieldRepresentation.HEXADECIMAL);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return db.getResult();
    }

    public static class Mutable
    extends HFSVolumeFinderInfo {
        public Mutable(byte[] data, int offset) {
            super(data, offset);
        }

        public void set(HFSVolumeFinderInfo header) {
            ((HFSVolumeFinderInfo)this).blessedSystemFolder = header.blessedSystemFolder;
            ((HFSVolumeFinderInfo)this).blessedSystemFolder = header.blessedSystemFolder;
            ((HFSVolumeFinderInfo)this).openFolderList = header.openFolderList;
            ((HFSVolumeFinderInfo)this).alternateMacOSBlessedSystemFolder = header.alternateMacOSBlessedSystemFolder;
            ((HFSVolumeFinderInfo)this).reserved = header.reserved;
            ((HFSVolumeFinderInfo)this).alternateMacOSXBlessedSystemFolder = header.alternateMacOSXBlessedSystemFolder;
            ((HFSVolumeFinderInfo)this).volumeUUID = header.volumeUUID;
        }

        public final void setBlessedSystemFolder(int rawBlessedSystemFolder) {
            ((HFSVolumeFinderInfo)this).blessedSystemFolder = rawBlessedSystemFolder;
        }

        public final void setStartupApplicationParentFolder(int rawStartupApplicationParentFolder) {
            ((HFSVolumeFinderInfo)this).startupApplicationParentFolder = rawStartupApplicationParentFolder;
        }

        public final void setOpenFolderList(int rawOpenFolderList) {
            ((HFSVolumeFinderInfo)this).openFolderList = rawOpenFolderList;
        }

        public final void setAlternateMacOSBlessedSystemFolder(int rawAlternateMacOSBlessedSystemFolder) {
            ((HFSVolumeFinderInfo)this).alternateMacOSBlessedSystemFolder = rawAlternateMacOSBlessedSystemFolder;
        }

        public final void setReserved(int rawReserved) {
            ((HFSVolumeFinderInfo)this).reserved = rawReserved;
        }

        public final void setAlternateMacOSXBlessedSystemFolder(int rawAlternateMacOSXBlessedSystemFolder) {
            ((HFSVolumeFinderInfo)this).alternateMacOSXBlessedSystemFolder = rawAlternateMacOSXBlessedSystemFolder;
        }

        public final void setVolumeUUID(long rawVolumeUUID) {
            ((HFSVolumeFinderInfo)this).volumeUUID = rawVolumeUUID;
        }
    }
}

