/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.types.hfs.ExtDataRec;
import org.catacombae.hfs.types.hfs.ExtDescriptor;
import org.catacombae.util.Util;

public class HFSPlusWrapperMDB
implements PrintableStruct {
    public static final int STRUCTSIZE = 170;
    private final byte[] drSigWord = new byte[2];
    private final byte[] drCrDate = new byte[4];
    private final byte[] drLsMod = new byte[4];
    private final byte[] drAtrb = new byte[2];
    private final byte[] drNmFls = new byte[2];
    private final byte[] drVBMSt = new byte[2];
    private final byte[] drAllocPtr = new byte[2];
    private final byte[] drNmAlBlks = new byte[2];
    private final byte[] drAlBlkSiz = new byte[4];
    private final byte[] drClpSiz = new byte[4];
    private final byte[] drAlBlSt = new byte[2];
    private final byte[] drNxtCNID = new byte[4];
    private final byte[] drFreeBks = new byte[2];
    private final byte[] drVNLength = new byte[1];
    private final byte[] drVN = new byte[27];
    private final byte[] drVolBkUp = new byte[4];
    private final byte[] drVSeqNum = new byte[2];
    private final byte[] drWrCnt = new byte[4];
    private final byte[] drXTClpSiz = new byte[4];
    private final byte[] drCTClpSiz = new byte[4];
    private final byte[] drNmRtDirs = new byte[2];
    private final byte[] drFilCnt = new byte[4];
    private final byte[] drDirCnt = new byte[4];
    private final byte[] drFndrInfo = new byte[32];
    private final byte[] drEmbedSigWord = new byte[2];
    private final ExtDescriptor drEmbedExtent;
    private final byte[] drXTFlSize = new byte[4];
    private final ExtDataRec drXTExtRec;
    private final byte[] drCTFlSize = new byte[4];
    private final ExtDataRec drCTExtRec;

    public HFSPlusWrapperMDB(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.drSigWord, 0, 2);
        System.arraycopy(data, offset + 2, this.drCrDate, 0, 4);
        System.arraycopy(data, offset + 6, this.drLsMod, 0, 4);
        System.arraycopy(data, offset + 10, this.drAtrb, 0, 2);
        System.arraycopy(data, offset + 12, this.drNmFls, 0, 2);
        System.arraycopy(data, offset + 14, this.drVBMSt, 0, 2);
        System.arraycopy(data, offset + 16, this.drAllocPtr, 0, 2);
        System.arraycopy(data, offset + 18, this.drNmAlBlks, 0, 2);
        System.arraycopy(data, offset + 20, this.drAlBlkSiz, 0, 4);
        System.arraycopy(data, offset + 24, this.drClpSiz, 0, 4);
        System.arraycopy(data, offset + 28, this.drAlBlSt, 0, 2);
        System.arraycopy(data, offset + 30, this.drNxtCNID, 0, 4);
        System.arraycopy(data, offset + 34, this.drFreeBks, 0, 2);
        System.arraycopy(data, offset + 36, this.drVNLength, 0, 1);
        System.arraycopy(data, offset + 37, this.drVN, 0, 27);
        System.arraycopy(data, offset + 64, this.drVolBkUp, 0, 4);
        System.arraycopy(data, offset + 68, this.drVSeqNum, 0, 2);
        System.arraycopy(data, offset + 70, this.drWrCnt, 0, 4);
        System.arraycopy(data, offset + 74, this.drXTClpSiz, 0, 4);
        System.arraycopy(data, offset + 78, this.drCTClpSiz, 0, 4);
        System.arraycopy(data, offset + 82, this.drNmRtDirs, 0, 2);
        System.arraycopy(data, offset + 84, this.drFilCnt, 0, 4);
        System.arraycopy(data, offset + 88, this.drDirCnt, 0, 4);
        System.arraycopy(data, offset + 92, this.drFndrInfo, 0, 32);
        System.arraycopy(data, offset + 124, this.drEmbedSigWord, 0, 2);
        this.drEmbedExtent = new ExtDescriptor(data, offset + 126);
        System.arraycopy(data, offset + 130, this.drXTFlSize, 0, 4);
        this.drXTExtRec = new ExtDataRec(data, offset + 134);
        System.arraycopy(data, offset + 150, this.drCTFlSize, 0, 4);
        this.drCTExtRec = new ExtDataRec(data, offset + 154);
    }

    public static int length() {
        return 170;
    }

    public short getDrSigWord() {
        return Util.readShortBE(this.drSigWord);
    }

    public int getDrCrDate() {
        return Util.readIntBE(this.drCrDate);
    }

    public int getDrLsMod() {
        return Util.readIntBE(this.drLsMod);
    }

    public short getDrAtrb() {
        return Util.readShortBE(this.drAtrb);
    }

    public short getDrNmFls() {
        return Util.readShortBE(this.drNmFls);
    }

    public short getDrVBMSt() {
        return Util.readShortBE(this.drVBMSt);
    }

    public short getDrAllocPtr() {
        return Util.readShortBE(this.drAllocPtr);
    }

    public short getDrNmAlBlks() {
        return Util.readShortBE(this.drNmAlBlks);
    }

    public int getDrAlBlkSiz() {
        return Util.readIntBE(this.drAlBlkSiz);
    }

    public int getDrClpSiz() {
        return Util.readIntBE(this.drClpSiz);
    }

    public short getDrAlBlSt() {
        return Util.readShortBE(this.drAlBlSt);
    }

    public int getDrNxtCNID() {
        return Util.readIntBE(this.drNxtCNID);
    }

    public short getDrFreeBks() {
        return Util.readShortBE(this.drFreeBks);
    }

    public byte getDrVNLength() {
        return Util.readByteBE(this.drVNLength);
    }

    public byte[] getDrVN() {
        return Util.createCopy(this.drVN);
    }

    public int getDrVolBkUp() {
        return Util.readIntBE(this.drVolBkUp);
    }

    public short getDrVSeqNum() {
        return Util.readShortBE(this.drVSeqNum);
    }

    public int getDrWrCnt() {
        return Util.readIntBE(this.drWrCnt);
    }

    public int getDrXTClpSiz() {
        return Util.readIntBE(this.drXTClpSiz);
    }

    public int getDrCTClpSiz() {
        return Util.readIntBE(this.drCTClpSiz);
    }

    public short getDrNmRtDirs() {
        return Util.readShortBE(this.drNmRtDirs);
    }

    public int getDrFilCnt() {
        return Util.readIntBE(this.drFilCnt);
    }

    public int getDrDirCnt() {
        return Util.readIntBE(this.drDirCnt);
    }

    public int[] getDrFndrInfo() {
        return Util.readIntArrayBE(this.drFndrInfo);
    }

    public short getDrEmbedSigWord() {
        return Util.readShortBE(this.drEmbedSigWord);
    }

    public ExtDescriptor getDrEmbedExtent() {
        return this.drEmbedExtent;
    }

    public int getDrXTFlSize() {
        return Util.readIntBE(this.drXTFlSize);
    }

    public ExtDataRec getDrXTExtRec() {
        return this.drXTExtRec;
    }

    public int getDrCTFlSize() {
        return Util.readIntBE(this.drCTFlSize);
    }

    public ExtDataRec getDrCTExtRec() {
        return this.drCTExtRec;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " drSigWord: " + this.getDrSigWord());
        ps.println(prefix + " drCrDate: " + this.getDrCrDate());
        ps.println(prefix + " drLsMod: " + this.getDrLsMod());
        ps.println(prefix + " drAtrb: " + this.getDrAtrb());
        ps.println(prefix + " drNmFls: " + this.getDrNmFls());
        ps.println(prefix + " drVBMSt: " + this.getDrVBMSt());
        ps.println(prefix + " drAllocPtr: " + this.getDrAllocPtr());
        ps.println(prefix + " drNmAlBlks: " + this.getDrNmAlBlks());
        ps.println(prefix + " drAlBlkSiz: " + this.getDrAlBlkSiz());
        ps.println(prefix + " drClpSiz: " + this.getDrClpSiz());
        ps.println(prefix + " drAlBlSt: " + this.getDrAlBlSt());
        ps.println(prefix + " drNxtCNID: " + this.getDrNxtCNID());
        ps.println(prefix + " drFreeBks: " + this.getDrFreeBks());
        ps.println(prefix + " drVNLength: " + this.getDrVNLength());
        ps.println(prefix + " drVN: " + this.getDrVN());
        ps.println(prefix + " drVolBkUp: " + this.getDrVolBkUp());
        ps.println(prefix + " drVSeqNum: " + this.getDrVSeqNum());
        ps.println(prefix + " drWrCnt: " + this.getDrWrCnt());
        ps.println(prefix + " drXTClpSiz: " + this.getDrXTClpSiz());
        ps.println(prefix + " drCTClpSiz: " + this.getDrCTClpSiz());
        ps.println(prefix + " drNmRtDirs: " + this.getDrNmRtDirs());
        ps.println(prefix + " drFilCnt: " + this.getDrFilCnt());
        ps.println(prefix + " drDirCnt: " + this.getDrDirCnt());
        ps.println(prefix + " drFndrInfo: " + this.getDrFndrInfo());
        ps.println(prefix + " drEmbedSigWord: " + this.getDrEmbedSigWord());
        ps.println(prefix + " drEmbedExtent: ");
        this.getDrEmbedExtent().print(ps, prefix + "  ");
        ps.println(prefix + " drXTFlSize: " + this.getDrXTFlSize());
        ps.println(prefix + " drXTExtRec: ");
        this.getDrXTExtRec().print(ps, prefix + "  ");
        ps.println(prefix + " drCTFlSize: " + this.getDrCTFlSize());
        ps.println(prefix + " drCTExtRec: ");
        this.getDrCTExtRec().print(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusWrapperMDB:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[170];
        int offset = 0;
        System.arraycopy(this.drSigWord, 0, result, offset, this.drSigWord.length);
        System.arraycopy(this.drCrDate, 0, result, offset += this.drSigWord.length, this.drCrDate.length);
        System.arraycopy(this.drLsMod, 0, result, offset += this.drCrDate.length, this.drLsMod.length);
        System.arraycopy(this.drAtrb, 0, result, offset += this.drLsMod.length, this.drAtrb.length);
        System.arraycopy(this.drNmFls, 0, result, offset += this.drAtrb.length, this.drNmFls.length);
        System.arraycopy(this.drVBMSt, 0, result, offset += this.drNmFls.length, this.drVBMSt.length);
        System.arraycopy(this.drAllocPtr, 0, result, offset += this.drVBMSt.length, this.drAllocPtr.length);
        System.arraycopy(this.drNmAlBlks, 0, result, offset += this.drAllocPtr.length, this.drNmAlBlks.length);
        System.arraycopy(this.drAlBlkSiz, 0, result, offset += this.drNmAlBlks.length, this.drAlBlkSiz.length);
        System.arraycopy(this.drClpSiz, 0, result, offset += this.drAlBlkSiz.length, this.drClpSiz.length);
        System.arraycopy(this.drAlBlSt, 0, result, offset += this.drClpSiz.length, this.drAlBlSt.length);
        System.arraycopy(this.drNxtCNID, 0, result, offset += this.drAlBlSt.length, this.drNxtCNID.length);
        System.arraycopy(this.drFreeBks, 0, result, offset += this.drNxtCNID.length, this.drFreeBks.length);
        System.arraycopy(this.drVNLength, 0, result, offset += this.drFreeBks.length, this.drVNLength.length);
        System.arraycopy(this.drVN, 0, result, offset += this.drVNLength.length, this.drVN.length);
        System.arraycopy(this.drVolBkUp, 0, result, offset += this.drVN.length, this.drVolBkUp.length);
        System.arraycopy(this.drVSeqNum, 0, result, offset += this.drVolBkUp.length, this.drVSeqNum.length);
        System.arraycopy(this.drWrCnt, 0, result, offset += this.drVSeqNum.length, this.drWrCnt.length);
        System.arraycopy(this.drXTClpSiz, 0, result, offset += this.drWrCnt.length, this.drXTClpSiz.length);
        System.arraycopy(this.drCTClpSiz, 0, result, offset += this.drXTClpSiz.length, this.drCTClpSiz.length);
        System.arraycopy(this.drNmRtDirs, 0, result, offset += this.drCTClpSiz.length, this.drNmRtDirs.length);
        System.arraycopy(this.drFilCnt, 0, result, offset += this.drNmRtDirs.length, this.drFilCnt.length);
        System.arraycopy(this.drDirCnt, 0, result, offset += this.drFilCnt.length, this.drDirCnt.length);
        System.arraycopy(this.drFndrInfo, 0, result, offset += this.drDirCnt.length, this.drFndrInfo.length);
        System.arraycopy(this.drEmbedSigWord, 0, result, offset += this.drFndrInfo.length, this.drEmbedSigWord.length);
        byte[] tempData = this.drEmbedExtent.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.drEmbedSigWord.length, tempData.length);
        System.arraycopy(this.drXTFlSize, 0, result, offset += tempData.length, this.drXTFlSize.length);
        tempData = this.drXTExtRec.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.drXTFlSize.length, tempData.length);
        System.arraycopy(this.drCTFlSize, 0, result, offset += tempData.length, this.drCTFlSize.length);
        tempData = this.drCTExtRec.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.drCTFlSize.length, tempData.length);
        offset += tempData.length;
        return result;
    }
}

