/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.util.Util;

public class ExtDescriptor
implements PrintableStruct,
StructElements {
    public static final int STRUCTSIZE = 4;
    private final byte[] xdrStABN = new byte[2];
    private final byte[] xdrNumABlks = new byte[2];

    public ExtDescriptor(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.xdrStABN, 0, 2);
        System.arraycopy(data, offset + 2, this.xdrNumABlks, 0, 2);
    }

    public ExtDescriptor(short xdrStABN, short xdrNumABlks) {
        System.arraycopy(Util.toByteArrayBE(xdrStABN), 0, this.xdrStABN, 0, 2);
        System.arraycopy(Util.toByteArrayBE(xdrNumABlks), 0, this.xdrNumABlks, 0, 2);
    }

    public static int length() {
        return 4;
    }

    public short getXdrStABN() {
        return Util.readShortBE(this.xdrStABN);
    }

    public short getXdrNumABlks() {
        return Util.readShortBE(this.xdrNumABlks);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " xdrStABN: " + Util.unsign(this.getXdrStABN()));
        ps.println(prefix + " xdrNumABlks: " + Util.unsign(this.getXdrNumABlks()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ExtDescriptor:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[4];
        int offset = 0;
        System.arraycopy(this.xdrStABN, 0, result, offset, this.xdrStABN.length);
        System.arraycopy(this.xdrNumABlks, 0, result, offset += this.xdrStABN.length, this.xdrNumABlks.length);
        offset += this.xdrNumABlks.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(ExtDescriptor.class.getName());
        db.addUIntBE("xdrStABN", this.xdrStABN, "Start block");
        db.addUIntBE("xdrNumABlks", this.xdrNumABlks, "Number of blocks");
        return db.getResult();
    }
}

