/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.ASCIIStringField;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfs.CatDataRec;
import org.catacombae.util.Util;

public class CdrThdRec
extends CatDataRec {
    public static final int STRUCTSIZE = 46;
    private final byte[] thdResrv = new byte[8];
    private final byte[] thdParID = new byte[4];
    private final byte[] thdCNameLen = new byte[1];
    private final byte[] thdCName = new byte[31];

    public CdrThdRec(byte[] data, int offset) {
        super(data, offset);
        System.arraycopy(data, offset + 2, this.thdResrv, 0, 8);
        System.arraycopy(data, offset + 10, this.thdParID, 0, 4);
        System.arraycopy(data, offset + 14, this.thdCNameLen, 0, 1);
        System.arraycopy(data, offset + 15, this.thdCName, 0, 31);
    }

    public static int length() {
        return 46;
    }

    public int[] getThdResrv() {
        return Util.readIntArrayBE(this.thdResrv);
    }

    public int getThdParID() {
        return Util.readIntBE(this.thdParID);
    }

    public byte getThdCNameLen() {
        return Util.readByteBE(this.thdCNameLen);
    }

    public byte[] getThdCName() {
        return Util.readByteArrayBE(this.thdCName);
    }

    public void printFields(PrintStream ps, String prefix) {
        super.printFields(ps, prefix);
        ps.println(prefix + " thdResrv: " + this.getThdResrv());
        ps.println(prefix + " thdParID: " + Util.unsign(this.getThdParID()));
        ps.println(prefix + " thdCNameLen: " + Util.unsign(this.getThdCNameLen()));
        ps.println(prefix + " thdCName: \"" + Util.toASCIIString(this.getThdCName()) + "\"");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CdrThdRec:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[46];
        int offset = 0;
        byte[] superData = super.getBytes();
        System.arraycopy(superData, 0, result, offset, superData.length);
        System.arraycopy(this.thdResrv, 0, result, offset += superData.length, this.thdResrv.length);
        System.arraycopy(this.thdParID, 0, result, offset += this.thdResrv.length, this.thdParID.length);
        System.arraycopy(this.thdCNameLen, 0, result, offset += this.thdParID.length, this.thdCNameLen.length);
        System.arraycopy(this.thdCName, 0, result, offset += this.thdCNameLen.length, this.thdCName.length);
        offset += this.thdCName.length;
        return result;
    }

    public int size() {
        return CdrThdRec.length();
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CdrThdRec.class.getSimpleName());
        super.addSuperStructElements(db);
        db.addIntArray("thdResrv", this.thdResrv, BITS_32, UNSIGNED, BIG_ENDIAN, "Reserved", HEXADECIMAL);
        db.addUIntBE("thdParID", this.thdParID, "Parent ID");
        db.addUIntBE("thdCNameLen", this.thdCNameLen, "Length of record name");
        db.add("thdCName", new ASCIIStringField(this.thdCName), "Record name");
        return db.getResult();
    }
}

