/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.finder.FInfo;
import org.catacombae.hfs.types.finder.FXInfo;
import org.catacombae.hfs.types.hfs.CatDataRec;
import org.catacombae.hfs.types.hfs.CdrThdRec;
import org.catacombae.hfs.types.hfs.ExtDataRec;
import org.catacombae.hfs.types.hfs.HFSDateField;
import org.catacombae.util.Util;

public class CdrFilRec
extends CatDataRec {
    public static final int STRUCTSIZE = 102;
    private final byte[] filFlags = new byte[1];
    private final byte[] filTyp = new byte[1];
    private final FInfo filUsrWds;
    private final byte[] filFlNum = new byte[4];
    private final byte[] filStBlk = new byte[2];
    private final byte[] filLgLen = new byte[4];
    private final byte[] filPyLen = new byte[4];
    private final byte[] filRStBlk = new byte[2];
    private final byte[] filRLgLen = new byte[4];
    private final byte[] filRPyLen = new byte[4];
    private final byte[] filCrDat = new byte[4];
    private final byte[] filMdDat = new byte[4];
    private final byte[] filBkDat = new byte[4];
    private final FXInfo filFndrInfo;
    private final byte[] filClpSize = new byte[2];
    private final ExtDataRec filExtRec;
    private final ExtDataRec filRExtRec;
    private final byte[] filResrv = new byte[4];

    public CdrFilRec(byte[] data, int offset) {
        super(data, offset);
        System.arraycopy(data, offset + 2, this.filFlags, 0, 1);
        System.arraycopy(data, offset + 3, this.filTyp, 0, 1);
        this.filUsrWds = new FInfo(data, offset + 4);
        System.arraycopy(data, offset + 20, this.filFlNum, 0, 4);
        System.arraycopy(data, offset + 24, this.filStBlk, 0, 2);
        System.arraycopy(data, offset + 26, this.filLgLen, 0, 4);
        System.arraycopy(data, offset + 30, this.filPyLen, 0, 4);
        System.arraycopy(data, offset + 34, this.filRStBlk, 0, 2);
        System.arraycopy(data, offset + 36, this.filRLgLen, 0, 4);
        System.arraycopy(data, offset + 40, this.filRPyLen, 0, 4);
        System.arraycopy(data, offset + 44, this.filCrDat, 0, 4);
        System.arraycopy(data, offset + 48, this.filMdDat, 0, 4);
        System.arraycopy(data, offset + 52, this.filBkDat, 0, 4);
        this.filFndrInfo = new FXInfo(data, offset + 56);
        System.arraycopy(data, offset + 72, this.filClpSize, 0, 2);
        this.filExtRec = new ExtDataRec(data, offset + 74);
        this.filRExtRec = new ExtDataRec(data, offset + 86);
        System.arraycopy(data, offset + 98, this.filResrv, 0, 4);
    }

    public static int length() {
        return 102;
    }

    public int size() {
        return CdrFilRec.length();
    }

    public byte getFilFlags() {
        return Util.readByteBE(this.filFlags);
    }

    public byte getFilTyp() {
        return Util.readByteBE(this.filTyp);
    }

    public FInfo getFilUsrWds() {
        return this.filUsrWds;
    }

    public int getFilFlNum() {
        return Util.readIntBE(this.filFlNum);
    }

    public short getFilStBlk() {
        return Util.readShortBE(this.filStBlk);
    }

    public int getFilLgLen() {
        return Util.readIntBE(this.filLgLen);
    }

    public int getFilPyLen() {
        return Util.readIntBE(this.filPyLen);
    }

    public short getFilRStBlk() {
        return Util.readShortBE(this.filRStBlk);
    }

    public int getFilRLgLen() {
        return Util.readIntBE(this.filRLgLen);
    }

    public int getFilRPyLen() {
        return Util.readIntBE(this.filRPyLen);
    }

    public int getFilCrDat() {
        return Util.readIntBE(this.filCrDat);
    }

    public int getFilMdDat() {
        return Util.readIntBE(this.filMdDat);
    }

    public int getFilBkDat() {
        return Util.readIntBE(this.filBkDat);
    }

    public FXInfo getFilFndrInfo() {
        return this.filFndrInfo;
    }

    public short getFilClpSize() {
        return Util.readShortBE(this.filClpSize);
    }

    public ExtDataRec getFilExtRec() {
        return this.filExtRec;
    }

    public ExtDataRec getFilRExtRec() {
        return this.filRExtRec;
    }

    public int getFilResrv() {
        return Util.readIntBE(this.filResrv);
    }

    public void printFields(PrintStream ps, String prefix) {
        super.printFields(ps, prefix);
        ps.println(prefix + " filFlags: " + this.getFilFlags());
        ps.println(prefix + " filTyp: " + this.getFilTyp());
        ps.println(prefix + " filUsrWds: ");
        this.getFilUsrWds().print(ps, prefix + "  ");
        ps.println(prefix + " filFlNum: " + this.getFilFlNum());
        ps.println(prefix + " filStBlk: " + this.getFilStBlk());
        ps.println(prefix + " filLgLen: " + this.getFilLgLen());
        ps.println(prefix + " filPyLen: " + this.getFilPyLen());
        ps.println(prefix + " filRStBlk: " + this.getFilRStBlk());
        ps.println(prefix + " filRLgLen: " + this.getFilRLgLen());
        ps.println(prefix + " filRPyLen: " + this.getFilRPyLen());
        ps.println(prefix + " filCrDat: " + this.getFilCrDat());
        ps.println(prefix + " filMdDat: " + this.getFilMdDat());
        ps.println(prefix + " filBkDat: " + this.getFilBkDat());
        ps.println(prefix + " filFndrInfo: ");
        this.getFilFndrInfo().print(ps, prefix + "  ");
        ps.println(prefix + " filClpSize: " + this.getFilClpSize());
        ps.println(prefix + " filExtRec: ");
        this.getFilExtRec().print(ps, prefix + "  ");
        ps.println(prefix + " filRExtRec: ");
        this.getFilRExtRec().print(ps, prefix + "  ");
        ps.println(prefix + " filResrv: " + this.getFilResrv());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CdrFilRec:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[102];
        int offset = 0;
        byte[] superData = super.getBytes();
        System.arraycopy(superData, 0, result, offset, superData.length);
        System.arraycopy(this.filFlags, 0, result, offset += superData.length, this.filFlags.length);
        System.arraycopy(this.filTyp, 0, result, offset += this.filFlags.length, this.filTyp.length);
        byte[] tempData = this.filUsrWds.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.filTyp.length, tempData.length);
        System.arraycopy(this.filFlNum, 0, result, offset += tempData.length, this.filFlNum.length);
        System.arraycopy(this.filStBlk, 0, result, offset += this.filFlNum.length, this.filStBlk.length);
        System.arraycopy(this.filLgLen, 0, result, offset += this.filStBlk.length, this.filLgLen.length);
        System.arraycopy(this.filPyLen, 0, result, offset += this.filLgLen.length, this.filPyLen.length);
        System.arraycopy(this.filRStBlk, 0, result, offset += this.filPyLen.length, this.filRStBlk.length);
        System.arraycopy(this.filRLgLen, 0, result, offset += this.filRStBlk.length, this.filRLgLen.length);
        System.arraycopy(this.filRPyLen, 0, result, offset += this.filRLgLen.length, this.filRPyLen.length);
        System.arraycopy(this.filCrDat, 0, result, offset += this.filRPyLen.length, this.filCrDat.length);
        System.arraycopy(this.filMdDat, 0, result, offset += this.filCrDat.length, this.filMdDat.length);
        System.arraycopy(this.filBkDat, 0, result, offset += this.filMdDat.length, this.filBkDat.length);
        tempData = this.filFndrInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.filBkDat.length, tempData.length);
        System.arraycopy(this.filClpSize, 0, result, offset += tempData.length, this.filClpSize.length);
        tempData = this.filExtRec.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.filClpSize.length, tempData.length);
        offset += tempData.length;
        tempData = this.filRExtRec.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        System.arraycopy(this.filResrv, 0, result, offset += tempData.length, this.filResrv.length);
        offset += this.filResrv.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CdrThdRec.class.getSimpleName());
        super.addSuperStructElements(db);
        db.addUIntBE("filFlags", this.filFlags, "File flags");
        db.addUIntBE("filTyp", this.filTyp, "File type");
        db.add("filUsrWds", this.filUsrWds.getStructElements(), "Finder info");
        db.addUIntBE("filFlNum", this.filFlNum, "File ID");
        db.addUIntBE("filStBlk", this.filStBlk, "First allocation block in data fork");
        db.addUIntBE("filLgLen", this.filLgLen, "Logical length of data fork", "bytes");
        db.addUIntBE("filPyLen", this.filPyLen, "Physical length of data fork", "bytes");
        db.addUIntBE("filRStBlk", this.filRStBlk, "First allocation block in resource fork");
        db.addUIntBE("filRLgLen", this.filRLgLen, "Logical length of resource fork", "bytes");
        db.addUIntBE("filRPyLen", this.filRPyLen, "Physical length of resource fork", "bytes");
        db.add("filCrDat", new HFSDateField(this.filCrDat), "Creation date");
        db.add("filMdDat", new HFSDateField(this.filMdDat), "Modify date");
        db.add("filBkDat", new HFSDateField(this.filBkDat), "Backup date");
        db.add("filFndrInfo", this.filFndrInfo.getStructElements(), "Extended Finder info");
        db.addUIntBE("filClpSize", this.filClpSize, "File clump size");
        db.add("filExtRec", this.filExtRec.getStructElements(), "First data fork extent record");
        db.add("filRExtRec", this.filRExtRec.getStructElements(), "First resource fork extent record");
        db.addUIntBE("filResrv", this.filResrv, "Reserved", HEXADECIMAL);
        return db.getResult();
    }
}

