/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.ASCIIStringField;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfs.CatDataRec;
import org.catacombae.util.Util;

public class CdrFThdRec
extends CatDataRec {
    public static final int STRUCTSIZE = 46;
    private final byte[] fthdResrv = new byte[8];
    private final byte[] fthdParID = new byte[4];
    private final byte[] fthdCNameLen = new byte[1];
    private final byte[] fthdCName = new byte[31];

    public CdrFThdRec(byte[] data, int offset) {
        super(data, offset);
        System.arraycopy(data, offset + 2, this.fthdResrv, 0, 8);
        System.arraycopy(data, offset + 10, this.fthdParID, 0, 4);
        System.arraycopy(data, offset + 14, this.fthdCNameLen, 0, 1);
        System.arraycopy(data, offset + 15, this.fthdCName, 0, 31);
    }

    public static int length() {
        return 46;
    }

    public int[] getFthdResrv() {
        return Util.readIntArrayBE(this.fthdResrv);
    }

    public int getFthdParID() {
        return Util.readIntBE(this.fthdParID);
    }

    public byte getFthdCNameLen() {
        return Util.readByteBE(this.fthdCNameLen);
    }

    public byte[] getFthdCName() {
        return Util.readByteArrayBE(this.fthdCName);
    }

    public void printFields(PrintStream ps, String prefix) {
        super.printFields(ps, prefix);
        ps.println(prefix + " fthdResrv: " + this.getFthdResrv());
        ps.println(prefix + " fthdParID: " + Util.unsign(this.getFthdParID()));
        ps.println(prefix + " fthdCNameLen: " + Util.unsign(this.getFthdCNameLen()));
        ps.println(prefix + " fthdCName: \"" + Util.toASCIIString(this.getFthdCName()) + "\"");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CdrFThdRec:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[46];
        int offset = 0;
        byte[] superData = super.getBytes();
        System.arraycopy(superData, 0, result, offset, superData.length);
        System.arraycopy(this.fthdResrv, 0, result, offset += superData.length, this.fthdResrv.length);
        System.arraycopy(this.fthdParID, 0, result, offset += this.fthdResrv.length, this.fthdParID.length);
        System.arraycopy(this.fthdCNameLen, 0, result, offset += this.fthdParID.length, this.fthdCNameLen.length);
        System.arraycopy(this.fthdCName, 0, result, offset += this.fthdCNameLen.length, this.fthdCName.length);
        offset += this.fthdCName.length;
        return result;
    }

    public int size() {
        return CdrFThdRec.length();
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CdrFThdRec.class.getSimpleName());
        super.addSuperStructElements(db);
        db.addIntArray("fthdResrv", this.fthdResrv, BITS_32, UNSIGNED, BIG_ENDIAN, "Reserved", HEXADECIMAL);
        db.addUIntBE("fthdParID", this.fthdParID, "Parent ID");
        db.addUIntBE("fthdCNameLen", this.fthdCNameLen, "Length of record name", "bytes");
        db.add("fthdCName", new ASCIIStringField(this.fthdCName), "Record name");
        return db.getResult();
    }
}

