/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.DynamicStruct;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.ASCIIStringField;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatKeyRec
implements DynamicStruct,
PrintableStruct,
StructElements,
Comparable<CatKeyRec> {
    private static final int MAX_STRUCTSIZE = 38;
    private final byte[] ckrKeyLen = new byte[1];
    private final byte[] ckrResrv1 = new byte[1];
    private final byte[] ckrParID = new byte[4];
    private final byte[] ckrCNameLen;
    private final byte[] ckrCName;
    private final byte[] ckrPad;
    private static final char[] HFS_RELSTRING_KEY_COMPARE_TABLE = new char[]{'\u0000', '\u0100', '\u0200', '\u0300', '\u0400', '\u0500', '\u0600', '\u0700', '\u0800', '\u0900', '\u0a00', '\u0b00', '\u0c00', '\u0d00', '\u0e00', '\u0f00', '\u1000', '\u1100', '\u1200', '\u1300', '\u1400', '\u1500', '\u1600', '\u1700', '\u1800', '\u1900', '\u1a00', '\u1b00', '\u1c00', '\u1d00', '\u1e00', '\u1f00', '\u2000', '\u2100', '\u2200', '\u2300', '\u2400', '\u2500', '\u2600', '\u2700', '\u2800', '\u2900', '\u2a00', '\u2b00', '\u2c00', '\u2d00', '\u2e00', '\u2f00', '\u3000', '\u3100', '\u3200', '\u3300', '\u3400', '\u3500', '\u3600', '\u3700', '\u3800', '\u3900', '\u3a00', '\u3b00', '\u3c00', '\u3d00', '\u3e00', '\u3f00', '\u4000', '\u4100', '\u4200', '\u4300', '\u4400', '\u4500', '\u4600', '\u4700', '\u4800', '\u4900', '\u4a00', '\u4b00', '\u4c00', '\u4d00', '\u4e00', '\u4f00', '\u5000', '\u5100', '\u5200', '\u5300', '\u5400', '\u5500', '\u5600', '\u5700', '\u5800', '\u5900', '\u5a00', '\u5b00', '\u5c00', '\u5d00', '\u5e00', '\u5f00', '\u4180', '\u4100', '\u4200', '\u4300', '\u4400', '\u4500', '\u4600', '\u4700', '\u4800', '\u4900', '\u4a00', '\u4b00', '\u4c00', '\u4d00', '\u4e00', '\u4f00', '\u5000', '\u5100', '\u5200', '\u5300', '\u5400', '\u5500', '\u5600', '\u5700', '\u5800', '\u5900', '\u5a00', '\u7b00', '\u7c00', '\u7d00', '\u7e00', '\u7f00', '\u4108', '\u410c', '\u4310', '\u4502', '\u4e0a', '\u4f08', '\u5508', '\u4182', '\u4104', '\u4186', '\u4108', '\u410a', '\u410c', '\u4310', '\u4502', '\u4584', '\u4586', '\u4588', '\u4982', '\u4984', '\u4986', '\u4988', '\u4e0a', '\u4f82', '\u4f84', '\u4f86', '\u4f08', '\u4f0a', '\u5582', '\u5584', '\u5586', '\u5508', '\ua000', '\ua100', '\ua200', '\ua300', '\ua400', '\ua500', '\ua600', '\u5382', '\ua800', '\ua900', '\uaa00', '\uab00', '\uac00', '\uad00', '\u4114', '\u4f0e', '\ub000', '\ub100', '\ub200', '\ub300', '\ub400', '\ub500', '\ub600', '\ub700', '\ub800', '\ub900', '\uba00', '\u4192', '\u4f92', '\ubd00', '\u4114', '\u4f0e', '\uc000', '\uc100', '\uc200', '\uc300', '\uc400', '\uc500', '\uc600', '\u2206', '\u2208', '\uc900', '\u2000', '\u4104', '\u410a', '\u4f0a', '\u4f14', '\u4f14', '\ud000', '\ud100', '\u2202', '\u2204', '\u2702', '\u2704', '\ud600', '\ud700', '\u5988', '\ud900', '\uda00', '\udb00', '\udc00', '\udd00', '\ude00', '\udf00', '\ue000', '\ue100', '\ue200', '\ue300', '\ue400', '\ue500', '\ue600', '\ue700', '\ue800', '\ue900', '\uea00', '\ueb00', '\uec00', '\ued00', '\uee00', '\uef00', '\uf000', '\uf100', '\uf200', '\uf300', '\uf400', '\uf500', '\uf600', '\uf700', '\uf800', '\uf900', '\ufa00', '\ufb00', '\ufc00', '\ufd00', '\ufe00', '\uff00'};

    public CatKeyRec(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.ckrKeyLen, 0, 1);
        System.arraycopy(data, offset + 1, this.ckrResrv1, 0, 1);
        System.arraycopy(data, offset + 2, this.ckrParID, 0, 4);
        int structSize = 1 + Util.unsign(this.getCkrKeyLen());
        if (structSize >= 6 && structSize <= 38) {
            if (structSize >= 7) {
                this.ckrCNameLen = new byte[1];
                System.arraycopy(data, offset + 6, this.ckrCNameLen, 0, 1);
                int trailingBytes = structSize - 7;
                short cNameLen = Util.unsign(this.getCkrCNameLen());
                if (cNameLen > trailingBytes) {
                    throw new RuntimeException("Malformed CatKeyRec: ckrCNameLen=" + cNameLen + " > trailingBytes=" + trailingBytes);
                }
                this.ckrCName = new byte[cNameLen];
                System.arraycopy(data, offset + 7, this.ckrCName, 0, this.ckrCName.length);
                int remainingBytes = trailingBytes - cNameLen;
                this.ckrPad = new byte[remainingBytes];
                System.arraycopy(data, offset + 7 + cNameLen, this.ckrPad, 0, remainingBytes);
            } else {
                this.ckrCNameLen = new byte[0];
                this.ckrCName = new byte[0];
                this.ckrPad = new byte[0];
            }
        } else {
            throw new RuntimeException("Incorrect value for ckrKeyLen: " + Util.unsign(this.getCkrKeyLen()));
        }
    }

    public CatKeyRec(int parID, byte[] cName) {
        if (cName.length < 0 || cName.length > 32) {
            throw new IllegalArgumentException("String too large for a catalog file key! (size: " + cName.length + ")");
        }
        byte[] parIDBytes = Util.toByteArrayBE(parID);
        if (parIDBytes.length != 4) {
            throw new RuntimeException("Internal error! int array not 4 bytes but " + parIDBytes.length);
        }
        this.ckrCName = new byte[cName.length];
        this.ckrPad = new byte[0];
        this.ckrKeyLen[0] = (byte)(5 + cName.length);
        this.ckrResrv1[0] = 0;
        System.arraycopy(parIDBytes, 0, this.ckrParID, 0, this.ckrParID.length);
        if (cName.length > 0) {
            this.ckrCNameLen = new byte[1];
            this.ckrCNameLen[0] = (byte)cName.length;
            System.arraycopy(cName, 0, this.ckrCName, 0, this.ckrCName.length);
        } else {
            this.ckrCNameLen = new byte[0];
        }
    }

    public byte getCkrKeyLen() {
        return Util.readByteBE(this.ckrKeyLen);
    }

    public byte getCkrResrv1() {
        return Util.readByteBE(this.ckrResrv1);
    }

    public int getCkrParID() {
        return Util.readIntBE(this.ckrParID);
    }

    public byte getCkrCNameLen() {
        return Util.readByteBE(this.ckrCNameLen);
    }

    public byte[] getCkrCName() {
        return Util.createCopy(this.ckrCName);
    }

    public byte[] getCkrPad() {
        return Util.createCopy(this.ckrPad);
    }

    @Override
    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " ckrKeyLen: " + this.getCkrKeyLen());
        ps.println(prefix + " ckrResrv1: " + this.getCkrResrv1());
        ps.println(prefix + " ckrParID: " + this.getCkrParID());
        ps.println(prefix + " ckrCNameLen: " + this.getCkrCNameLen());
        ps.println(prefix + " ckrCName: \"" + Util.toASCIIString(this.getCkrCName()) + "\" (0x" + Util.byteArrayToHexString(this.getCkrCName()) + ")");
        ps.println(prefix + " ckrPad: byte[" + this.ckrPad.length + "]");
    }

    @Override
    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CatKeyRec:");
        this.printFields(ps, prefix);
    }

    @Override
    public byte[] getBytes() {
        byte[] result = new byte[this.occupiedSize()];
        int offset = 0;
        System.arraycopy(this.ckrKeyLen, 0, result, offset, this.ckrKeyLen.length);
        System.arraycopy(this.ckrResrv1, 0, result, offset += this.ckrKeyLen.length, this.ckrResrv1.length);
        System.arraycopy(this.ckrParID, 0, result, offset += this.ckrResrv1.length, this.ckrParID.length);
        System.arraycopy(this.ckrCNameLen, 0, result, offset += this.ckrParID.length, this.ckrCNameLen.length);
        System.arraycopy(this.ckrCName, 0, result, offset += this.ckrCNameLen.length, this.ckrCName.length);
        System.arraycopy(this.ckrPad, 0, result, offset += this.ckrCName.length, this.ckrPad.length);
        offset += this.ckrPad.length;
        return result;
    }

    @Override
    public int maxSize() {
        return 38;
    }

    @Override
    public int occupiedSize() {
        return 1 + Util.unsign(this.getCkrKeyLen());
    }

    @Override
    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CatKeyRec.class.getSimpleName());
        db.addUIntBE("ckrKeyLen", this.ckrKeyLen, "Key length", "bytes");
        db.addUIntBE("ckrResrv1", this.ckrResrv1, "Reserved", HEXADECIMAL);
        db.addUIntBE("ckrParID", this.ckrParID, "Parent ID");
        db.addUIntBE("ckrCNameLen", this.ckrCNameLen, "Length of record name", "bytes");
        db.add("ckrCName", new ASCIIStringField(this.ckrCName), "Record name");
        return db.getResult();
    }

    private static int relstringCompare(byte[] a, int aoff, int alen, byte[] b, int boff, int blen) {
        int compareLen = Math.min(alen, blen);
        for (int i = 0; i < compareLen; ++i) {
            int bRel;
            int aRel;
            byte aCur = a[aoff + i];
            byte bCur = b[boff + i];
            if (aCur == bCur || (aRel = HFS_RELSTRING_KEY_COMPARE_TABLE[aCur & 0xFF] & 0xFFFF) == (bRel = HFS_RELSTRING_KEY_COMPARE_TABLE[bCur & 0xFF] & 0xFFFF)) continue;
            return aRel - bRel;
        }
        return alen - blen;
    }

    private static int relstringCompare(byte[] a, byte[] b) {
        return CatKeyRec.relstringCompare(a, 0, a.length, b, 0, b.length);
    }

    @Override
    public int compareTo(CatKeyRec o) {
        long theirParID;
        long ourParID = Util.unsign(this.getCkrParID());
        if (ourParID == (theirParID = Util.unsign(o.getCkrParID()))) {
            int res2 = CatKeyRec.relstringCompare(this.getCkrCName(), o.getCkrCName());
            if (res2 == 0) {
                return 0;
            }
            if (res2 > 0) {
                return 1;
            }
            return -1;
        }
        if (ourParID > theirParID) {
            return 1;
        }
        return -1;
    }
}

