/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.util.Util;

public class BTHdrRec
implements PrintableStruct,
StructElements {
    public static final int STRUCTSIZE = 106;
    private final byte[] bthDepth = new byte[2];
    private final byte[] bthRoot = new byte[4];
    private final byte[] bthNRecs = new byte[4];
    private final byte[] bthFNode = new byte[4];
    private final byte[] bthLNode = new byte[4];
    private final byte[] bthNodeSize = new byte[2];
    private final byte[] bthKeyLen = new byte[2];
    private final byte[] bthNNodes = new byte[4];
    private final byte[] bthFree = new byte[4];
    private final byte[] bthResv = new byte[76];

    public BTHdrRec(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.bthDepth, 0, 2);
        System.arraycopy(data, offset + 2, this.bthRoot, 0, 4);
        System.arraycopy(data, offset + 6, this.bthNRecs, 0, 4);
        System.arraycopy(data, offset + 10, this.bthFNode, 0, 4);
        System.arraycopy(data, offset + 14, this.bthLNode, 0, 4);
        System.arraycopy(data, offset + 18, this.bthNodeSize, 0, 2);
        System.arraycopy(data, offset + 20, this.bthKeyLen, 0, 2);
        System.arraycopy(data, offset + 22, this.bthNNodes, 0, 4);
        System.arraycopy(data, offset + 26, this.bthFree, 0, 4);
        System.arraycopy(data, offset + 30, this.bthResv, 0, 76);
    }

    public static int length() {
        return 106;
    }

    public short getBthDepth() {
        return Util.readShortBE(this.bthDepth);
    }

    public int getBthRoot() {
        return Util.readIntBE(this.bthRoot);
    }

    public int getBthNRecs() {
        return Util.readIntBE(this.bthNRecs);
    }

    public int getBthFNode() {
        return Util.readIntBE(this.bthFNode);
    }

    public int getBthLNode() {
        return Util.readIntBE(this.bthLNode);
    }

    public short getBthNodeSize() {
        return Util.readShortBE(this.bthNodeSize);
    }

    public short getBthKeyLen() {
        return Util.readShortBE(this.bthKeyLen);
    }

    public int getBthNNodes() {
        return Util.readIntBE(this.bthNNodes);
    }

    public int getBthFree() {
        return Util.readIntBE(this.bthFree);
    }

    public byte[] getBthResv() {
        return Util.readByteArrayBE(this.bthResv);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " bthDepth: " + this.getBthDepth());
        ps.println(prefix + " bthRoot: " + this.getBthRoot());
        ps.println(prefix + " bthNRecs: " + this.getBthNRecs());
        ps.println(prefix + " bthFNode: " + this.getBthFNode());
        ps.println(prefix + " bthLNode: " + this.getBthLNode());
        ps.println(prefix + " bthNodeSize: " + this.getBthNodeSize());
        ps.println(prefix + " bthKeyLen: " + this.getBthKeyLen());
        ps.println(prefix + " bthNNodes: " + this.getBthNNodes());
        ps.println(prefix + " bthFree: " + this.getBthFree());
        ps.println(prefix + " bthResv: " + this.getBthResv());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BTHdrRec:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[106];
        int offset = 0;
        System.arraycopy(this.bthDepth, 0, result, offset, this.bthDepth.length);
        System.arraycopy(this.bthRoot, 0, result, offset += this.bthDepth.length, this.bthRoot.length);
        System.arraycopy(this.bthNRecs, 0, result, offset += this.bthRoot.length, this.bthNRecs.length);
        System.arraycopy(this.bthFNode, 0, result, offset += this.bthNRecs.length, this.bthFNode.length);
        System.arraycopy(this.bthLNode, 0, result, offset += this.bthFNode.length, this.bthLNode.length);
        System.arraycopy(this.bthNodeSize, 0, result, offset += this.bthLNode.length, this.bthNodeSize.length);
        System.arraycopy(this.bthKeyLen, 0, result, offset += this.bthNodeSize.length, this.bthKeyLen.length);
        System.arraycopy(this.bthNNodes, 0, result, offset += this.bthKeyLen.length, this.bthNNodes.length);
        System.arraycopy(this.bthFree, 0, result, offset += this.bthNNodes.length, this.bthFree.length);
        System.arraycopy(this.bthResv, 0, result, offset += this.bthFree.length, this.bthResv.length);
        offset += this.bthResv.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(BTHdrRec.class.getSimpleName());
        db.addUIntBE("bthDepth", this.bthDepth, "Depth");
        db.addUIntBE("bthRoot", this.bthRoot, "Root node");
        db.addUIntBE("bthNRecs", this.bthNRecs, "Number of leaf records");
        db.addUIntBE("bthFNode", this.bthFNode, "First leaf node");
        db.addUIntBE("bthLNode", this.bthLNode, "Last leaf node");
        db.addUIntBE("bthNodeSize", this.bthNodeSize, "Node size");
        db.addUIntBE("bthKeyLen", this.bthKeyLen, "Maximum key length");
        db.addUIntBE("bthNNodes", this.bthNNodes, "Total number of nodes");
        db.addUIntBE("bthFree", this.bthFree, "Number of free nodes");
        return db.getResult();
    }
}

