/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.finder;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.carbon.OSType;
import org.catacombae.hfs.types.finder.CommonFinderInfo;

public class FileInfo
extends CommonFinderInfo
implements PrintableStruct,
StructElements {
    private final OSType fileType;
    private final OSType fileCreator;

    public FileInfo(byte[] data, int offset) {
        super(data, offset);
        this.fileType = new OSType(data, offset + 0);
        this.fileCreator = new OSType(data, offset + 4);
    }

    public static int length() {
        return 16;
    }

    public byte[] getBytes() {
        byte[] result = new byte[FileInfo.length()];
        int offset = 0;
        byte[] tempData = this.fileType.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        tempData = this.fileCreator.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        tempData = super.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        return result;
    }

    public OSType getFileType() {
        return this.fileType;
    }

    public OSType getFileCreator() {
        return this.fileCreator;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " fileType: ");
        this.getFileType().print(ps, prefix + "  ");
        ps.println(prefix + " fileCreator: ");
        this.getFileCreator().print(ps, prefix + "  ");
        super.printFields(ps, prefix);
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "FileInfo:");
        this.printFields(ps, prefix);
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(FileInfo.class.getSimpleName());
        db.add("fileType", this.fileType.getStructElements());
        db.add("fileCreator", this.fileCreator.getStructElements());
        db.addAll(super.getStructElements());
        return db.getResult();
    }
}

