/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.finder;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.finder.CommonExtendedFinderInfo;
import org.catacombae.util.Util;

public class ExtendedFileInfo
extends CommonExtendedFinderInfo
implements PrintableStruct,
StructElements {
    private final byte[] reserved1 = new byte[8];

    public ExtendedFileInfo(byte[] data, int offset) {
        super(data, offset);
        System.arraycopy(data, offset + 0, this.reserved1, 0, 8);
    }

    public static int length() {
        return 16;
    }

    public byte[] getBytes() {
        byte[] result = new byte[ExtendedFileInfo.length()];
        int offset = 0;
        System.arraycopy(this.reserved1, 0, result, offset, this.reserved1.length);
        byte[] tempData = super.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.reserved1.length, tempData.length);
        offset += tempData.length;
        return result;
    }

    public short[] getReserved1() {
        return Util.readShortArrayBE(this.reserved1);
    }

    public void printFields(PrintStream ps, String prefix) {
        short[] tmp = this.getReserved1();
        ps.println(prefix + " reserved1: { " + "0x" + Util.toHexStringBE(tmp[0]) + ", " + "0x" + Util.toHexStringBE(tmp[1]) + ", " + "0x" + Util.toHexStringBE(tmp[2]) + ", " + "0x" + Util.toHexStringBE(tmp[3]) + " }");
        super.printFields(ps, prefix);
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ExtendedFileInfo:");
        this.printFields(ps, prefix);
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(ExtendedFileInfo.class.getName());
        db.addIntArray("reserved1", this.reserved1, BITS_16, UNSIGNED, BIG_ENDIAN);
        db.addAll(super.getStructElements());
        return db.getResult();
    }
}

