/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.finder;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.carbon.Point;
import org.catacombae.util.Util;

public abstract class CommonFinderInfo
implements StructElements,
PrintableStruct {
    public static final int[] COLOR_1 = new int[]{169, 169, 169};
    public static final int[] COLOR_2 = new int[]{149, 228, 40};
    public static final int[] COLOR_3 = new int[]{255, 108, 185};
    public static final int[] COLOR_4 = new int[]{0, 176, 229};
    public static final int[] COLOR_5 = new int[]{255, 230, 32};
    public static final int[] COLOR_6 = new int[]{255, 64, 84};
    public static final int[] COLOR_7 = new int[]{255, 184, 31};
    public static final int kIsOnDesk = 1;
    public static final int kColor = 14;
    public static final int kIsShared = 64;
    public static final int kHasNoINITs = 128;
    public static final int kHasBeenInited = 256;
    public static final int kHasCustomIcon = 1024;
    public static final int kIsStationery = 2048;
    public static final int kNameLocked = 4096;
    public static final int kHasBundle = 8192;
    public static final int kIsInvisible = 16384;
    public static final int kIsAlias = 32768;
    protected final byte[] finderFlags = new byte[2];
    protected final Point location;
    protected final byte[] reservedField = new byte[2];

    protected CommonFinderInfo(byte[] data, int offset) {
        System.arraycopy(data, offset + 8, this.finderFlags, 0, 2);
        this.location = new Point(data, offset + 10);
        System.arraycopy(data, offset + 14, this.reservedField, 0, 2);
    }

    public static int length() {
        return 8;
    }

    public short getFinderFlags() {
        return Util.readShortBE(this.finderFlags);
    }

    public Point getLocation() {
        return this.location;
    }

    public short getReservedField() {
        return Util.readShortBE(this.reservedField);
    }

    public boolean getFinderFlagIsOnDesk() {
        return (this.getFinderFlags() & 1) != 0;
    }

    public byte getFinderFlagColor() {
        return (byte)((this.getFinderFlags() & 0xE) >> 1);
    }

    public int[] getFinderFlagColorRGB() {
        byte color = this.getFinderFlagColor();
        switch (color) {
            case 0: {
                return null;
            }
            case 1: {
                return COLOR_1;
            }
            case 2: {
                return COLOR_2;
            }
            case 3: {
                return COLOR_3;
            }
            case 4: {
                return COLOR_4;
            }
            case 5: {
                return COLOR_5;
            }
            case 6: {
                return COLOR_6;
            }
            case 7: {
                return COLOR_7;
            }
        }
        throw new RuntimeException("Color out of range! (" + color + ")");
    }

    public boolean getFinderFlagIsShared() {
        return (this.getFinderFlags() & 0x40) != 0;
    }

    public boolean getFinderFlagHasNoINITs() {
        return (this.getFinderFlags() & 0x80) != 0;
    }

    public boolean getFinderFlagHasBeenInited() {
        return (this.getFinderFlags() & 0x100) != 0;
    }

    public boolean getFinderFlagHasCustomIcon() {
        return (this.getFinderFlags() & 0x400) != 0;
    }

    public boolean getFinderFlagIsStationery() {
        return (this.getFinderFlags() & 0x800) != 0;
    }

    public boolean getFinderFlagNameLocked() {
        return (this.getFinderFlags() & 0x1000) != 0;
    }

    public boolean getFinderFlagHasBundle() {
        return (this.getFinderFlags() & 0x2000) != 0;
    }

    public boolean getFinderFlagIsInvisible() {
        return (this.getFinderFlags() & 0x4000) != 0;
    }

    public boolean getFinderFlagIsAlias() {
        return (this.getFinderFlags() & 0x8000) != 0;
    }

    public byte[] getBytes() {
        byte[] result = new byte[CommonFinderInfo.length()];
        int offset = 0;
        System.arraycopy(this.finderFlags, 0, result, offset, this.finderFlags.length);
        byte[] tempData = this.location.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.finderFlags.length, tempData.length);
        System.arraycopy(this.reservedField, 0, result, offset += tempData.length, this.reservedField.length);
        offset += this.reservedField.length;
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " finderFlags: 0x" + Util.toHexStringBE(this.getFinderFlags()));
        ps.println(prefix + "  kIsOnDesk: " + (this.getFinderFlagIsOnDesk() ? "1" : "0"));
        ps.println(prefix + "  kColor: 0x" + Util.toHexStringBE(this.getFinderFlagColor()));
        ps.println(prefix + "  kIsShared: " + (this.getFinderFlagIsShared() ? "1" : "0"));
        ps.println(prefix + "  kHasNoINITs: " + (this.getFinderFlagHasNoINITs() ? "1" : "0"));
        ps.println(prefix + "  kHasBeenInited: " + (this.getFinderFlagHasBeenInited() ? "1" : "0"));
        ps.println(prefix + "  kHasCustomIcon: " + (this.getFinderFlagHasCustomIcon() ? "1" : "0"));
        ps.println(prefix + "  kIsStationery: " + (this.getFinderFlagIsStationery() ? "1" : "0"));
        ps.println(prefix + "  kNameLocked: " + (this.getFinderFlagNameLocked() ? "1" : "0"));
        ps.println(prefix + "  kHasBundle: " + (this.getFinderFlagHasBundle() ? "1" : "0"));
        ps.println(prefix + "  kIsInvisible: " + (this.getFinderFlagIsInvisible() ? "1" : "0"));
        ps.println(prefix + "  kIsAlias: " + (this.getFinderFlagIsAlias() ? "1" : "0"));
        ps.println(prefix + " location: ");
        this.getLocation().print(ps, prefix + "  ");
        ps.println(prefix + " reservedField: 0x" + Util.toHexStringBE(this.getReservedField()));
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CommonFinderInfo.class.getSimpleName());
        StructElements.DictionaryBuilder dbFinderFlags = new StructElements.DictionaryBuilder("UInt16");
        dbFinderFlags.addFlag("kIsAlias", this.finderFlags, 15);
        dbFinderFlags.addFlag("kIsInvisible", this.finderFlags, 14);
        dbFinderFlags.addFlag("kHasBundle", this.finderFlags, 13);
        dbFinderFlags.addFlag("kNameLocked", this.finderFlags, 12);
        dbFinderFlags.addFlag("kIsStationery", this.finderFlags, 11);
        dbFinderFlags.addFlag("kHasCustomIcon", this.finderFlags, 10);
        dbFinderFlags.addFlag("kHasBeenInited", this.finderFlags, 8);
        dbFinderFlags.addFlag("kHasNoINITs", this.finderFlags, 7);
        dbFinderFlags.addFlag("kIsShared", this.finderFlags, 6);
        dbFinderFlags.addFlag("kIsOnDesk", this.finderFlags, 1);
        Dictionary finderFlagsDictionary = db.getResult();
        db.add("finderFlags", finderFlagsDictionary, "Finder flags");
        db.add("location", this.location.getStructElements(), "Location");
        db.addUIntBE("reservedField", this.reservedField, "Reserved");
        return db.getResult();
    }
}

