/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.decmpfs;

import java.io.PrintStream;
import java.math.BigInteger;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.util.Util;

public class DecmpfsHeader
implements PrintableStruct {
    public static final int STRUCTSIZE = 16;
    private int magic;
    private int compressionType;
    private long fileSize;

    public DecmpfsHeader(byte[] data, int offset) {
        this.magic = Util.readIntBE(data, offset + 0);
        this.compressionType = Util.readIntBE(data, offset + 4);
        this.fileSize = Util.readLongBE(data, offset + 8);
    }

    public static int length() {
        return 16;
    }

    public final long getMagic() {
        return Util.unsign(this.getRawMagic());
    }

    public final long getCompressionType() {
        return Util.unsign(this.getRawCompressionType());
    }

    public final BigInteger getFileSize() {
        return Util.unsign(this.getRawFileSize());
    }

    public final int getRawMagic() {
        return Util.byteSwap(this.magic);
    }

    public final int getRawCompressionType() {
        return Util.byteSwap(this.compressionType);
    }

    public final long getRawFileSize() {
        return Util.byteSwap(this.fileSize);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " magic: " + this.getMagic());
        ps.println(prefix + " compressionType: " + this.getCompressionType());
        ps.println(prefix + " fileSize: " + this.getFileSize());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "DecmpfsHeader:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[DecmpfsHeader.length()];
        this.getBytes(result, 0);
        return result;
    }

    public int getBytes(byte[] result, int offset) {
        int startOffset = offset;
        Util.arrayPutBE(result, offset, this.magic);
        Util.arrayPutBE(result, offset += 4, this.compressionType);
        Util.arrayPutBE(result, offset += 4, this.fileSize);
        return (offset += 8) - startOffset;
    }
}

