/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.carbon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.util.Util;

public class Rect
implements PrintableStruct,
StructElements {
    public static final int STRUCTSIZE = 8;
    private final byte[] top = new byte[2];
    private final byte[] left = new byte[2];
    private final byte[] bottom = new byte[2];
    private final byte[] right = new byte[2];

    public Rect(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.top, 0, 2);
        System.arraycopy(data, offset + 2, this.left, 0, 2);
        System.arraycopy(data, offset + 4, this.bottom, 0, 2);
        System.arraycopy(data, offset + 6, this.right, 0, 2);
    }

    public static int length() {
        return 8;
    }

    public short getTop() {
        return Util.readShortBE(this.top);
    }

    public short getLeft() {
        return Util.readShortBE(this.left);
    }

    public short getBottom() {
        return Util.readShortBE(this.bottom);
    }

    public short getRight() {
        return Util.readShortBE(this.right);
    }

    public String toString() {
        return "(" + this.getTop() + "," + this.getLeft() + "," + this.getBottom() + "," + this.getRight() + ")";
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " top: " + this.getTop());
        ps.println(prefix + " left: " + this.getLeft());
        ps.println(prefix + " bottom: " + this.getBottom());
        ps.println(prefix + " right: " + this.getRight());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "Rect:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[8];
        int offset = 0;
        System.arraycopy(this.top, 0, result, offset, this.top.length);
        System.arraycopy(this.left, 0, result, offset += this.top.length, this.left.length);
        System.arraycopy(this.bottom, 0, result, offset += this.left.length, this.bottom.length);
        System.arraycopy(this.right, 0, result, offset += this.bottom.length, this.right.length);
        offset += this.right.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(Rect.class.getSimpleName());
        db.addUIntBE("top", this.top, "Top");
        db.addUIntBE("left", this.left, "Left");
        db.addUIntBE("bottom", this.bottom, "Bottom");
        db.addUIntBE("right", this.right, "Right");
        return db.getResult();
    }
}

