/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.plus;

import org.catacombae.hfs.AllocationFile;
import org.catacombae.hfs.AttributesFile;
import org.catacombae.hfs.BTreeOperations;
import org.catacombae.hfs.CatalogOperations;
import org.catacombae.hfs.ExtentsOverflowOperations;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.HotFilesFile;
import org.catacombae.hfs.Journal;
import org.catacombae.hfs.io.ForkFilter;
import org.catacombae.hfs.plus.HFSPlusAllocationFile;
import org.catacombae.hfs.plus.HFSPlusJournal;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkType;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfs.types.hfsplus.BTHeaderRec;
import org.catacombae.hfs.types.hfsplus.BTNodeDescriptor;
import org.catacombae.hfs.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentKey;
import org.catacombae.hfs.types.hfsplus.HFSPlusVolumeHeader;
import org.catacombae.hfs.types.hfsplus.HFSUniStr255;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessSubstream;
import org.catacombae.io.SynchronizedReadableRandomAccess;
import org.catacombae.util.Util;

public class HFSPlusVolume
extends HFSVolume {
    private static final CommonHFSCatalogString EMPTY_STRING = CommonHFSCatalogString.createHFSPlus(new HFSUniStr255(""));
    private static final BTreeOperations btreeOperations = new HFSPlusBTreeOperations();
    private static final ExtentsOverflowOperations extentsOverflowOperations = new HFSPlusExtentsOverflowOperations();
    private final HFSPlusAllocationFile allocationFile = this.createAllocationFile();
    private final HFSPlusJournal journal = new HFSPlusJournal(this);
    private final AttributesFile attributesFile = this.getHFSPlusVolumeHeader().getAttributesFile().getExtents().getExtentDescriptors()[0].getBlockCount() == 0 ? null : new AttributesFile(this, (BTreeOperations)new HFSPlusBTreeOperations());

    public HFSPlusVolume(ReadableRandomAccessStream hfsFile, boolean cachingEnabled) {
        this(hfsFile, cachingEnabled, new HFSPlusCatalogOperations());
    }

    protected HFSPlusVolume(ReadableRandomAccessStream hfsFile, boolean cachingEnabled, CatalogOperations catalogOperations) {
        super(hfsFile, cachingEnabled, btreeOperations, catalogOperations, extentsOverflowOperations);
    }

    SynchronizedReadableRandomAccess getBackingStream() {
        return this.hfsFile;
    }

    public HFSPlusVolumeHeader getHFSPlusVolumeHeader() {
        byte[] currentBlock = new byte[512];
        this.hfsFile.readFrom(1024L, currentBlock);
        return new HFSPlusVolumeHeader(currentBlock);
    }

    public CommonHFSVolumeHeader getVolumeHeader() {
        return CommonHFSVolumeHeader.create(this.getHFSPlusVolumeHeader());
    }

    private HFSPlusAllocationFile createAllocationFile() {
        HFSPlusVolumeHeader vh = this.getHFSPlusVolumeHeader();
        CommonHFSForkData allocationFileFork = CommonHFSForkData.create(vh.getAllocationFile());
        ForkFilter allocationFileStream = new ForkFilter(ForkFilter.ForkType.DATA, this.getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID.ALLOCATION_FILE).toLong(), allocationFileFork, this.extentsOverflowFile, new ReadableRandomAccessSubstream(this.hfsFile), 0L, Util.unsign(vh.getBlockSize()), 0L);
        return new HFSPlusAllocationFile(this, (ReadableRandomAccessStream)allocationFileStream);
    }

    public AllocationFile getAllocationFile() {
        return this.allocationFile;
    }

    public boolean hasAttributesFile() {
        return this.attributesFile != null;
    }

    public AttributesFile getAttributesFile() {
        return this.attributesFile;
    }

    public boolean hasJournal() {
        return this.getHFSPlusVolumeHeader().getAttributeVolumeJournaled();
    }

    public Journal getJournal() {
        if (this.hasJournal()) {
            return this.journal;
        }
        return null;
    }

    public boolean hasHotFilesFile() {
        return false;
    }

    public HotFilesFile getHotFilesFile() {
        return null;
    }

    public CommonHFSCatalogNodeID getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID requestedNodeID) {
        return CommonHFSCatalogNodeID.getHFSPlusReservedID(requestedNodeID);
    }

    public CommonHFSExtentKey createCommonHFSExtentKey(boolean isResource, int cnid, long startBlock) {
        if (startBlock > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value of 'startBlock' is too large for an HFS+ extent key.");
        }
        return CommonHFSExtentKey.create(new HFSPlusExtentKey(isResource ? (byte)-1 : 0, new HFSCatalogNodeID(cnid), (int)startBlock));
    }

    public CommonHFSCatalogString getEmptyString() {
        return EMPTY_STRING;
    }

    public String decodeString(CommonHFSCatalogString str) {
        if (str instanceof CommonHFSCatalogString.HFSPlusImplementation) {
            CommonHFSCatalogString.HFSPlusImplementation hStr = (CommonHFSCatalogString.HFSPlusImplementation)str;
            return new String(hStr.getInternal().getUnicode());
        }
        throw new RuntimeException("Invalid string type: " + str.getClass());
    }

    public CommonHFSCatalogString encodeString(String str) {
        return CommonHFSCatalogString.HFSPlusImplementation.createHFSPlus(new HFSUniStr255(str));
    }

    public void close() {
        this.allocationFile.close();
        super.close();
    }

    private static class HFSPlusExtentsOverflowOperations
    implements ExtentsOverflowOperations {
        private HFSPlusExtentsOverflowOperations() {
        }

        public CommonHFSExtentIndexNode createCommonHFSExtentIndexNode(byte[] currentNodeData, int offset, int nodeSize) {
            return CommonHFSExtentIndexNode.createHFSPlus(currentNodeData, offset, nodeSize);
        }

        public CommonHFSExtentLeafNode createCommonHFSExtentLeafNode(byte[] currentNodeData, int offset, int nodeSize) {
            return CommonHFSExtentLeafNode.createHFSPlus(currentNodeData, offset, nodeSize);
        }

        public CommonHFSExtentKey createCommonHFSExtentKey(CommonHFSForkType forkType, CommonHFSCatalogNodeID fileID, int startBlock) {
            byte forkTypeByte;
            switch (forkType) {
                case DATA_FORK: {
                    forkTypeByte = 0;
                    break;
                }
                case RESOURCE_FORK: {
                    forkTypeByte = -1;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid fork type");
                }
            }
            HFSPlusExtentKey key = new HFSPlusExtentKey(forkTypeByte, new HFSCatalogNodeID((int)fileID.toLong()), startBlock);
            return CommonHFSExtentKey.create(key);
        }
    }

    private static class HFSPlusCatalogOperations
    implements CatalogOperations {
        private HFSPlusCatalogOperations() {
        }

        public CommonHFSCatalogIndexNode newCatalogIndexNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogIndexNode.createHFSPlus(data, offset, nodeSize);
        }

        public CommonHFSCatalogKey newCatalogKey(CommonHFSCatalogNodeID nodeID, CommonHFSCatalogString searchString, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogKey.create(new HFSPlusCatalogKey(new HFSCatalogNodeID((int)nodeID.toLong()), new HFSUniStr255(searchString.getStructBytes(), 0)));
        }

        public CommonHFSCatalogLeafNode newCatalogLeafNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogLeafNode.createHFSPlus(data, offset, nodeSize);
        }

        public CommonHFSCatalogLeafRecord newCatalogLeafRecord(byte[] data, int offset, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogLeafRecord.createHFSPlus(data, offset, data.length - offset);
        }
    }

    private static class HFSPlusBTreeOperations
    implements BTreeOperations {
        private HFSPlusBTreeOperations() {
        }

        public CommonBTHeaderNode createCommonBTHeaderNode(byte[] currentNodeData, int offset, int nodeSize) {
            return CommonBTHeaderNode.createHFSPlus(currentNodeData, offset, nodeSize);
        }

        public CommonBTNodeDescriptor readNodeDescriptor(Readable rd) {
            byte[] data = new byte[BTNodeDescriptor.length()];
            rd.readFully(data);
            BTNodeDescriptor btnd = new BTNodeDescriptor(data, 0);
            return CommonBTNodeDescriptor.create(btnd);
        }

        public CommonBTHeaderRecord readHeaderRecord(Readable rd) {
            byte[] data = new byte[BTHeaderRec.length()];
            rd.readFully(data);
            BTHeaderRec bthr = new BTHeaderRec(data, 0);
            return CommonBTHeaderRecord.create(bthr);
        }

        public CommonBTNodeDescriptor createCommonBTNodeDescriptor(byte[] currentNodeData, int offset) {
            BTNodeDescriptor btnd = new BTNodeDescriptor(currentNodeData, offset);
            return CommonBTNodeDescriptor.create(btnd);
        }
    }
}

