/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.plus;

import java.util.LinkedList;
import org.catacombae.hfs.Journal;
import org.catacombae.hfs.plus.HFSPlusVolume;
import org.catacombae.hfs.types.hfsplus.BlockInfo;
import org.catacombae.hfs.types.hfsplus.BlockList;
import org.catacombae.hfs.types.hfsplus.BlockListHeader;
import org.catacombae.hfs.types.hfsplus.HFSPlusVolumeHeader;
import org.catacombae.hfs.types.hfsplus.JournalHeader;
import org.catacombae.hfs.types.hfsplus.JournalInfoBlock;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.util.ObjectContainer;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HFSPlusJournal
extends Journal {
    private final HFSPlusVolume vol;

    public HFSPlusJournal(HFSPlusVolume vol) {
        this.vol = vol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getInfoBlockData() {
        HFSPlusVolumeHeader vh = this.vol.getHFSPlusVolumeHeader();
        if (vh.getAttributeVolumeJournaled()) {
            long blockNumber = Util.unsign(vh.getJournalInfoBlock());
            byte[] data = new byte[JournalInfoBlock.getStructSize()];
            ReadableRandomAccessStream fsStream = this.vol.createFSStream();
            try {
                fsStream.seek(blockNumber * (long)vh.getBlockSize());
                fsStream.readFully(data);
            }
            finally {
                fsStream.close();
            }
            return data;
        }
        return null;
    }

    @Override
    public ReadableRandomAccessStream getJournalDataStream() {
        JournalInfoBlock infoBlock = this.getJournalInfoBlock();
        return this.getJournalDataStream(infoBlock);
    }

    private ReadableRandomAccessStream getJournalDataStream(JournalInfoBlock infoBlock) {
        if (!infoBlock.getFlagJournalInFS()) {
            return null;
        }
        if (infoBlock.getFlagJournalNeedInit()) {
            return null;
        }
        if (infoBlock.getRawOffset() < 0L) {
            throw new Error("SInt64 overflow for JournalInfoBlock.offset!");
        }
        if (infoBlock.getRawSize() < 0L) {
            throw new Error("SInt64 overflow for JournalInfoBlock.size!");
        }
        return new ReadableConcatenatedStream(this.vol.createFSStream(), infoBlock.getRawOffset(), infoBlock.getRawSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getJournalData() {
        ReadableRandomAccessStream fsStream = this.getJournalDataStream();
        if (fsStream.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("Java int overflow!");
        }
        byte[] dataBuffer = new byte[(int)fsStream.length()];
        try {
            fsStream.readFully(dataBuffer);
        }
        finally {
            fsStream.close();
        }
        return dataBuffer;
    }

    @Override
    public JournalInfoBlock getJournalInfoBlock() {
        byte[] infoBlockData = this.getInfoBlockData();
        if (infoBlockData != null) {
            return new JournalInfoBlock(infoBlockData, 0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JournalHeader getJournalHeader() {
        JournalInfoBlock infoBlock = this.getJournalInfoBlock();
        ReadableRandomAccessStream journalStream = this.getJournalDataStream(infoBlock);
        try {
            JournalHeader journalHeader = journalStream != null ? this.getJournalHeader(infoBlock, journalStream) : null;
            return journalHeader;
        }
        finally {
            if (journalStream != null) {
                journalStream.close();
            }
        }
    }

    private JournalHeader getJournalHeader(JournalInfoBlock infoBlock, ReadableRandomAccessStream journalStream) {
        byte[] headerData = new byte[JournalHeader.length()];
        journalStream.readFully(headerData);
        JournalHeader jh = new JournalHeader(headerData, 0);
        if (jh.getRawChecksum() != jh.calculateChecksum()) {
            throw new RuntimeException("Invalid journal header checksum (expected 0x" + Util.toHexStringBE(jh.getRawChecksum()) + ", got 0x" + Util.toHexStringBE(jh.calculateChecksum()) + ").");
        }
        if (infoBlock.getRawSize() != jh.getRawSize()) {
            throw new RuntimeException("Inconsistency between journal size as described by journal info block (" + infoBlock.getSize() + ") and journal header (" + jh.getSize() + ").");
        }
        return jh;
    }

    @Override
    public boolean isClean() {
        JournalHeader journalHeader = this.getJournalHeader();
        return journalHeader.getRawStart() == journalHeader.getRawEnd();
    }

    private long wrappedReadFully(ReadableRandomAccessStream stream, long currentPos, byte[] data, int offset, int length, ObjectContainer<Boolean> wrappedAround) {
        long res;
        int bytesRead = stream.read(data, offset, length);
        if (bytesRead != length) {
            if (((Boolean)wrappedAround.o).booleanValue()) {
                throw new RuntimeException("Wrapped around twice!");
            }
            res = length - bytesRead;
            wrappedAround.o = true;
            stream.seek(0L);
            bytesRead += stream.read(data, offset + bytesRead, length - bytesRead);
        } else {
            res = currentPos + (long)length;
        }
        if (bytesRead != length) {
            throw new RuntimeIOException("Failed to read requested amount when doing wrapped read. Expected " + length + " " + "bytes, got " + bytesRead + " bytes.");
        }
        return res;
    }

    private long wrappedReadFully(ReadableRandomAccessStream stream, long currentPos, byte[] data, ObjectContainer<Boolean> wrappedAround) {
        return this.wrappedReadFully(stream, currentPos, data, 0, data.length, wrappedAround);
    }

    @Override
    public Journal.Transaction[] getPendingTransactions() {
        JournalInfoBlock infoBlock = this.getJournalInfoBlock();
        ReadableRandomAccessStream journalStream = this.getJournalDataStream(infoBlock);
        JournalHeader jh = this.getJournalHeader(infoBlock, journalStream);
        long start = jh.getRawStart();
        long end = jh.getRawEnd();
        long size = jh.getRawSize();
        int blockListHeaderSize = jh.getRawBlhdrSize();
        if (start < 0L) {
            throw new RuntimeException("'start' overflows.");
        }
        if (end < 0L) {
            throw new RuntimeException("'end' overflows.");
        }
        if (size < 0L) {
            throw new RuntimeException("'size' overflows.");
        }
        if (blockListHeaderSize < 0) {
            throw new RuntimeException("'blockListHeaderSize' overflows.");
        }
        if (start == end) {
            return new Journal.Transaction[0];
        }
        LinkedList<Journal.Transaction> pendingTransactionList = new LinkedList<Journal.Transaction>();
        LinkedList<BlockList> curBlockListList = new LinkedList<BlockList>();
        LinkedList<BlockInfo> curBlockInfoList = new LinkedList<BlockInfo>();
        ObjectContainer<Boolean> wrappedAround = new ObjectContainer<Boolean>(false);
        byte[] tmpData = new byte[Math.max(BlockListHeader.length(), BlockInfo.length())];
        journalStream.seek(start);
        long i = start;
        while (i != end) {
            long curBytesRead = 0L;
            i = this.wrappedReadFully(journalStream, i, tmpData, 0, BlockListHeader.length(), wrappedAround);
            BlockListHeader curHeader = new BlockListHeader(tmpData, 0, jh.isLittleEndian());
            if (curHeader.getNumBlocks() < 1) {
                throw new RuntimeException("Empty block list makes no sense.");
            }
            if (curHeader.getMaxBlocks() * 16 + 16 != blockListHeaderSize) {
                throw new RuntimeException("Unexpected value for maxBlocks member of BlockListHeader: " + curHeader.getMaxBlocks());
            }
            curBytesRead += (long)BlockListHeader.length();
            curBlockInfoList.clear();
            for (int j = 0; j < curHeader.getNumBlocks(); ++j) {
                i = this.wrappedReadFully(journalStream, i, tmpData, 0, BlockInfo.length(), wrappedAround);
                curBlockInfoList.add(new BlockInfo(tmpData, 0, jh.isLittleEndian()));
                curBytesRead += (long)BlockInfo.length();
            }
            if (curHeader.calculateChecksum((BlockInfo)curBlockInfoList.getFirst()) != curHeader.getRawChecksum()) {
                throw new RuntimeException("Checksum mismatch for header (expected: 0x" + Util.toHexStringBE(curHeader.getRawChecksum()) + " " + "actual: 0x" + Util.toHexStringBE(curHeader.calculateChecksum((BlockInfo)curBlockInfoList.getFirst())) + ")");
            }
            byte[] curReserved = new byte[(int)((long)blockListHeaderSize - curBytesRead)];
            i = this.wrappedReadFully(journalStream, i, curReserved, wrappedAround);
            curBytesRead += (long)curReserved.length;
            LinkedList<byte[]> curBlockDataList = new LinkedList<byte[]>();
            for (BlockInfo bi : curBlockInfoList) {
                if (curBlockDataList.size() < 1) {
                    curBlockDataList.add(new byte[0]);
                    continue;
                }
                int bsize = bi.getRawBsize();
                if (bsize > Integer.MAX_VALUE) {
                    throw new RuntimeException("'int' overflow in 'bsize' (" + bi.getBsize() + ").");
                }
                byte[] data = new byte[bsize];
                i = this.wrappedReadFully(journalStream, i, data, wrappedAround);
                curBytesRead += (long)data.length;
                curBlockDataList.add(data);
            }
            BlockList curBlockList = new BlockList(curHeader, curBlockInfoList.toArray(new BlockInfo[curBlockInfoList.size()]), curReserved, (byte[][])curBlockDataList.toArray((T[])new byte[curBlockDataList.size()][]));
            curBlockListList.add(curBlockList);
            if (curBlockList.getBlockInfo(0).getNext() != 0L) continue;
            pendingTransactionList.add(new Journal.Transaction(curBlockListList.toArray(new BlockList[curBlockListList.size()])));
            curBlockListList.clear();
        }
        if (curBlockListList.size() != 0) {
            pendingTransactionList.add(new Journal.Transaction(curBlockListList.toArray(new BlockList[curBlockListList.size()])));
        }
        return pendingTransactionList.toArray(new Journal.Transaction[pendingTransactionList.size()]);
    }
}

