/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.plus;

import org.catacombae.hfs.AllocationFile;
import org.catacombae.hfs.plus.HFSPlusVolume;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentDescriptor;
import org.catacombae.io.ReadableRandomAccessStream;

public class HFSPlusAllocationFile
extends AllocationFile {
    private HFSPlusVolume hfsPlusParentView;
    private ReadableRandomAccessStream allocationFile;

    public HFSPlusAllocationFile(HFSPlusVolume parentView, ReadableRandomAccessStream allocationFile) {
        super(parentView, allocationFile);
        this.hfsPlusParentView = parentView;
        this.allocationFile = allocationFile;
    }

    public boolean isAllocationBlockUsed(long blockNumber) throws IllegalArgumentException {
        if (blockNumber < 0L || blockNumber > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("Block number (" + blockNumber + ") out of range for UInt32!");
        }
        return super.isAllocationBlockUsed(blockNumber);
    }

    public CommonHFSExtentDescriptor createExtentDescriptor(long startBlock, long blockCount) {
        if (startBlock < 0L || startBlock > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("startBlock(" + startBlock + ") out of range for UInt32!");
        }
        if (blockCount < 0L || blockCount > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("blockCount(" + blockCount + ") out of range for UInt32!");
        }
        HFSPlusExtentDescriptor hped = new HFSPlusExtentDescriptor((int)startBlock, (int)blockCount);
        return CommonHFSExtentDescriptor.create(hped);
    }
}

