/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.original;

import org.catacombae.hfs.AllocationFile;
import org.catacombae.hfs.AttributesFile;
import org.catacombae.hfs.BTreeOperations;
import org.catacombae.hfs.CatalogOperations;
import org.catacombae.hfs.ExtentsOverflowOperations;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.HotFilesFile;
import org.catacombae.hfs.Journal;
import org.catacombae.hfs.original.CharsetStringCodec;
import org.catacombae.hfs.original.HFSOriginalAllocationFile;
import org.catacombae.hfs.original.MutableStringCodec;
import org.catacombae.hfs.types.hfs.BTHdrRec;
import org.catacombae.hfs.types.hfs.CatKeyRec;
import org.catacombae.hfs.types.hfs.ExtKeyRec;
import org.catacombae.hfs.types.hfs.MasterDirectoryBlock;
import org.catacombae.hfs.types.hfs.NodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkType;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessSubstream;
import org.catacombae.util.Util;

public class HFSOriginalVolume
extends HFSVolume {
    private static final CommonHFSCatalogString EMPTY_STRING = CommonHFSCatalogString.createHFS(new byte[0]);
    private final HFSOriginalAllocationFile allocationFile;
    private final MutableStringCodec<CharsetStringCodec> stringCodec;

    public HFSOriginalVolume(ReadableRandomAccessStream hfsFile, boolean cachingEnabled, String encodingName) {
        super(hfsFile, cachingEnabled, new HFSBTreeOperations(), new HFSCatalogOperations(), new HFSExtentsOverflowOperations());
        this.stringCodec = new MutableStringCodec<CharsetStringCodec>(new CharsetStringCodec(encodingName));
        this.allocationFile = this.createAllocationFile();
    }

    public MasterDirectoryBlock getHFSMasterDirectoryBlock() {
        byte[] currentBlock = new byte[512];
        this.hfsFile.readFrom(1024L, currentBlock);
        return new MasterDirectoryBlock(currentBlock, 0);
    }

    public CommonHFSVolumeHeader getVolumeHeader() {
        return CommonHFSVolumeHeader.create(this.getHFSMasterDirectoryBlock());
    }

    private HFSOriginalAllocationFile createAllocationFile() {
        MasterDirectoryBlock mdb = this.getHFSMasterDirectoryBlock();
        int numAllocationBlocks = Util.unsign(mdb.getDrNmAlBlks());
        int volumeBitmapSize = numAllocationBlocks / 8 + (numAllocationBlocks % 8 != 0 ? 1 : 0);
        ReadableConcatenatedStream volumeBitmapStream = new ReadableConcatenatedStream(new ReadableRandomAccessSubstream(this.hfsFile), (long)(512 * Util.unsign(mdb.getDrVBMSt())), (long)volumeBitmapSize);
        return new HFSOriginalAllocationFile(this, (ReadableRandomAccessStream)volumeBitmapStream);
    }

    public AllocationFile getAllocationFile() {
        return this.allocationFile;
    }

    public boolean hasAttributesFile() {
        return false;
    }

    public boolean hasJournal() {
        return false;
    }

    public boolean hasHotFilesFile() {
        return false;
    }

    public AttributesFile getAttributesFile() {
        return null;
    }

    public Journal getJournal() {
        return null;
    }

    public HotFilesFile getHotFilesFile() {
        return null;
    }

    public CommonHFSCatalogNodeID getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID requestedNodeID) {
        return CommonHFSCatalogNodeID.getHFSReservedID(requestedNodeID);
    }

    public CommonHFSExtentKey createCommonHFSExtentKey(boolean isResource, int cnid, long startBlock) {
        if (startBlock > 65535L) {
            throw new IllegalArgumentException("Value of 'startBlock' is too large for an HFS extent key.");
        }
        return CommonHFSExtentKey.create(new ExtKeyRec(isResource ? (byte)-1 : 0, cnid, (short)startBlock));
    }

    public CommonHFSCatalogString getEmptyString() {
        return EMPTY_STRING;
    }

    public void setStringEncoding(String encodingName) {
        this.stringCodec.setDecoder(new CharsetStringCodec(encodingName));
    }

    public String getStringEncoding() {
        return this.stringCodec.getDecoder().getCharsetName();
    }

    public String decodeString(CommonHFSCatalogString str) {
        if (str instanceof CommonHFSCatalogString.HFSImplementation) {
            return this.stringCodec.decode(str.getStringBytes());
        }
        throw new RuntimeException("Invalid string type: " + str.getClass());
    }

    public CommonHFSCatalogString encodeString(String str) {
        byte[] bytes = this.stringCodec.encode(str);
        return CommonHFSCatalogString.createHFS(bytes);
    }

    private static class HFSExtentsOverflowOperations
    implements ExtentsOverflowOperations {
        private HFSExtentsOverflowOperations() {
        }

        public CommonHFSExtentIndexNode createCommonHFSExtentIndexNode(byte[] currentNodeData, int i, int nodeSize) {
            return CommonHFSExtentIndexNode.createHFS(currentNodeData, i, nodeSize);
        }

        public CommonHFSExtentLeafNode createCommonHFSExtentLeafNode(byte[] currentNodeData, int i, int nodeSize) {
            return CommonHFSExtentLeafNode.createHFS(currentNodeData, i, nodeSize);
        }

        public CommonHFSExtentKey createCommonHFSExtentKey(CommonHFSForkType forkType, CommonHFSCatalogNodeID fileID, int startBlock) {
            byte forkTypeByte;
            if (startBlock < Short.MIN_VALUE || startBlock > Short.MAX_VALUE) {
                throw new IllegalArgumentException("start block out of range for short (signed 16-bit integer)");
            }
            short startBlockShort = (short)startBlock;
            switch (forkType) {
                case DATA_FORK: {
                    forkTypeByte = 0;
                    break;
                }
                case RESOURCE_FORK: {
                    forkTypeByte = -1;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid fork type");
                }
            }
            ExtKeyRec key = new ExtKeyRec(forkTypeByte, (int)fileID.toLong(), startBlockShort);
            return CommonHFSExtentKey.create(key);
        }
    }

    private static class HFSCatalogOperations
    implements CatalogOperations {
        private HFSCatalogOperations() {
        }

        public CommonHFSCatalogIndexNode newCatalogIndexNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogIndexNode.createHFS(data, offset, nodeSize);
        }

        public CommonHFSCatalogKey newCatalogKey(CommonHFSCatalogNodeID nodeID, CommonHFSCatalogString searchString, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogKey.create(new CatKeyRec((int)nodeID.toLong(), searchString.getStringBytes()));
        }

        public CommonHFSCatalogLeafNode newCatalogLeafNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogLeafNode.createHFS(data, offset, nodeSize);
        }

        public CommonHFSCatalogLeafRecord newCatalogLeafRecord(byte[] data, int offset, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogLeafRecord.createHFS(data, offset, data.length - offset);
        }
    }

    private static class HFSBTreeOperations
    implements BTreeOperations {
        private HFSBTreeOperations() {
        }

        public CommonBTHeaderNode createCommonBTHeaderNode(byte[] currentNodeData, int offset, int nodeSize) {
            return CommonBTHeaderNode.createHFS(currentNodeData, offset, nodeSize);
        }

        public CommonBTNodeDescriptor readNodeDescriptor(Readable rd) {
            byte[] data = new byte[NodeDescriptor.length()];
            rd.readFully(data);
            return this.createCommonBTNodeDescriptor(data, 0);
        }

        public CommonBTHeaderRecord readHeaderRecord(Readable rd) {
            byte[] data = new byte[BTHdrRec.length()];
            rd.readFully(data);
            BTHdrRec bthr = new BTHdrRec(data, 0);
            return CommonBTHeaderRecord.create(bthr);
        }

        public CommonBTNodeDescriptor createCommonBTNodeDescriptor(byte[] currentNodeData, int i) {
            NodeDescriptor nd = new NodeDescriptor(currentNodeData, i);
            return CommonBTNodeDescriptor.create(nd);
        }
    }
}

