/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.original;

import org.catacombae.hfs.AllocationFile;
import org.catacombae.hfs.original.HFSOriginalVolume;
import org.catacombae.hfs.types.hfs.ExtDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.io.ReadableRandomAccessStream;

public class HFSOriginalAllocationFile
extends AllocationFile {
    private final HFSOriginalVolume hfsParentView;
    private final ReadableRandomAccessStream volumeBitmap;

    public HFSOriginalAllocationFile(HFSOriginalVolume parentView, ReadableRandomAccessStream volumeBitmap) {
        super(parentView, volumeBitmap);
        this.hfsParentView = parentView;
        this.volumeBitmap = volumeBitmap;
    }

    public boolean isAllocationBlockUsed(long blockNumber) throws IllegalArgumentException {
        if (blockNumber < 0L || blockNumber > 65534L) {
            throw new IllegalArgumentException("Block number (" + blockNumber + ") out of range for UInt16!");
        }
        return super.isAllocationBlockUsed(blockNumber);
    }

    public CommonHFSExtentDescriptor createExtentDescriptor(long startBlock, long blockCount) {
        if (startBlock < 0L || startBlock > 65534L) {
            throw new IllegalArgumentException("startBlock(" + startBlock + ") out of range for UInt16!");
        }
        if (blockCount < 0L || blockCount > 65534L) {
            throw new IllegalArgumentException("blockCount(" + blockCount + ") out of range for UInt16!");
        }
        ExtDescriptor ed = new ExtDescriptor((short)startBlock, (short)blockCount);
        return CommonHFSExtentDescriptor.create(ed);
    }
}

