/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.original;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.catacombae.hfs.original.StringCodec;

public class CharsetStringCodec
implements StringCodec {
    private final String charsetName;
    private final CharsetDecoder decoder;
    private final CharsetEncoder encoder;

    public CharsetStringCodec(String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        this.charsetName = charsetName;
        Charset cs = Charset.forName(charsetName);
        this.decoder = cs.newDecoder();
        this.encoder = cs.newEncoder();
    }

    public String decode(byte[] data) {
        return this.decode(data, 0, data.length);
    }

    public String decode(byte[] data, int off, int len) {
        try {
            return this.decoder.decode(ByteBuffer.wrap(data, off, len)).toString();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Could not decode data!", e);
        }
    }

    public byte[] encode(String str) {
        return this.encode(str, 0, str.length());
    }

    public byte[] encode(String str, int off, int len) {
        try {
            return this.encoder.encode(CharBuffer.wrap(str.toCharArray(), off, len)).array();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Could not encode data!", e);
        }
    }

    public String getCharsetName() {
        return this.charsetName;
    }
}

