/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.io;

import java.util.HashMap;
import org.catacombae.io.ReadableFilterStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class ReadableBlockCachingStream
extends ReadableFilterStream {
    private static final long TIME_TO_KEEP_IN_CACHE = 5000L;
    private final int blockSize;
    private long virtualFP;
    private final long virtualLength;
    private final HashMap<Long, BlockStore> blockMap = new HashMap();
    private final BlockStore[] cache;
    private boolean closed = false;

    public ReadableBlockCachingStream(ReadableRandomAccessStream backing, int blockSize, int maxItemCount) {
        super(backing);
        long length;
        if (backing == null) {
            throw new IllegalArgumentException("backing can not be null");
        }
        if (blockSize <= 0) {
            throw new IllegalArgumentException("blockSize must be positive and non-zero");
        }
        if (maxItemCount < 1) {
            throw new IllegalArgumentException("maxItemCount must be at least 1");
        }
        this.blockSize = blockSize;
        try {
            length = backing.length();
        }
        catch (Exception e) {
            length = -1L;
        }
        this.virtualLength = length > 0L ? length : -1L;
        int actualItemCount = maxItemCount;
        if (this.virtualLength > 0L && (long)(actualItemCount * blockSize) > this.virtualLength) {
            actualItemCount = (int)(this.virtualLength / (long)blockSize + (long)(this.virtualLength % (long)blockSize != 0L ? 1 : 0));
        }
        this.cache = new BlockStore[actualItemCount];
    }

    public void seek(long pos) {
        if (this.closed) {
            throw new RuntimeException("File is closed.");
        }
        if (this.virtualLength != -1L && pos > this.virtualLength || pos < 0L) {
            throw new IllegalArgumentException("pos out of range (pos=" + pos + ",virtualLength=" + this.virtualLength + ")");
        }
        this.virtualFP = pos;
    }

    public int read() {
        byte[] b = new byte[1];
        int res = this.read(b, 0, 1);
        if (res == 1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int pos, int len) {
        if (this.closed) {
            throw new RuntimeException("File is closed.");
        }
        int bytesProcessed = 0;
        while (bytesProcessed < len) {
            int bytesToCopy;
            int posInBlock;
            int bytesLeftInTransfer = len - bytesProcessed;
            byte[] blockData = this.getCachedBlock(this.virtualFP);
            int bytesLeftInBlock = blockData.length - (posInBlock = (int)(this.virtualFP - this.virtualFP / (long)this.blockSize * (long)this.blockSize));
            int n = bytesToCopy = bytesLeftInTransfer < bytesLeftInBlock ? bytesLeftInTransfer : bytesLeftInBlock;
            if (bytesLeftInBlock == 0) {
                throw new RuntimeIOException("Attempted to read after the end of the file.");
            }
            System.arraycopy(blockData, posInBlock, data, pos + bytesProcessed, bytesToCopy);
            bytesProcessed += bytesToCopy;
            this.virtualFP += (long)bytesToCopy;
        }
        return bytesProcessed;
    }

    public void readFully(byte[] data) {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int length) {
        int curBytesRead;
        for (int bytesRead = 0; bytesRead < length; bytesRead += curBytesRead) {
            curBytesRead = this.read(data, offset + bytesRead, length - bytesRead);
            if (curBytesRead > 0) {
                continue;
            }
            throw new RuntimeException("Couldn't read the entire length.");
        }
    }

    public long length() {
        if (this.closed) {
            throw new RuntimeException("File is closed.");
        }
        return this.virtualLength;
    }

    public long getFilePointer() {
        if (this.closed) {
            throw new RuntimeException("File is closed.");
        }
        return this.virtualFP;
    }

    public void close() {
        this.closed = true;
        this.backingStore.close();
    }

    private byte[] getCachedBlock(long filePointer) {
        byte[] data;
        long dataSize;
        long blockNumber = filePointer / (long)this.blockSize;
        BlockStore cur = this.blockMap.get(blockNumber);
        if (cur == null) {
            cur = new BlockStore(blockNumber);
            this.blockMap.put(blockNumber, cur);
        }
        ++cur.accessCount;
        cur.lastAccessTime = System.currentTimeMillis();
        if (cur.data != null) {
            return cur.data;
        }
        BlockStore lastCacheEntry = this.cache[this.cache.length - 1];
        this.cache[this.cache.length - 1] = null;
        byte[] recoveredData = null;
        if (lastCacheEntry != null) {
            recoveredData = lastCacheEntry.data;
            lastCacheEntry.data = null;
            if (recoveredData == null) {
                throw new RuntimeException("Entry in cache had a null array, which should never happen!");
            }
        }
        long blockPos = blockNumber * (long)this.blockSize;
        long remainingSize = this.length() - blockPos;
        long l = dataSize = remainingSize < (long)this.blockSize ? remainingSize : (long)this.blockSize;
        if (recoveredData != null && dataSize == (long)recoveredData.length) {
            data = recoveredData;
        } else {
            int size = (int)(dataSize <= 0L ? (long)this.blockSize : dataSize);
            data = new byte[size];
        }
        this.backingStore.seek(blockPos);
        this.backingStore.read(data, 0, data.length);
        cur.data = data;
        this.cache[this.cache.length - 1] = cur;
        ReadableBlockCachingStream.bubbleIntoPosition(this.cache, this.cache.length - 1);
        return cur.data;
    }

    private static void bubbleIntoPosition(BlockStore[] array, int startIndex) {
        long timestamp = System.currentTimeMillis();
        for (int i = startIndex; i >= 1; --i) {
            BlockStore low = array[i];
            BlockStore high = array[i - 1];
            if (high != null && low.accessCount <= high.accessCount && timestamp - high.lastAccessTime < 5000L) continue;
            array[i] = high;
            array[i - 1] = low;
        }
    }

    public void preloadBlocks() {
        this.preloadBlocks(0, this.cache.length);
    }

    private void preloadBlocks(int startBlock, int blockCount) {
        for (int i = 0; i < blockCount; ++i) {
            System.err.println("Preloading block " + (startBlock + i) + "...");
            this.getCachedBlock((startBlock + i) * this.blockSize);
        }
    }

    private static class BlockStore {
        public long accessCount = 0L;
        public long lastAccessTime = Long.MAX_VALUE;
        public final long blockNumber;
        public byte[] data = null;

        public BlockStore(long blockNumber) {
            this.blockNumber = blockNumber;
        }
    }
}

