/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.io;

import java.util.ArrayList;
import java.util.Arrays;
import org.catacombae.hfs.ExtentsOverflowFile;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkData;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class ForkFilter
implements ReadableRandomAccessStream {
    private final ForkType forkType;
    private final long cnid;
    private final long forkLength;
    private final ArrayList<CommonHFSExtentDescriptor> extentDescriptors;
    private final ExtentsOverflowFile extentsOverflowFile;
    private final ReadableRandomAccessStream sourceFile;
    private final long fsOffset;
    private final long allocationBlockSize;
    private final long firstBlockByteOffset;
    private long logicalPosition;
    private long lastLogicalPos;
    private long lastPhysicalPos;
    private boolean all_extents_mapped = false;

    public ForkFilter(ForkType forkType, long cnid, CommonHFSForkData forkData, ExtentsOverflowFile extentsOverflowFile, ReadableRandomAccessStream sourceFile, long fsOffset, long allocationBlockSize, long firstBlockByteOffset) {
        this(forkType, cnid, forkData.getLogicalSize(), forkData.getBasicExtents(), extentsOverflowFile, sourceFile, fsOffset, allocationBlockSize, firstBlockByteOffset);
    }

    public ForkFilter(ForkType forkType, long cnid, long forkLength, CommonHFSExtentDescriptor[] basicExtents, ExtentsOverflowFile extentsOverflowFile, ReadableRandomAccessStream sourceFile, long fsOffset, long allocationBlockSize, long firstBlockByteOffset) {
        if (forkType == null) {
            throw new IllegalArgumentException("A null value is not allowed in 'forkType'.");
        }
        if (cnid > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value of 'cnid' is too large: " + cnid);
        }
        this.forkType = forkType;
        this.cnid = cnid;
        this.forkLength = forkLength;
        this.extentDescriptors = new ArrayList<CommonHFSExtentDescriptor>(Arrays.asList(basicExtents));
        this.extentsOverflowFile = extentsOverflowFile;
        this.sourceFile = sourceFile;
        this.fsOffset = fsOffset;
        this.allocationBlockSize = allocationBlockSize;
        this.firstBlockByteOffset = firstBlockByteOffset;
        this.logicalPosition = 0L;
        this.lastLogicalPos = -1L;
        this.lastPhysicalPos = 0L;
    }

    public void seek(long pos) {
        this.logicalPosition = pos;
    }

    public int read() {
        byte[] oneByte = new byte[1];
        if (this.read(oneByte) == 1) {
            return oneByte[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    private CommonHFSExtentDescriptor getExtent(int extIndex, long startBlock) {
        long curStartBlock = startBlock;
        block0: while (extIndex >= this.extentDescriptors.size()) {
            if (this.extentsOverflowFile == null) {
                throw new RuntimeIOException("No extents overflow file to query for overflow extents.");
            }
            CommonHFSExtentLeafRecord extentRecord = this.all_extents_mapped ? null : this.extentsOverflowFile.getOverflowExtent(this.forkType == ForkType.RESOURCE, (int)this.cnid, curStartBlock);
            if (extentRecord == null) {
                throw new RuntimeIOException("Unable to find extent record for " + (this.forkType == ForkType.RESOURCE ? "resource" : "data") + " fork of CNID " + this.cnid + ", start " + "block " + startBlock + ".");
            }
            CommonHFSExtentDescriptor[] descriptors = extentRecord.getRecordData();
            for (int i = 0; i < descriptors.length; ++i) {
                CommonHFSExtentDescriptor curDescriptor = descriptors[i];
                long blockCount = curDescriptor.getBlockCount();
                if (blockCount == 0L) {
                    this.all_extents_mapped = true;
                    continue block0;
                }
                this.extentDescriptors.add(curDescriptor);
                curStartBlock += blockCount;
            }
        }
        return this.extentDescriptors.get(extIndex);
    }

    public int read(byte[] data, int pos, int len) {
        int totalBytesToRead;
        CommonHFSExtentDescriptor cur;
        long offset = Long.MAX_VALUE;
        long bytesToSkip = this.logicalPosition;
        long curLogicalBlock = 0L;
        if (this.extentDescriptors.size() < 1 || this.logicalPosition > this.forkLength) {
            return -1;
        }
        int extIndex = 0;
        while (true) {
            if ((cur = this.getExtent(extIndex, curLogicalBlock)) == null) {
                return -1;
            }
            long currentBlockCount = cur.getBlockCount();
            long currentExtentLength = currentBlockCount * this.allocationBlockSize;
            if (bytesToSkip < currentExtentLength) break;
            bytesToSkip -= currentExtentLength;
            curLogicalBlock += currentBlockCount;
            ++extIndex;
        }
        offset = this.fsOffset + this.firstBlockByteOffset + cur.getStartBlock() * this.allocationBlockSize + bytesToSkip;
        if (this.logicalPosition != this.lastLogicalPos) {
            this.sourceFile.seek(offset);
        } else if (this.sourceFile.getFilePointer() != this.lastPhysicalPos) {
            this.sourceFile.seek(this.lastPhysicalPos);
        }
        long bytesLeftInStream = this.forkLength - this.logicalPosition;
        int bytesLeftToRead = totalBytesToRead = bytesLeftInStream < (long)len ? (int)bytesLeftInStream : len;
        while (true) {
            int bytesReadFromExtent;
            int bytesRead;
            CommonHFSExtentDescriptor cur2;
            try {
                cur2 = this.getExtent(extIndex, curLogicalBlock);
            }
            catch (RuntimeException e) {
                if (bytesLeftToRead != totalBytesToRead) break;
                throw e;
            }
            long blockCount = cur2.getBlockCount();
            long bytesInExtent = blockCount * this.allocationBlockSize - bytesToSkip;
            int bytesToReadFromExtent = bytesInExtent < (long)bytesLeftToRead ? (int)bytesInExtent : bytesLeftToRead;
            for (bytesReadFromExtent = 0; bytesReadFromExtent < bytesToReadFromExtent; bytesReadFromExtent += bytesRead) {
                int positionInArray = pos + (totalBytesToRead - bytesLeftToRead) + bytesReadFromExtent;
                int bytesToRead = bytesToReadFromExtent - bytesReadFromExtent;
                bytesRead = this.sourceFile.read(data, positionInArray, bytesToRead);
                if (bytesRead > 0) {
                    continue;
                }
                this.lastPhysicalPos = this.sourceFile.getFilePointer();
                int totalBytesRead = positionInArray - pos;
                this.logicalPosition += (long)totalBytesRead;
                return totalBytesRead;
            }
            bytesToSkip = 0L;
            curLogicalBlock += blockCount;
            if ((bytesLeftToRead -= bytesReadFromExtent) == 0) break;
            ++extIndex;
        }
        this.lastPhysicalPos = this.sourceFile.getFilePointer();
        this.logicalPosition += (long)(totalBytesToRead - bytesLeftToRead);
        if (bytesLeftToRead < totalBytesToRead) {
            int bytesRead = totalBytesToRead - bytesLeftToRead;
            return bytesRead;
        }
        return -1;
    }

    public void readFully(byte[] data) {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int length) {
        int curBytesRead;
        for (int bytesRead = 0; bytesRead < length; bytesRead += curBytesRead) {
            curBytesRead = this.read(data, bytesRead, length - bytesRead);
            if (curBytesRead > 0) {
                continue;
            }
            throw new RuntimeException("Couldn't read the entire length.");
        }
    }

    public long length() {
        return this.forkLength;
    }

    public long getFilePointer() {
        return this.logicalPosition;
    }

    public ReadableRandomAccessStream getUnderlyingStream() {
        return this.sourceFile;
    }

    public void close() {
        this.sourceFile.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ForkType {
        DATA,
        RESOURCE;

    }
}

