/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeNormalizationToolkit {
    private static final UnicodeNormalizationToolkit defaultInstance = new UnicodeNormalizationToolkit();
    private Map<Character, char[]> decompositionTable;
    private TrieNode compositionTrie;
    private static long nextID = 0L;

    private UnicodeNormalizationToolkit() {
        this(new HashMap<Character, char[]>());
    }

    private UnicodeNormalizationToolkit(Map<Character, char[]> decompositionTable) {
        this.decompositionTable = decompositionTable;
        UnicodeNormalizationToolkit.buildDecompositionTable(decompositionTable);
        this.compositionTrie = UnicodeNormalizationToolkit.buildCompositionTrie(decompositionTable);
    }

    public static UnicodeNormalizationToolkit getDefaultInstance() {
        return defaultInstance;
    }

    public static UnicodeNormalizationToolkit getCustomInstance(Map<Character, char[]> decompositionTable) {
        return new UnicodeNormalizationToolkit(decompositionTable);
    }

    public char[] decompose(char c) {
        int codepoint = c & 0xFFFF;
        if (codepoint >= 44032 && codepoint <= 55203) {
            return HangulDecomposition.decomposeHangul(c).toCharArray();
        }
        char[] subst = this.decompositionTable.get(Character.valueOf(c));
        if (subst == null) {
            subst = new char[]{c};
        }
        char[] res = new char[subst.length];
        for (int i = 0; i < subst.length; ++i) {
            res[i] = subst[i];
        }
        return res;
    }

    public String compose(String decomposedString) {
        StringBuilder sb = new StringBuilder();
        LinkedList<TrieNode> matchSequence = new LinkedList<TrieNode>();
        for (int i = 0; i < decomposedString.length(); ++i) {
            char[] replacementSequence = null;
            matchSequence.clear();
            TrieNode tn = this.compositionTrie;
            int charsRead = 0;
            while (tn != null && i + charsRead < decomposedString.length()) {
                char current = decomposedString.charAt(i + charsRead);
                if ((tn = tn.getChild(current)) == null) continue;
                matchSequence.addFirst(tn);
                ++charsRead;
            }
            for (TrieNode cur : matchSequence) {
                if (cur.getReplacementSequence() != null) {
                    replacementSequence = cur.getReplacementSequence();
                    break;
                }
                --charsRead;
            }
            if (replacementSequence != null) {
                sb.append(replacementSequence);
                i += charsRead - 1;
                continue;
            }
            sb.append(decomposedString.charAt(i));
        }
        return HangulDecomposition.composeHangul(sb.toString());
    }

    public Map<Character, char[]> getDecompositionTable() {
        return this.decompositionTable;
    }

    private void checkTrie(TrieNode root) {
        this.checkTrie(root, "  ");
    }

    private void checkTrie(TrieNode root, String prefix) {
        Collection<TrieNode> children = root.getChildren();
        if (root.getReplacementSequence() != null) {
            System.err.print(prefix + root.toString());
            if (children.size() > 0) {
                System.err.println(" <INCONSISTENCY!>");
            } else {
                System.err.println();
            }
        } else {
            System.err.println(prefix + root.toString());
        }
        for (TrieNode tn : children) {
            this.checkTrie(tn, prefix + "  ");
        }
    }

    private static TrieNode buildCompositionTrie(Map<Character, char[]> decompositionTable) {
        TrieNode rootNode = new TrieNode('\u0000');
        for (Map.Entry<Character, char[]> entry : decompositionTable.entrySet()) {
            char key = entry.getKey().charValue();
            char[] value = entry.getValue();
            TrieNode currentNode = rootNode;
            for (char c : value) {
                TrieNode nextNode = currentNode.getChild(c);
                if (nextNode == null) {
                    nextNode = new TrieNode(c);
                    currentNode.addChild(c, nextNode);
                }
                currentNode = nextNode;
            }
            currentNode.setReplacementSequence(new char[]{key});
        }
        return rootNode;
    }

    /*
     * Opcode count of 18980 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void buildDecompositionTable(Map<Character, char[]> decompositionTable) {
        char key = '\u00c0';
        char[] subst = new char[]{'A', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00c1';
        subst = new char[]{'A', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00c2';
        subst = new char[]{'A', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00c3';
        subst = new char[]{'A', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00c4';
        subst = new char[]{'A', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00c5';
        subst = new char[]{'A', '\u030a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00c7';
        subst = new char[]{'C', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00c8';
        subst = new char[]{'E', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00c9';
        subst = new char[]{'E', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00ca';
        subst = new char[]{'E', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00cb';
        subst = new char[]{'E', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00cc';
        subst = new char[]{'I', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00cd';
        subst = new char[]{'I', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00ce';
        subst = new char[]{'I', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00cf';
        subst = new char[]{'I', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00d1';
        subst = new char[]{'N', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00d2';
        subst = new char[]{'O', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00d3';
        subst = new char[]{'O', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00d4';
        subst = new char[]{'O', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00d5';
        subst = new char[]{'O', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00d6';
        subst = new char[]{'O', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00d9';
        subst = new char[]{'U', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00da';
        subst = new char[]{'U', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00db';
        subst = new char[]{'U', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00dc';
        subst = new char[]{'U', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00dd';
        subst = new char[]{'Y', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e0';
        subst = new char[]{'a', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e1';
        subst = new char[]{'a', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e2';
        subst = new char[]{'a', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e3';
        subst = new char[]{'a', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e4';
        subst = new char[]{'a', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e5';
        subst = new char[]{'a', '\u030a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e7';
        subst = new char[]{'c', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e8';
        subst = new char[]{'e', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00e9';
        subst = new char[]{'e', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00ea';
        subst = new char[]{'e', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00eb';
        subst = new char[]{'e', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00ec';
        subst = new char[]{'i', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00ed';
        subst = new char[]{'i', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00ee';
        subst = new char[]{'i', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00ef';
        subst = new char[]{'i', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00f1';
        subst = new char[]{'n', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00f2';
        subst = new char[]{'o', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00f3';
        subst = new char[]{'o', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00f4';
        subst = new char[]{'o', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00f5';
        subst = new char[]{'o', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00f6';
        subst = new char[]{'o', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00f9';
        subst = new char[]{'u', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00fa';
        subst = new char[]{'u', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00fb';
        subst = new char[]{'u', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00fc';
        subst = new char[]{'u', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00fd';
        subst = new char[]{'y', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u00ff';
        subst = new char[]{'y', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0100';
        subst = new char[]{'A', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0101';
        subst = new char[]{'a', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0102';
        subst = new char[]{'A', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0103';
        subst = new char[]{'a', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0104';
        subst = new char[]{'A', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0105';
        subst = new char[]{'a', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0106';
        subst = new char[]{'C', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0107';
        subst = new char[]{'c', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0108';
        subst = new char[]{'C', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0109';
        subst = new char[]{'c', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u010a';
        subst = new char[]{'C', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u010b';
        subst = new char[]{'c', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u010c';
        subst = new char[]{'C', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u010d';
        subst = new char[]{'c', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u010e';
        subst = new char[]{'D', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u010f';
        subst = new char[]{'d', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0112';
        subst = new char[]{'E', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0113';
        subst = new char[]{'e', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0114';
        subst = new char[]{'E', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0115';
        subst = new char[]{'e', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0116';
        subst = new char[]{'E', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0117';
        subst = new char[]{'e', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0118';
        subst = new char[]{'E', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0119';
        subst = new char[]{'e', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u011a';
        subst = new char[]{'E', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u011b';
        subst = new char[]{'e', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u011c';
        subst = new char[]{'G', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u011d';
        subst = new char[]{'g', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u011e';
        subst = new char[]{'G', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u011f';
        subst = new char[]{'g', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0120';
        subst = new char[]{'G', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0121';
        subst = new char[]{'g', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0122';
        subst = new char[]{'G', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0123';
        subst = new char[]{'g', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0124';
        subst = new char[]{'H', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0125';
        subst = new char[]{'h', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0128';
        subst = new char[]{'I', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0129';
        subst = new char[]{'i', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u012a';
        subst = new char[]{'I', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u012b';
        subst = new char[]{'i', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u012c';
        subst = new char[]{'I', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u012d';
        subst = new char[]{'i', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u012e';
        subst = new char[]{'I', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u012f';
        subst = new char[]{'i', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0130';
        subst = new char[]{'I', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0134';
        subst = new char[]{'J', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0135';
        subst = new char[]{'j', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0136';
        subst = new char[]{'K', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0137';
        subst = new char[]{'k', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0139';
        subst = new char[]{'L', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u013a';
        subst = new char[]{'l', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u013b';
        subst = new char[]{'L', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u013c';
        subst = new char[]{'l', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u013d';
        subst = new char[]{'L', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u013e';
        subst = new char[]{'l', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0143';
        subst = new char[]{'N', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0144';
        subst = new char[]{'n', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0145';
        subst = new char[]{'N', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0146';
        subst = new char[]{'n', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0147';
        subst = new char[]{'N', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0148';
        subst = new char[]{'n', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u014c';
        subst = new char[]{'O', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u014d';
        subst = new char[]{'o', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u014e';
        subst = new char[]{'O', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u014f';
        subst = new char[]{'o', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0150';
        subst = new char[]{'O', '\u030b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0151';
        subst = new char[]{'o', '\u030b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0154';
        subst = new char[]{'R', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0155';
        subst = new char[]{'r', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0156';
        subst = new char[]{'R', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0157';
        subst = new char[]{'r', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0158';
        subst = new char[]{'R', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0159';
        subst = new char[]{'r', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u015a';
        subst = new char[]{'S', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u015b';
        subst = new char[]{'s', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u015c';
        subst = new char[]{'S', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u015d';
        subst = new char[]{'s', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u015e';
        subst = new char[]{'S', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u015f';
        subst = new char[]{'s', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0160';
        subst = new char[]{'S', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0161';
        subst = new char[]{'s', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0162';
        subst = new char[]{'T', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0163';
        subst = new char[]{'t', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0164';
        subst = new char[]{'T', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0165';
        subst = new char[]{'t', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0168';
        subst = new char[]{'U', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0169';
        subst = new char[]{'u', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u016a';
        subst = new char[]{'U', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u016b';
        subst = new char[]{'u', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u016c';
        subst = new char[]{'U', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u016d';
        subst = new char[]{'u', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u016e';
        subst = new char[]{'U', '\u030a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u016f';
        subst = new char[]{'u', '\u030a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0170';
        subst = new char[]{'U', '\u030b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0171';
        subst = new char[]{'u', '\u030b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0172';
        subst = new char[]{'U', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0173';
        subst = new char[]{'u', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0174';
        subst = new char[]{'W', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0175';
        subst = new char[]{'w', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0176';
        subst = new char[]{'Y', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0177';
        subst = new char[]{'y', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0178';
        subst = new char[]{'Y', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0179';
        subst = new char[]{'Z', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u017a';
        subst = new char[]{'z', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u017b';
        subst = new char[]{'Z', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u017c';
        subst = new char[]{'z', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u017d';
        subst = new char[]{'Z', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u017e';
        subst = new char[]{'z', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01a0';
        subst = new char[]{'O', '\u031b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01a1';
        subst = new char[]{'o', '\u031b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01af';
        subst = new char[]{'U', '\u031b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01b0';
        subst = new char[]{'u', '\u031b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01cd';
        subst = new char[]{'A', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01ce';
        subst = new char[]{'a', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01cf';
        subst = new char[]{'I', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d0';
        subst = new char[]{'i', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d1';
        subst = new char[]{'O', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d2';
        subst = new char[]{'o', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d3';
        subst = new char[]{'U', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d4';
        subst = new char[]{'u', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d5';
        subst = new char[]{'U', '\u0308', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d6';
        subst = new char[]{'u', '\u0308', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d7';
        subst = new char[]{'U', '\u0308', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d8';
        subst = new char[]{'u', '\u0308', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01d9';
        subst = new char[]{'U', '\u0308', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01da';
        subst = new char[]{'u', '\u0308', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01db';
        subst = new char[]{'U', '\u0308', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01dc';
        subst = new char[]{'u', '\u0308', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01de';
        subst = new char[]{'A', '\u0308', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01df';
        subst = new char[]{'a', '\u0308', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01e0';
        subst = new char[]{'A', '\u0307', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01e1';
        subst = new char[]{'a', '\u0307', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01e2';
        subst = new char[]{'\u00c6', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01e3';
        subst = new char[]{'\u00e6', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01e6';
        subst = new char[]{'G', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01e7';
        subst = new char[]{'g', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01e8';
        subst = new char[]{'K', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01e9';
        subst = new char[]{'k', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01ea';
        subst = new char[]{'O', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01eb';
        subst = new char[]{'o', '\u0328'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01ec';
        subst = new char[]{'O', '\u0328', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01ed';
        subst = new char[]{'o', '\u0328', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01ee';
        subst = new char[]{'\u01b7', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01ef';
        subst = new char[]{'\u0292', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01f0';
        subst = new char[]{'j', '\u030c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01f4';
        subst = new char[]{'G', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01f5';
        subst = new char[]{'g', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01fa';
        subst = new char[]{'A', '\u030a', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01fb';
        subst = new char[]{'a', '\u030a', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01fc';
        subst = new char[]{'\u00c6', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01fd';
        subst = new char[]{'\u00e6', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01fe';
        subst = new char[]{'\u00d8', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u01ff';
        subst = new char[]{'\u00f8', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0200';
        subst = new char[]{'A', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0201';
        subst = new char[]{'a', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0202';
        subst = new char[]{'A', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0203';
        subst = new char[]{'a', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0204';
        subst = new char[]{'E', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0205';
        subst = new char[]{'e', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0206';
        subst = new char[]{'E', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0207';
        subst = new char[]{'e', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0208';
        subst = new char[]{'I', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0209';
        subst = new char[]{'i', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u020a';
        subst = new char[]{'I', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u020b';
        subst = new char[]{'i', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u020c';
        subst = new char[]{'O', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u020d';
        subst = new char[]{'o', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u020e';
        subst = new char[]{'O', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u020f';
        subst = new char[]{'o', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0210';
        subst = new char[]{'R', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0211';
        subst = new char[]{'r', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0212';
        subst = new char[]{'R', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0213';
        subst = new char[]{'r', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0214';
        subst = new char[]{'U', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0215';
        subst = new char[]{'u', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0216';
        subst = new char[]{'U', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0217';
        subst = new char[]{'u', '\u0311'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0310';
        subst = new char[]{'\u0306', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0340';
        subst = new char[]{'\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0341';
        subst = new char[]{'\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0343';
        subst = new char[]{'\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0344';
        subst = new char[]{'\u0308', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0374';
        subst = new char[]{'\u02b9'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u037e';
        subst = new char[]{';'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0385';
        subst = new char[]{'\u00a8', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0386';
        subst = new char[]{'\u0391', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0387';
        subst = new char[]{'\u00b7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0388';
        subst = new char[]{'\u0395', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0389';
        subst = new char[]{'\u0397', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u038a';
        subst = new char[]{'\u0399', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u038c';
        subst = new char[]{'\u039f', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u038e';
        subst = new char[]{'\u03a5', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u038f';
        subst = new char[]{'\u03a9', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0390';
        subst = new char[]{'\u03b9', '\u0308', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03aa';
        subst = new char[]{'\u0399', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03ab';
        subst = new char[]{'\u03a5', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03ac';
        subst = new char[]{'\u03b1', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03ad';
        subst = new char[]{'\u03b5', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03ae';
        subst = new char[]{'\u03b7', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03af';
        subst = new char[]{'\u03b9', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03b0';
        subst = new char[]{'\u03c5', '\u0308', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03ca';
        subst = new char[]{'\u03b9', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03cb';
        subst = new char[]{'\u03c5', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03cc';
        subst = new char[]{'\u03bf', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03cd';
        subst = new char[]{'\u03c5', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03ce';
        subst = new char[]{'\u03c9', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03d3';
        subst = new char[]{'\u03d2', '\u030d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u03d4';
        subst = new char[]{'\u03d2', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0401';
        subst = new char[]{'\u0415', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0403';
        subst = new char[]{'\u0413', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0407';
        subst = new char[]{'\u0406', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u040c';
        subst = new char[]{'\u041a', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u040e';
        subst = new char[]{'\u0423', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0419';
        subst = new char[]{'\u0418', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0439';
        subst = new char[]{'\u0438', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0451';
        subst = new char[]{'\u0435', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0453';
        subst = new char[]{'\u0433', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0457';
        subst = new char[]{'\u0456', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u045c';
        subst = new char[]{'\u043a', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u045e';
        subst = new char[]{'\u0443', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0476';
        subst = new char[]{'\u0474', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0477';
        subst = new char[]{'\u0475', '\u030f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04c1';
        subst = new char[]{'\u0416', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04c2';
        subst = new char[]{'\u0436', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d0';
        subst = new char[]{'\u0410', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d1';
        subst = new char[]{'\u0430', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d2';
        subst = new char[]{'\u0410', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d3';
        subst = new char[]{'\u0430', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d4';
        subst = new char[]{'\u00c6'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d5';
        subst = new char[]{'\u00e6'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d6';
        subst = new char[]{'\u0415', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d7';
        subst = new char[]{'\u0435', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d8';
        subst = new char[]{'\u018f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04d9';
        subst = new char[]{'\u0259'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04da';
        subst = new char[]{'\u018f', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04db';
        subst = new char[]{'\u0259', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04dc';
        subst = new char[]{'\u0416', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04dd';
        subst = new char[]{'\u0436', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04de';
        subst = new char[]{'\u0417', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04df';
        subst = new char[]{'\u0437', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e0';
        subst = new char[]{'\u01b7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e1';
        subst = new char[]{'\u0292'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e2';
        subst = new char[]{'\u0418', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e3';
        subst = new char[]{'\u0438', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e4';
        subst = new char[]{'\u0418', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e5';
        subst = new char[]{'\u0438', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e6';
        subst = new char[]{'\u041e', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e7';
        subst = new char[]{'\u043e', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e8';
        subst = new char[]{'\u019f'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04e9';
        subst = new char[]{'\u0275'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04ea';
        subst = new char[]{'\u019f', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04eb';
        subst = new char[]{'\u0275', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04ee';
        subst = new char[]{'\u0423', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04ef';
        subst = new char[]{'\u0443', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04f0';
        subst = new char[]{'\u0423', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04f1';
        subst = new char[]{'\u0443', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04f2';
        subst = new char[]{'\u0423', '\u030b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04f3';
        subst = new char[]{'\u0443', '\u030b'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04f4';
        subst = new char[]{'\u0427', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04f5';
        subst = new char[]{'\u0447', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04f8';
        subst = new char[]{'\u042b', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u04f9';
        subst = new char[]{'\u044b', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0929';
        subst = new char[]{'\u0928', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0931';
        subst = new char[]{'\u0930', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0934';
        subst = new char[]{'\u0933', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0958';
        subst = new char[]{'\u0915', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0959';
        subst = new char[]{'\u0916', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u095a';
        subst = new char[]{'\u0917', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u095b';
        subst = new char[]{'\u091c', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u095c';
        subst = new char[]{'\u0921', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u095d';
        subst = new char[]{'\u0922', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u095e';
        subst = new char[]{'\u092b', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u095f';
        subst = new char[]{'\u092f', '\u093c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u09b0';
        subst = new char[]{'\u09ac', '\u09bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u09cb';
        subst = new char[]{'\u09c7', '\u09be'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u09cc';
        subst = new char[]{'\u09c7', '\u09d7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u09dc';
        subst = new char[]{'\u09a1', '\u09bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u09dd';
        subst = new char[]{'\u09a2', '\u09bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u09df';
        subst = new char[]{'\u09af', '\u09bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0a59';
        subst = new char[]{'\u0a16', '\u0a3c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0a5a';
        subst = new char[]{'\u0a17', '\u0a3c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0a5b';
        subst = new char[]{'\u0a1c', '\u0a3c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0a5c';
        subst = new char[]{'\u0a21', '\u0a3c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0a5e';
        subst = new char[]{'\u0a2b', '\u0a3c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0b48';
        subst = new char[]{'\u0b47', '\u0b56'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0b4b';
        subst = new char[]{'\u0b47', '\u0b3e'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0b4c';
        subst = new char[]{'\u0b47', '\u0b57'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0b5c';
        subst = new char[]{'\u0b21', '\u0b3c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0b5d';
        subst = new char[]{'\u0b22', '\u0b3c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0b5f';
        subst = new char[]{'\u0b2f', '\u0b3c'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0b94';
        subst = new char[]{'\u0b92', '\u0bd7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0bca';
        subst = new char[]{'\u0bc6', '\u0bbe'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0bcb';
        subst = new char[]{'\u0bc7', '\u0bbe'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0bcc';
        subst = new char[]{'\u0bc6', '\u0bd7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0c48';
        subst = new char[]{'\u0c46', '\u0c56'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0cc0';
        subst = new char[]{'\u0cbf', '\u0cd5'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0cc7';
        subst = new char[]{'\u0cc6', '\u0cd5'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0cc8';
        subst = new char[]{'\u0cc6', '\u0cd6'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0cca';
        subst = new char[]{'\u0cc6', '\u0cc2'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0ccb';
        subst = new char[]{'\u0cc6', '\u0cc2', '\u0cd5'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0d4a';
        subst = new char[]{'\u0d46', '\u0d3e'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0d4b';
        subst = new char[]{'\u0d47', '\u0d3e'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0d4c';
        subst = new char[]{'\u0d46', '\u0d57'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0e33';
        subst = new char[]{'\u0e4d', '\u0e32'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0eb3';
        subst = new char[]{'\u0ecd', '\u0eb2'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f43';
        subst = new char[]{'\u0f42', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f4d';
        subst = new char[]{'\u0f4c', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f52';
        subst = new char[]{'\u0f51', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f57';
        subst = new char[]{'\u0f56', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f5c';
        subst = new char[]{'\u0f5b', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f69';
        subst = new char[]{'\u0f40', '\u0fb5'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f73';
        subst = new char[]{'\u0f72', '\u0f71'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f75';
        subst = new char[]{'\u0f74', '\u0f71'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f76';
        subst = new char[]{'\u0fb2', '\u0f80'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f77';
        subst = new char[]{'\u0fb2', '\u0f80', '\u0f71'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f78';
        subst = new char[]{'\u0fb3', '\u0f80'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f79';
        subst = new char[]{'\u0fb3', '\u0f80', '\u0f71'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f81';
        subst = new char[]{'\u0f80', '\u0f71'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f93';
        subst = new char[]{'\u0f92', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0f9d';
        subst = new char[]{'\u0f9c', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0fa2';
        subst = new char[]{'\u0fa1', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0fa7';
        subst = new char[]{'\u0fa6', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0fac';
        subst = new char[]{'\u0fab', '\u0fb7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u0fb9';
        subst = new char[]{'\u0f90', '\u0fb5'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e00';
        subst = new char[]{'A', '\u0325'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e01';
        subst = new char[]{'a', '\u0325'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e02';
        subst = new char[]{'B', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e03';
        subst = new char[]{'b', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e04';
        subst = new char[]{'B', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e05';
        subst = new char[]{'b', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e06';
        subst = new char[]{'B', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e07';
        subst = new char[]{'b', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e08';
        subst = new char[]{'C', '\u0327', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e09';
        subst = new char[]{'c', '\u0327', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e0a';
        subst = new char[]{'D', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e0b';
        subst = new char[]{'d', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e0c';
        subst = new char[]{'D', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e0d';
        subst = new char[]{'d', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e0e';
        subst = new char[]{'D', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e0f';
        subst = new char[]{'d', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e10';
        subst = new char[]{'D', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e11';
        subst = new char[]{'d', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e12';
        subst = new char[]{'D', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e13';
        subst = new char[]{'d', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e14';
        subst = new char[]{'E', '\u0304', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e15';
        subst = new char[]{'e', '\u0304', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e16';
        subst = new char[]{'E', '\u0304', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e17';
        subst = new char[]{'e', '\u0304', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e18';
        subst = new char[]{'E', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e19';
        subst = new char[]{'e', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e1a';
        subst = new char[]{'E', '\u0330'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e1b';
        subst = new char[]{'e', '\u0330'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e1c';
        subst = new char[]{'E', '\u0327', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e1d';
        subst = new char[]{'e', '\u0327', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e1e';
        subst = new char[]{'F', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e1f';
        subst = new char[]{'f', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e20';
        subst = new char[]{'G', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e21';
        subst = new char[]{'g', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e22';
        subst = new char[]{'H', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e23';
        subst = new char[]{'h', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e24';
        subst = new char[]{'H', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e25';
        subst = new char[]{'h', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e26';
        subst = new char[]{'H', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e27';
        subst = new char[]{'h', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e28';
        subst = new char[]{'H', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e29';
        subst = new char[]{'h', '\u0327'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e2a';
        subst = new char[]{'H', '\u032e'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e2b';
        subst = new char[]{'h', '\u032e'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e2c';
        subst = new char[]{'I', '\u0330'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e2d';
        subst = new char[]{'i', '\u0330'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e2e';
        subst = new char[]{'I', '\u0308', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e2f';
        subst = new char[]{'i', '\u0308', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e30';
        subst = new char[]{'K', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e31';
        subst = new char[]{'k', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e32';
        subst = new char[]{'K', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e33';
        subst = new char[]{'k', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e34';
        subst = new char[]{'K', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e35';
        subst = new char[]{'k', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e36';
        subst = new char[]{'L', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e37';
        subst = new char[]{'l', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e38';
        subst = new char[]{'L', '\u0323', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e39';
        subst = new char[]{'l', '\u0323', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e3a';
        subst = new char[]{'L', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e3b';
        subst = new char[]{'l', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e3c';
        subst = new char[]{'L', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e3d';
        subst = new char[]{'l', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e3e';
        subst = new char[]{'M', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e3f';
        subst = new char[]{'m', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e40';
        subst = new char[]{'M', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e41';
        subst = new char[]{'m', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e42';
        subst = new char[]{'M', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e43';
        subst = new char[]{'m', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e44';
        subst = new char[]{'N', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e45';
        subst = new char[]{'n', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e46';
        subst = new char[]{'N', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e47';
        subst = new char[]{'n', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e48';
        subst = new char[]{'N', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e49';
        subst = new char[]{'n', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e4a';
        subst = new char[]{'N', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e4b';
        subst = new char[]{'n', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e4c';
        subst = new char[]{'O', '\u0303', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e4d';
        subst = new char[]{'o', '\u0303', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e4e';
        subst = new char[]{'O', '\u0303', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e4f';
        subst = new char[]{'o', '\u0303', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e50';
        subst = new char[]{'O', '\u0304', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e51';
        subst = new char[]{'o', '\u0304', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e52';
        subst = new char[]{'O', '\u0304', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e53';
        subst = new char[]{'o', '\u0304', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e54';
        subst = new char[]{'P', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e55';
        subst = new char[]{'p', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e56';
        subst = new char[]{'P', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e57';
        subst = new char[]{'p', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e58';
        subst = new char[]{'R', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e59';
        subst = new char[]{'r', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e5a';
        subst = new char[]{'R', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e5b';
        subst = new char[]{'r', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e5c';
        subst = new char[]{'R', '\u0323', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e5d';
        subst = new char[]{'r', '\u0323', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e5e';
        subst = new char[]{'R', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e5f';
        subst = new char[]{'r', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e60';
        subst = new char[]{'S', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e61';
        subst = new char[]{'s', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e62';
        subst = new char[]{'S', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e63';
        subst = new char[]{'s', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e64';
        subst = new char[]{'S', '\u0301', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e65';
        subst = new char[]{'s', '\u0301', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e66';
        subst = new char[]{'S', '\u030c', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e67';
        subst = new char[]{'s', '\u030c', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e68';
        subst = new char[]{'S', '\u0323', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e69';
        subst = new char[]{'s', '\u0323', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e6a';
        subst = new char[]{'T', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e6b';
        subst = new char[]{'t', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e6c';
        subst = new char[]{'T', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e6d';
        subst = new char[]{'t', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e6e';
        subst = new char[]{'T', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e6f';
        subst = new char[]{'t', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e70';
        subst = new char[]{'T', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e71';
        subst = new char[]{'t', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e72';
        subst = new char[]{'U', '\u0324'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e73';
        subst = new char[]{'u', '\u0324'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e74';
        subst = new char[]{'U', '\u0330'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e75';
        subst = new char[]{'u', '\u0330'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e76';
        subst = new char[]{'U', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e77';
        subst = new char[]{'u', '\u032d'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e78';
        subst = new char[]{'U', '\u0303', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e79';
        subst = new char[]{'u', '\u0303', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e7a';
        subst = new char[]{'U', '\u0304', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e7b';
        subst = new char[]{'u', '\u0304', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e7c';
        subst = new char[]{'V', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e7d';
        subst = new char[]{'v', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e7e';
        subst = new char[]{'V', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e7f';
        subst = new char[]{'v', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e80';
        subst = new char[]{'W', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e81';
        subst = new char[]{'w', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e82';
        subst = new char[]{'W', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e83';
        subst = new char[]{'w', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e84';
        subst = new char[]{'W', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e85';
        subst = new char[]{'w', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e86';
        subst = new char[]{'W', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e87';
        subst = new char[]{'w', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e88';
        subst = new char[]{'W', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e89';
        subst = new char[]{'w', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e8a';
        subst = new char[]{'X', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e8b';
        subst = new char[]{'x', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e8c';
        subst = new char[]{'X', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e8d';
        subst = new char[]{'x', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e8e';
        subst = new char[]{'Y', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e8f';
        subst = new char[]{'y', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e90';
        subst = new char[]{'Z', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e91';
        subst = new char[]{'z', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e92';
        subst = new char[]{'Z', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e93';
        subst = new char[]{'z', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e94';
        subst = new char[]{'Z', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e95';
        subst = new char[]{'z', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e96';
        subst = new char[]{'h', '\u0331'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e97';
        subst = new char[]{'t', '\u0308'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e98';
        subst = new char[]{'w', '\u030a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e99';
        subst = new char[]{'y', '\u030a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1e9b';
        subst = new char[]{'\u017f', '\u0307'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea0';
        subst = new char[]{'A', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea1';
        subst = new char[]{'a', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea2';
        subst = new char[]{'A', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea3';
        subst = new char[]{'a', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea4';
        subst = new char[]{'A', '\u0302', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea5';
        subst = new char[]{'a', '\u0302', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea6';
        subst = new char[]{'A', '\u0302', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea7';
        subst = new char[]{'a', '\u0302', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea8';
        subst = new char[]{'A', '\u0302', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ea9';
        subst = new char[]{'a', '\u0302', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eaa';
        subst = new char[]{'A', '\u0302', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eab';
        subst = new char[]{'a', '\u0302', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eac';
        subst = new char[]{'A', '\u0323', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ead';
        subst = new char[]{'a', '\u0323', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eae';
        subst = new char[]{'A', '\u0306', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eaf';
        subst = new char[]{'a', '\u0306', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb0';
        subst = new char[]{'A', '\u0306', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb1';
        subst = new char[]{'a', '\u0306', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb2';
        subst = new char[]{'A', '\u0306', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb3';
        subst = new char[]{'a', '\u0306', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb4';
        subst = new char[]{'A', '\u0306', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb5';
        subst = new char[]{'a', '\u0306', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb6';
        subst = new char[]{'A', '\u0323', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb7';
        subst = new char[]{'a', '\u0323', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb8';
        subst = new char[]{'E', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eb9';
        subst = new char[]{'e', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eba';
        subst = new char[]{'E', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ebb';
        subst = new char[]{'e', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ebc';
        subst = new char[]{'E', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ebd';
        subst = new char[]{'e', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ebe';
        subst = new char[]{'E', '\u0302', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ebf';
        subst = new char[]{'e', '\u0302', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec0';
        subst = new char[]{'E', '\u0302', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec1';
        subst = new char[]{'e', '\u0302', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec2';
        subst = new char[]{'E', '\u0302', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec3';
        subst = new char[]{'e', '\u0302', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec4';
        subst = new char[]{'E', '\u0302', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec5';
        subst = new char[]{'e', '\u0302', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec6';
        subst = new char[]{'E', '\u0323', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec7';
        subst = new char[]{'e', '\u0323', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec8';
        subst = new char[]{'I', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ec9';
        subst = new char[]{'i', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eca';
        subst = new char[]{'I', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ecb';
        subst = new char[]{'i', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ecc';
        subst = new char[]{'O', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ecd';
        subst = new char[]{'o', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ece';
        subst = new char[]{'O', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ecf';
        subst = new char[]{'o', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed0';
        subst = new char[]{'O', '\u0302', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed1';
        subst = new char[]{'o', '\u0302', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed2';
        subst = new char[]{'O', '\u0302', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed3';
        subst = new char[]{'o', '\u0302', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed4';
        subst = new char[]{'O', '\u0302', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed5';
        subst = new char[]{'o', '\u0302', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed6';
        subst = new char[]{'O', '\u0302', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed7';
        subst = new char[]{'o', '\u0302', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed8';
        subst = new char[]{'O', '\u0323', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ed9';
        subst = new char[]{'o', '\u0323', '\u0302'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eda';
        subst = new char[]{'O', '\u031b', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1edb';
        subst = new char[]{'o', '\u031b', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1edc';
        subst = new char[]{'O', '\u031b', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1edd';
        subst = new char[]{'o', '\u031b', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ede';
        subst = new char[]{'O', '\u031b', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1edf';
        subst = new char[]{'o', '\u031b', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee0';
        subst = new char[]{'O', '\u031b', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee1';
        subst = new char[]{'o', '\u031b', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee2';
        subst = new char[]{'O', '\u031b', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee3';
        subst = new char[]{'o', '\u031b', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee4';
        subst = new char[]{'U', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee5';
        subst = new char[]{'u', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee6';
        subst = new char[]{'U', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee7';
        subst = new char[]{'u', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee8';
        subst = new char[]{'U', '\u031b', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ee9';
        subst = new char[]{'u', '\u031b', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eea';
        subst = new char[]{'U', '\u031b', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eeb';
        subst = new char[]{'u', '\u031b', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eec';
        subst = new char[]{'U', '\u031b', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eed';
        subst = new char[]{'u', '\u031b', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eee';
        subst = new char[]{'U', '\u031b', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1eef';
        subst = new char[]{'u', '\u031b', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef0';
        subst = new char[]{'U', '\u031b', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef1';
        subst = new char[]{'u', '\u031b', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef2';
        subst = new char[]{'Y', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef3';
        subst = new char[]{'y', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef4';
        subst = new char[]{'Y', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef5';
        subst = new char[]{'y', '\u0323'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef6';
        subst = new char[]{'Y', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef7';
        subst = new char[]{'y', '\u0309'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef8';
        subst = new char[]{'Y', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ef9';
        subst = new char[]{'y', '\u0303'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f00';
        subst = new char[]{'\u03b1', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f01';
        subst = new char[]{'\u03b1', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f02';
        subst = new char[]{'\u03b1', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f03';
        subst = new char[]{'\u03b1', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f04';
        subst = new char[]{'\u03b1', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f05';
        subst = new char[]{'\u03b1', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f06';
        subst = new char[]{'\u03b1', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f07';
        subst = new char[]{'\u03b1', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f08';
        subst = new char[]{'\u0391', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f09';
        subst = new char[]{'\u0391', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f0a';
        subst = new char[]{'\u0391', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f0b';
        subst = new char[]{'\u0391', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f0c';
        subst = new char[]{'\u0391', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f0d';
        subst = new char[]{'\u0391', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f0e';
        subst = new char[]{'\u0391', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f0f';
        subst = new char[]{'\u0391', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f10';
        subst = new char[]{'\u03b5', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f11';
        subst = new char[]{'\u03b5', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f12';
        subst = new char[]{'\u03b5', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f13';
        subst = new char[]{'\u03b5', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f14';
        subst = new char[]{'\u03b5', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f15';
        subst = new char[]{'\u03b5', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f18';
        subst = new char[]{'\u0395', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f19';
        subst = new char[]{'\u0395', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f1a';
        subst = new char[]{'\u0395', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f1b';
        subst = new char[]{'\u0395', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f1c';
        subst = new char[]{'\u0395', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f1d';
        subst = new char[]{'\u0395', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f20';
        subst = new char[]{'\u03b7', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f21';
        subst = new char[]{'\u03b7', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f22';
        subst = new char[]{'\u03b7', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f23';
        subst = new char[]{'\u03b7', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f24';
        subst = new char[]{'\u03b7', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f25';
        subst = new char[]{'\u03b7', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f26';
        subst = new char[]{'\u03b7', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f27';
        subst = new char[]{'\u03b7', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f28';
        subst = new char[]{'\u0397', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f29';
        subst = new char[]{'\u0397', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f2a';
        subst = new char[]{'\u0397', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f2b';
        subst = new char[]{'\u0397', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f2c';
        subst = new char[]{'\u0397', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f2d';
        subst = new char[]{'\u0397', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f2e';
        subst = new char[]{'\u0397', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f2f';
        subst = new char[]{'\u0397', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f30';
        subst = new char[]{'\u03b9', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f31';
        subst = new char[]{'\u03b9', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f32';
        subst = new char[]{'\u03b9', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f33';
        subst = new char[]{'\u03b9', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f34';
        subst = new char[]{'\u03b9', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f35';
        subst = new char[]{'\u03b9', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f36';
        subst = new char[]{'\u03b9', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f37';
        subst = new char[]{'\u03b9', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f38';
        subst = new char[]{'\u0399', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f39';
        subst = new char[]{'\u0399', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f3a';
        subst = new char[]{'\u0399', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f3b';
        subst = new char[]{'\u0399', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f3c';
        subst = new char[]{'\u0399', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f3d';
        subst = new char[]{'\u0399', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f3e';
        subst = new char[]{'\u0399', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f3f';
        subst = new char[]{'\u0399', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f40';
        subst = new char[]{'\u03bf', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f41';
        subst = new char[]{'\u03bf', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f42';
        subst = new char[]{'\u03bf', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f43';
        subst = new char[]{'\u03bf', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f44';
        subst = new char[]{'\u03bf', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f45';
        subst = new char[]{'\u03bf', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f48';
        subst = new char[]{'\u039f', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f49';
        subst = new char[]{'\u039f', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f4a';
        subst = new char[]{'\u039f', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f4b';
        subst = new char[]{'\u039f', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f4c';
        subst = new char[]{'\u039f', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f4d';
        subst = new char[]{'\u039f', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f50';
        subst = new char[]{'\u03c5', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f51';
        subst = new char[]{'\u03c5', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f52';
        subst = new char[]{'\u03c5', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f53';
        subst = new char[]{'\u03c5', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f54';
        subst = new char[]{'\u03c5', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f55';
        subst = new char[]{'\u03c5', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f56';
        subst = new char[]{'\u03c5', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f57';
        subst = new char[]{'\u03c5', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f59';
        subst = new char[]{'\u03a5', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f5b';
        subst = new char[]{'\u03a5', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f5d';
        subst = new char[]{'\u03a5', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f5f';
        subst = new char[]{'\u03a5', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f60';
        subst = new char[]{'\u03c9', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f61';
        subst = new char[]{'\u03c9', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f62';
        subst = new char[]{'\u03c9', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f63';
        subst = new char[]{'\u03c9', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f64';
        subst = new char[]{'\u03c9', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f65';
        subst = new char[]{'\u03c9', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f66';
        subst = new char[]{'\u03c9', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f67';
        subst = new char[]{'\u03c9', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f68';
        subst = new char[]{'\u03a9', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f69';
        subst = new char[]{'\u03a9', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f6a';
        subst = new char[]{'\u03a9', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f6b';
        subst = new char[]{'\u03a9', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f6c';
        subst = new char[]{'\u03a9', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f6d';
        subst = new char[]{'\u03a9', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f6e';
        subst = new char[]{'\u03a9', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f6f';
        subst = new char[]{'\u03a9', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f70';
        subst = new char[]{'\u03b1', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f71';
        subst = new char[]{'\u03b1', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f72';
        subst = new char[]{'\u03b5', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f73';
        subst = new char[]{'\u03b5', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f74';
        subst = new char[]{'\u03b7', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f75';
        subst = new char[]{'\u03b7', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f76';
        subst = new char[]{'\u03b9', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f77';
        subst = new char[]{'\u03b9', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f78';
        subst = new char[]{'\u03bf', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f79';
        subst = new char[]{'\u03bf', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f7a';
        subst = new char[]{'\u03c5', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f7b';
        subst = new char[]{'\u03c5', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f7c';
        subst = new char[]{'\u03c9', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f7d';
        subst = new char[]{'\u03c9', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f80';
        subst = new char[]{'\u03b1', '\u0345', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f81';
        subst = new char[]{'\u03b1', '\u0345', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f82';
        subst = new char[]{'\u03b1', '\u0345', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f83';
        subst = new char[]{'\u03b1', '\u0345', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f84';
        subst = new char[]{'\u03b1', '\u0345', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f85';
        subst = new char[]{'\u03b1', '\u0345', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f86';
        subst = new char[]{'\u03b1', '\u0345', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f87';
        subst = new char[]{'\u03b1', '\u0345', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f88';
        subst = new char[]{'\u0391', '\u0345', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f89';
        subst = new char[]{'\u0391', '\u0345', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f8a';
        subst = new char[]{'\u0391', '\u0345', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f8b';
        subst = new char[]{'\u0391', '\u0345', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f8c';
        subst = new char[]{'\u0391', '\u0345', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f8d';
        subst = new char[]{'\u0391', '\u0345', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f8e';
        subst = new char[]{'\u0391', '\u0345', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f8f';
        subst = new char[]{'\u0391', '\u0345', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f90';
        subst = new char[]{'\u03b7', '\u0345', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f91';
        subst = new char[]{'\u03b7', '\u0345', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f92';
        subst = new char[]{'\u03b7', '\u0345', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f93';
        subst = new char[]{'\u03b7', '\u0345', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f94';
        subst = new char[]{'\u03b7', '\u0345', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f95';
        subst = new char[]{'\u03b7', '\u0345', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f96';
        subst = new char[]{'\u03b7', '\u0345', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f97';
        subst = new char[]{'\u03b7', '\u0345', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f98';
        subst = new char[]{'\u0397', '\u0345', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f99';
        subst = new char[]{'\u0397', '\u0345', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f9a';
        subst = new char[]{'\u0397', '\u0345', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f9b';
        subst = new char[]{'\u0397', '\u0345', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f9c';
        subst = new char[]{'\u0397', '\u0345', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f9d';
        subst = new char[]{'\u0397', '\u0345', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f9e';
        subst = new char[]{'\u0397', '\u0345', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1f9f';
        subst = new char[]{'\u0397', '\u0345', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa0';
        subst = new char[]{'\u03c9', '\u0345', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa1';
        subst = new char[]{'\u03c9', '\u0345', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa2';
        subst = new char[]{'\u03c9', '\u0345', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa3';
        subst = new char[]{'\u03c9', '\u0345', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa4';
        subst = new char[]{'\u03c9', '\u0345', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa5';
        subst = new char[]{'\u03c9', '\u0345', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa6';
        subst = new char[]{'\u03c9', '\u0345', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa7';
        subst = new char[]{'\u03c9', '\u0345', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa8';
        subst = new char[]{'\u03a9', '\u0345', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fa9';
        subst = new char[]{'\u03a9', '\u0345', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1faa';
        subst = new char[]{'\u03a9', '\u0345', '\u0313', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fab';
        subst = new char[]{'\u03a9', '\u0345', '\u0314', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fac';
        subst = new char[]{'\u03a9', '\u0345', '\u0313', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fad';
        subst = new char[]{'\u03a9', '\u0345', '\u0314', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fae';
        subst = new char[]{'\u03a9', '\u0345', '\u0313', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1faf';
        subst = new char[]{'\u03a9', '\u0345', '\u0314', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb0';
        subst = new char[]{'\u03b1', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb1';
        subst = new char[]{'\u03b1', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb2';
        subst = new char[]{'\u03b1', '\u0345', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb3';
        subst = new char[]{'\u03b1', '\u0345'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb4';
        subst = new char[]{'\u03b1', '\u0345', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb6';
        subst = new char[]{'\u03b1', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb7';
        subst = new char[]{'\u03b1', '\u0345', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb8';
        subst = new char[]{'\u0391', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fb9';
        subst = new char[]{'\u0391', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fba';
        subst = new char[]{'\u0391', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fbb';
        subst = new char[]{'\u0391', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fbc';
        subst = new char[]{'\u0391', '\u0345'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fbe';
        subst = new char[]{'\u03b9'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fc1';
        subst = new char[]{'\u00a8', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fc2';
        subst = new char[]{'\u03b7', '\u0345', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fc3';
        subst = new char[]{'\u03b7', '\u0345'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fc4';
        subst = new char[]{'\u03b7', '\u0345', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fc6';
        subst = new char[]{'\u03b7', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fc7';
        subst = new char[]{'\u03b7', '\u0345', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fc8';
        subst = new char[]{'\u0395', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fc9';
        subst = new char[]{'\u0395', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fca';
        subst = new char[]{'\u0397', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fcb';
        subst = new char[]{'\u0397', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fcc';
        subst = new char[]{'\u0397', '\u0345'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fcd';
        subst = new char[]{'\u1fbf', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fce';
        subst = new char[]{'\u1fbf', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fcf';
        subst = new char[]{'\u1fbf', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fd0';
        subst = new char[]{'\u03b9', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fd1';
        subst = new char[]{'\u03b9', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fd2';
        subst = new char[]{'\u03b9', '\u0308', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fd3';
        subst = new char[]{'\u03b9', '\u0308', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fd6';
        subst = new char[]{'\u03b9', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fd7';
        subst = new char[]{'\u03b9', '\u0308', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fd8';
        subst = new char[]{'\u0399', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fd9';
        subst = new char[]{'\u0399', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fda';
        subst = new char[]{'\u0399', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fdb';
        subst = new char[]{'\u0399', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fdd';
        subst = new char[]{'\u1ffe', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fde';
        subst = new char[]{'\u1ffe', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fdf';
        subst = new char[]{'\u1ffe', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe0';
        subst = new char[]{'\u03c5', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe1';
        subst = new char[]{'\u03c5', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe2';
        subst = new char[]{'\u03c5', '\u0308', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe3';
        subst = new char[]{'\u03c5', '\u0308', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe4';
        subst = new char[]{'\u03c1', '\u0313'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe5';
        subst = new char[]{'\u03c1', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe6';
        subst = new char[]{'\u03c5', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe7';
        subst = new char[]{'\u03c5', '\u0308', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe8';
        subst = new char[]{'\u03a5', '\u0306'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fe9';
        subst = new char[]{'\u03a5', '\u0304'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fea';
        subst = new char[]{'\u03a5', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1feb';
        subst = new char[]{'\u03a5', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fec';
        subst = new char[]{'\u03a1', '\u0314'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fed';
        subst = new char[]{'\u00a8', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fee';
        subst = new char[]{'\u00a8', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1fef';
        subst = new char[]{'`'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ff2';
        subst = new char[]{'\u03c9', '\u0345', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ff3';
        subst = new char[]{'\u03c9', '\u0345'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ff4';
        subst = new char[]{'\u03bf', '\u0345', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ff6';
        subst = new char[]{'\u03c9', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ff7';
        subst = new char[]{'\u03c9', '\u0345', '\u0342'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ff8';
        subst = new char[]{'\u039f', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ff9';
        subst = new char[]{'\u039f', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ffa';
        subst = new char[]{'\u03a9', '\u0300'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ffb';
        subst = new char[]{'\u03a9', '\u0301'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ffc';
        subst = new char[]{'\u03a9', '\u0345'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u1ffd';
        subst = new char[]{'\u00b4'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u304c';
        subst = new char[]{'\u304b', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u304e';
        subst = new char[]{'\u304d', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3050';
        subst = new char[]{'\u304f', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3052';
        subst = new char[]{'\u3051', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3054';
        subst = new char[]{'\u3053', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3056';
        subst = new char[]{'\u3055', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3058';
        subst = new char[]{'\u3057', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u305a';
        subst = new char[]{'\u3059', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u305c';
        subst = new char[]{'\u305b', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u305e';
        subst = new char[]{'\u305d', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3060';
        subst = new char[]{'\u305f', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3062';
        subst = new char[]{'\u3061', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3065';
        subst = new char[]{'\u3064', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3067';
        subst = new char[]{'\u3066', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3069';
        subst = new char[]{'\u3068', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3070';
        subst = new char[]{'\u306f', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3071';
        subst = new char[]{'\u306f', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3073';
        subst = new char[]{'\u3072', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3074';
        subst = new char[]{'\u3072', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3076';
        subst = new char[]{'\u3075', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3077';
        subst = new char[]{'\u3075', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3079';
        subst = new char[]{'\u3078', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u307a';
        subst = new char[]{'\u3078', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u307c';
        subst = new char[]{'\u307b', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u307d';
        subst = new char[]{'\u307b', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u3094';
        subst = new char[]{'\u3046', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u309e';
        subst = new char[]{'\u309d', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30ac';
        subst = new char[]{'\u30ab', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30ae';
        subst = new char[]{'\u30ad', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30b0';
        subst = new char[]{'\u30af', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30b2';
        subst = new char[]{'\u30b1', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30b4';
        subst = new char[]{'\u30b3', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30b6';
        subst = new char[]{'\u30b5', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30b8';
        subst = new char[]{'\u30b7', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30ba';
        subst = new char[]{'\u30b9', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30bc';
        subst = new char[]{'\u30bb', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30be';
        subst = new char[]{'\u30bd', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30c0';
        subst = new char[]{'\u30bf', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30c2';
        subst = new char[]{'\u30c1', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30c5';
        subst = new char[]{'\u30c4', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30c7';
        subst = new char[]{'\u30c6', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30c9';
        subst = new char[]{'\u30c8', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30d0';
        subst = new char[]{'\u30cf', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30d1';
        subst = new char[]{'\u30cf', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30d3';
        subst = new char[]{'\u30d2', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30d4';
        subst = new char[]{'\u30d2', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30d6';
        subst = new char[]{'\u30d5', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30d7';
        subst = new char[]{'\u30d5', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30d9';
        subst = new char[]{'\u30d8', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30da';
        subst = new char[]{'\u30d8', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30dc';
        subst = new char[]{'\u30db', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30dd';
        subst = new char[]{'\u30db', '\u309a'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30f4';
        subst = new char[]{'\u30a6', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30f7';
        subst = new char[]{'\u30ef', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30f8';
        subst = new char[]{'\u30f0', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30f9';
        subst = new char[]{'\u30f1', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30fa';
        subst = new char[]{'\u30f2', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\u30fe';
        subst = new char[]{'\u30fd', '\u3099'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb1f';
        subst = new char[]{'\u05f2', '\u05b7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb2a';
        subst = new char[]{'\u05e9', '\u05c1'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb2b';
        subst = new char[]{'\u05e9', '\u05c2'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb2c';
        subst = new char[]{'\u05e9', '\u05bc', '\u05c1'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb2d';
        subst = new char[]{'\u05e9', '\u05bc', '\u05c2'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb2e';
        subst = new char[]{'\u05d0', '\u05b7'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb2f';
        subst = new char[]{'\u05d0', '\u05b8'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb30';
        subst = new char[]{'\u05d0', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb31';
        subst = new char[]{'\u05d1', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb32';
        subst = new char[]{'\u05d2', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb33';
        subst = new char[]{'\u05d3', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb34';
        subst = new char[]{'\u05d4', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb35';
        subst = new char[]{'\u05d5', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb36';
        subst = new char[]{'\u05d6', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb38';
        subst = new char[]{'\u05d8', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb39';
        subst = new char[]{'\u05d9', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb3a';
        subst = new char[]{'\u05da', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb3b';
        subst = new char[]{'\u05db', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb3c';
        subst = new char[]{'\u05dc', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb3e';
        subst = new char[]{'\u05de', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb40';
        subst = new char[]{'\u05e0', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb41';
        subst = new char[]{'\u05e1', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb43';
        subst = new char[]{'\u05e3', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb44';
        subst = new char[]{'\u05e4', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb46';
        subst = new char[]{'\u05e6', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb47';
        subst = new char[]{'\u05e7', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb48';
        subst = new char[]{'\u05e8', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb49';
        subst = new char[]{'\u05e9', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb4a';
        subst = new char[]{'\u05ea', '\u05bc'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb4b';
        subst = new char[]{'\u05d5', '\u05b9'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb4c';
        subst = new char[]{'\u05d1', '\u05bf'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb4d';
        subst = new char[]{'\u05db', '\u05bf'};
        decompositionTable.put(Character.valueOf(key), subst);
        key = '\ufb4e';
        subst = new char[]{'\u05e4', '\u05bf'};
        decompositionTable.put(Character.valueOf(key), subst);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrieNode {
        private final Hashtable<Character, TrieNode> childNodes = new Hashtable();
        private char[] replacementSequence = null;
        private char trig;
        private long id;

        public TrieNode(char trig) {
            this.trig = trig;
            this.id = nextID++;
        }

        public void addChild(char nextChar, TrieNode childNode) {
            this.childNodes.put(Character.valueOf(nextChar), childNode);
        }

        public TrieNode getChild(char nextChar) {
            return this.childNodes.get(Character.valueOf(nextChar));
        }

        public Collection<TrieNode> getChildren() {
            return this.childNodes.values();
        }

        public void setReplacementSequence(char[] seq) {
            this.replacementSequence = seq;
        }

        public char[] getReplacementSequence() {
            return this.replacementSequence;
        }

        public String toString() {
            return "{" + this.id + "} 0x" + Util.toHexStringBE(this.trig) + (this.replacementSequence == null ? "" : " -> 0x" + Util.toHexStringBE(this.replacementSequence));
        }
    }

    private static class HangulDecomposition {
        static final int SBase = 44032;
        static final int LBase = 4352;
        static final int VBase = 4449;
        static final int TBase = 4519;
        static final int LCount = 19;
        static final int VCount = 21;
        static final int TCount = 28;
        static final int NCount = 588;
        static final int SCount = 11172;

        private HangulDecomposition() {
        }

        public static String decomposeHangul(char s) {
            int SIndex = s - 44032;
            if (SIndex < 0 || SIndex >= 11172) {
                return String.valueOf(s);
            }
            StringBuffer result = new StringBuffer();
            int L = 4352 + SIndex / 588;
            int V = 4449 + SIndex % 588 / 28;
            int T = 4519 + SIndex % 28;
            result.append((char)L);
            result.append((char)V);
            if (T != 4519) {
                result.append((char)T);
            }
            return result.toString();
        }

        public static String composeHangul(String source) {
            int len = source.length();
            if (len == 0) {
                return "";
            }
            StringBuffer result = new StringBuffer();
            char last = source.charAt(0);
            result.append(last);
            for (int i = 1; i < len; ++i) {
                int TIndex;
                int VIndex;
                char ch = source.charAt(i);
                int LIndex = last - 4352;
                if (0 <= LIndex && LIndex < 19 && 0 <= (VIndex = ch - 4449) && VIndex < 21) {
                    last = (char)(44032 + (LIndex * 21 + VIndex) * 28);
                    result.setCharAt(result.length() - 1, last);
                    continue;
                }
                int SIndex = last - 44032;
                if (0 <= SIndex && SIndex < 11172 && SIndex % 28 == 0 && 0 < (TIndex = ch - 4519) && TIndex < 28) {
                    last = (char)(last + TIndex);
                    result.setCharAt(result.length() - 1, last);
                    continue;
                }
                last = ch;
                result.append(ch);
            }
            return result.toString();
        }
    }
}

