/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs;

import java.io.IOException;
import java.io.OutputStream;
import org.catacombae.hfs.AllocationFile;
import org.catacombae.hfs.AttributesFile;
import org.catacombae.hfs.BTreeOperations;
import org.catacombae.hfs.CatalogFile;
import org.catacombae.hfs.CatalogOperations;
import org.catacombae.hfs.ExtentsOverflowFile;
import org.catacombae.hfs.ExtentsOverflowOperations;
import org.catacombae.hfs.HotFilesFile;
import org.catacombae.hfs.Journal;
import org.catacombae.hfs.ProgressMonitor;
import org.catacombae.hfs.io.ForkFilter;
import org.catacombae.hfs.io.ReadableBlockCachingStream;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessSubstream;
import org.catacombae.io.SynchronizedReadableRandomAccess;
import org.catacombae.io.SynchronizedReadableRandomAccessStream;

public abstract class HFSVolume {
    public static volatile long fileReadOffset = 0L;
    protected volatile SynchronizedReadableRandomAccess hfsFile;
    private volatile SynchronizedReadableRandomAccessStream hfsStream;
    private final SynchronizedReadableRandomAccessStream sourceStream;
    protected final int physicalBlockSize;
    protected final CatalogFile catalogFile;
    protected final ExtentsOverflowFile extentsOverflowFile;
    private boolean closed = false;

    protected HFSVolume(ReadableRandomAccessStream hfsFile, boolean cachingEnabled, BTreeOperations btreeOperations, CatalogOperations catalogOperations, ExtentsOverflowOperations extentsOverflowOperations) {
        this.sourceStream = new SynchronizedReadableRandomAccessStream(hfsFile);
        this.hfsStream = new SynchronizedReadableRandomAccessStream(new ReadableRandomAccessSubstream(this.sourceStream));
        this.hfsFile = this.hfsStream;
        this.physicalBlockSize = 512;
        if (cachingEnabled) {
            this.enableFileSystemCaching();
        }
        this.catalogFile = new CatalogFile(this, btreeOperations, catalogOperations);
        this.extentsOverflowFile = new ExtentsOverflowFile(this, btreeOperations, extentsOverflowOperations);
        try {
            this.runSanityChecks();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void runSanityChecks() throws Exception {
        byte[] block = new byte[512];
        ReadableRandomAccessStream fsStream = this.createFSStream();
        long res = fsStream.length() % 512L;
        if (res != 0L && res != -1L) {
            throw new Exception("Length of file system (" + fsStream.length() + ") is not block-aligned. Found " + res + " extra bytes.");
        }
        fsStream.seek(0L);
        int bytesRead = fsStream.read(block);
        if (bytesRead != 512) {
            throw new Exception("Failed to read first block. Managed to read " + bytesRead + " bytes from the beginning of " + "the volume.");
        }
        if (fsStream.length() > 0L) {
            fsStream.seek(fsStream.length() - 512L);
            bytesRead = fsStream.read(block);
            if (bytesRead != 512) {
                throw new Exception("Failed to read last block. Managed to read " + bytesRead + " bytes from the end of " + "the volume.");
            }
        }
        fsStream.close();
        CommonHFSVolumeHeader vh = this.getVolumeHeader();
        if (!vh.isValid()) {
            System.err.println("Detected invalid volume header:");
            vh.print(System.err, "  ");
            throw new Exception("Invalid volume header!");
        }
    }

    public ReadableRandomAccessStream createFSStream() {
        ReadableRandomAccessSubstream subs = new ReadableRandomAccessSubstream(this.hfsFile);
        return subs;
    }

    public abstract CommonHFSVolumeHeader getVolumeHeader();

    public CatalogFile getCatalogFile() {
        return this.catalogFile;
    }

    public ExtentsOverflowFile getExtentsOverflowFile() {
        return this.extentsOverflowFile;
    }

    public abstract AllocationFile getAllocationFile();

    public abstract boolean hasAttributesFile();

    public abstract boolean hasJournal();

    public abstract boolean hasHotFilesFile();

    public abstract AttributesFile getAttributesFile();

    public abstract Journal getJournal();

    public abstract HotFilesFile getHotFilesFile();

    public abstract CommonHFSCatalogNodeID getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID var1);

    public abstract CommonHFSExtentKey createCommonHFSExtentKey(boolean var1, int var2, long var3);

    public abstract CommonHFSCatalogString getEmptyString();

    public abstract String decodeString(CommonHFSCatalogString var1);

    public abstract CommonHFSCatalogString encodeString(String var1);

    public synchronized void close() {
        if (this.closed) {
            throw new RuntimeException("Already closed.");
        }
        this.hfsStream.close();
        this.sourceStream.close();
        this.closed = true;
    }

    public void enableFileSystemCaching() {
        this.enableFileSystemCaching(262144, 64);
    }

    public void enableFileSystemCaching(int blockSize, int blocksInCache) {
        this.hfsStream.close();
        this.hfsStream = new SynchronizedReadableRandomAccessStream(new ReadableBlockCachingStream(new ReadableRandomAccessSubstream(this.sourceStream), blockSize, blocksInCache));
        this.hfsFile = this.hfsStream;
    }

    public void disableFileSystemCaching() {
        this.hfsStream.close();
        this.hfsStream = new SynchronizedReadableRandomAccessStream(new ReadableRandomAccessSubstream(this.sourceStream));
        this.hfsFile = this.hfsStream;
    }

    public long extractDataForkToStream(CommonHFSCatalogLeafRecord fileRecord, OutputStream os, ProgressMonitor pm) throws IOException {
        if (fileRecord instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)fileRecord).getData();
            CommonHFSForkData dataFork = catFile.getDataFork();
            return this.extractForkToStream(ForkFilter.ForkType.DATA, catFile.getFileID().toLong(), dataFork, os, pm);
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    public long extractResourceForkToStream(CommonHFSCatalogLeafRecord fileRecord, OutputStream os, ProgressMonitor pm) throws IOException {
        if (fileRecord instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)fileRecord).getData();
            CommonHFSForkData resFork = catFile.getResourceFork();
            return this.extractForkToStream(ForkFilter.ForkType.RESOURCE, catFile.getFileID().toLong(), resFork, os, pm);
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    private long extractForkToStream(ForkFilter.ForkType forkType, long cnid, CommonHFSForkData forkData, OutputStream os, ProgressMonitor pm) throws IOException {
        long bytesToRead;
        int bytesRead;
        CommonHFSVolumeHeader header = this.getVolumeHeader();
        ForkFilter forkFilter = new ForkFilter(forkType, cnid, forkData, this.extentsOverflowFile, new ReadableRandomAccessSubstream(this.hfsFile), 0L, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)this.physicalBlockSize);
        byte[] buffer = new byte[4096];
        for (bytesToRead = forkData.getLogicalSize(); bytesToRead > 0L && !pm.cancelSignaled() && (bytesRead = forkFilter.read(buffer, 0, bytesToRead < (long)buffer.length ? (int)bytesToRead : buffer.length)) >= 0; bytesToRead -= (long)bytesRead) {
            pm.addDataProgress(bytesRead);
            os.write(buffer, 0, bytesRead);
        }
        return forkData.getLogicalSize() - bytesToRead;
    }

    public ReadableRandomAccessStream getReadableDataForkStream(CommonHFSCatalogLeafRecord fileRecord) {
        if (fileRecord instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)fileRecord).getData();
            CommonHFSForkData fork = catFile.getDataFork();
            return this.getReadableForkStream(ForkFilter.ForkType.DATA, catFile.getFileID().toLong(), fork);
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    public ReadableRandomAccessStream getReadableResourceForkStream(CommonHFSCatalogLeafRecord fileRecord) {
        if (fileRecord instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)fileRecord).getData();
            CommonHFSForkData fork = catFile.getResourceFork();
            return this.getReadableForkStream(ForkFilter.ForkType.RESOURCE, catFile.getFileID().toLong(), fork);
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    private ReadableRandomAccessStream getReadableForkStream(ForkFilter.ForkType forkType, long cnid, CommonHFSForkData forkData) {
        CommonHFSVolumeHeader header = this.getVolumeHeader();
        return new ForkFilter(forkType, cnid, forkData, this.extentsOverflowFile, new ReadableRandomAccessSubstream(this.hfsFile), fileReadOffset, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)this.physicalBlockSize);
    }

    private static String getDebugString(CommonHFSExtentKey key) {
        return key.getForkType() + ":" + key.getFileID().toLong() + ":" + key.getStartBlock();
    }

    protected long calculateDataForkSizeRecursive(CommonHFSCatalogLeafRecord[] recs) {
        return this.calculateForkSizeRecursive(recs, false);
    }

    protected long calculateDataForkSizeRecursive(CommonHFSCatalogLeafRecord rec) {
        return this.calculateForkSizeRecursive(rec, false);
    }

    protected long calculateResourceForkSizeRecursive(CommonHFSCatalogLeafRecord[] recs) {
        return this.calculateForkSizeRecursive(recs, true);
    }

    protected long calculateResourceForkSizeRecursive(CommonHFSCatalogLeafRecord rec) {
        return this.calculateForkSizeRecursive(rec, true);
    }

    protected long calculateForkSizeRecursive(CommonHFSCatalogLeafRecord[] recs, boolean resourceFork) {
        long totalSize = 0L;
        for (CommonHFSCatalogLeafRecord rec : recs) {
            totalSize += this.calculateForkSizeRecursive(rec, resourceFork);
        }
        return totalSize;
    }

    protected long calculateForkSizeRecursive(CommonHFSCatalogLeafRecord rec, boolean resourceFork) {
        if (rec instanceof CommonHFSCatalogFileRecord) {
            if (!resourceFork) {
                return ((CommonHFSCatalogFileRecord)rec).getData().getDataFork().getLogicalSize();
            }
            return ((CommonHFSCatalogFileRecord)rec).getData().getResourceFork().getLogicalSize();
        }
        if (rec instanceof CommonHFSCatalogFolderRecord) {
            CommonHFSCatalogNodeID requestedID = ((CommonHFSCatalogFolderRecord)rec).getData().getFolderID();
            CommonHFSCatalogLeafRecord[] contents = this.catalogFile.listRecords(requestedID);
            long totalSize = 0L;
            for (CommonHFSCatalogLeafRecord outRec : contents) {
                totalSize += this.calculateForkSizeRecursive(outRec, resourceFork);
            }
            return totalSize;
        }
        return 0L;
    }

    public int getPhysicalBlockSize() {
        return this.physicalBlockSize;
    }
}

