/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs;

import java.util.LinkedList;
import org.catacombae.hfs.BTreeFile;
import org.catacombae.hfs.BTreeOperations;
import org.catacombae.hfs.ExtentsOverflowOperations;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.io.ForkFilter;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfs.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTNode;
import org.catacombae.hfs.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkType;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessSubstream;

public class ExtentsOverflowFile
extends BTreeFile {
    private final ExtentsOverflowOperations ops;

    ExtentsOverflowFile(HFSVolume vol, BTreeOperations superOps, ExtentsOverflowOperations ops) {
        super(vol, superOps);
        this.ops = ops;
    }

    ExtentsOverflowFileSession openSession() {
        return new ExtentsOverflowFileSession();
    }

    public long getRootNodeNumber() {
        ExtentsOverflowFileSession ses = this.openSession();
        return ses.bthr.getRootNodeNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonBTNode getRootNode() {
        ExtentsOverflowFileSession ses = this.openSession();
        try {
            long rootNode = ses.bthr.getRootNodeNumber();
            if (rootNode == 0L) {
                CommonBTNode commonBTNode = null;
                return commonBTNode;
            }
            if (rootNode < 0L || rootNode > 0xFFFFFFFEL) {
                throw new RuntimeException("Internal error - rootNode out of range: " + rootNode);
            }
            CommonBTNode commonBTNode = this.getExtentsOverflowNode(rootNode);
            return commonBTNode;
        }
        finally {
            ses.close();
        }
    }

    public CommonBTHeaderNode getHeaderNode() {
        CommonBTNode firstNode = this.getExtentsOverflowNode(0L);
        if (firstNode instanceof CommonBTHeaderNode) {
            return (CommonBTHeaderNode)firstNode;
        }
        throw new RuntimeException("Unexpected node type at catalog node 0: " + firstNode.getClass());
    }

    public CommonBTNode getNode(long nodeNumber) {
        return this.getExtentsOverflowNode(nodeNumber);
    }

    public CommonBTNode getExtentsOverflowNode(long nodeNumber) {
        long currentNodeNumber;
        ExtentsOverflowFileSession init = this.openSession();
        if (nodeNumber < 0L) {
            currentNodeNumber = init.bthr.getRootNodeNumber();
            if (currentNodeNumber == 0L) {
                return null;
            }
        } else {
            currentNodeNumber = nodeNumber;
        }
        int nodeSize = init.bthr.getNodeSize();
        byte[] currentNodeData = new byte[nodeSize];
        try {
            init.extentsFile.seek(currentNodeNumber * (long)nodeSize);
            init.extentsFile.readFully(currentNodeData);
        }
        catch (RuntimeException e) {
            System.err.println("RuntimeException in getCatalogNode. Printing additional information:");
            System.err.println("  nodeNumber=" + nodeNumber);
            System.err.println("  currentNodeNumber=" + currentNodeNumber);
            System.err.println("  nodeSize=" + nodeSize);
            System.err.println("  init.extentsFile.length()=" + init.extentsFile.length());
            System.err.println("  (currentNodeNumber * nodeSize)=" + currentNodeNumber * (long)nodeSize);
            throw e;
        }
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.HEADER) {
            return this.createCommonBTHeaderNode(currentNodeData, 0, nodeSize);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            return this.createCommonHFSExtentIndexNode(currentNodeData, 0, nodeSize);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            return this.createCommonHFSExtentLeafNode(currentNodeData, 0, nodeSize);
        }
        return null;
    }

    public CommonHFSExtentLeafRecord getOverflowExtent(CommonHFSExtentKey key) {
        ExtentsOverflowFileSession init = this.openSession();
        int nodeSize = init.bthr.getNodeSize();
        long currentNodeOffset = init.bthr.getRootNodeNumber() * (long)nodeSize;
        byte[] currentNodeData = new byte[nodeSize];
        init.extentsFile.seek(currentNodeOffset);
        init.extentsFile.readFully(currentNodeData);
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            CommonHFSExtentIndexNode currentNode = this.createCommonHFSExtentIndexNode(currentNodeData, 0, nodeSize);
            CommonBTIndexRecord<CommonHFSExtentKey> matchingRecord = ExtentsOverflowFile.findLEKey(currentNode, key);
            currentNodeOffset = matchingRecord.getIndex() * (long)nodeSize;
            init.extentsFile.seek(currentNodeOffset);
            init.extentsFile.readFully(currentNodeData);
            nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            CommonHFSExtentLeafRecord[] recs;
            CommonHFSExtentLeafNode leaf = this.createCommonHFSExtentLeafNode(currentNodeData, 0, nodeSize);
            for (CommonHFSExtentLeafRecord rec : recs = leaf.getLeafRecords()) {
                CommonHFSExtentKey curKey = rec.getKey();
                if (curKey.compareTo(key) != 0) continue;
                return rec;
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + (Object)((Object)nodeDescriptor.getNodeType()));
    }

    public CommonHFSExtentLeafRecord getOverflowExtent(boolean isResource, int cnid, long startBlock) {
        return this.getOverflowExtent(this.vol.createCommonHFSExtentKey(isResource, cnid, startBlock));
    }

    public CommonHFSExtentDescriptor[] getAllExtents(CommonHFSCatalogNodeID fileID, CommonHFSForkData forkData, CommonHFSForkType forkType) {
        CommonHFSExtentDescriptor[] result;
        if (fileID == null) {
            throw new IllegalArgumentException("fileID == null");
        }
        if (forkData == null) {
            throw new IllegalArgumentException("forkData == null");
        }
        if (forkType == null) {
            throw new IllegalArgumentException("forkType == null");
        }
        long allocationBlockSize = this.vol.getVolumeHeader().getAllocationBlockSize();
        long basicExtentsBlockCount = 0L;
        CommonHFSExtentDescriptor[] basicExtents = forkData.getBasicExtents();
        for (int i = 0; i < basicExtents.length; ++i) {
            basicExtentsBlockCount += basicExtents[i].getBlockCount();
        }
        if (basicExtentsBlockCount * allocationBlockSize >= forkData.getLogicalSize()) {
            result = forkData.getBasicExtents();
        } else {
            LinkedList<CommonHFSExtentDescriptor> resultList = new LinkedList<CommonHFSExtentDescriptor>();
            for (CommonHFSExtentDescriptor descriptor : forkData.getBasicExtents()) {
                resultList.add(descriptor);
            }
            long totalBlockCount = basicExtentsBlockCount;
            while (totalBlockCount * allocationBlockSize < forkData.getLogicalSize()) {
                CommonHFSExtentDescriptor[] currentRecordData;
                CommonHFSExtentKey extentKey = this.createCommonHFSExtentKey(forkType, fileID, (int)totalBlockCount);
                CommonHFSExtentLeafRecord currentRecord = this.getOverflowExtent(extentKey);
                if (currentRecord == null) {
                    System.err.println("ERROR: currentRecord == null!!");
                    System.err.print("       extentKey");
                    if (extentKey != null) {
                        System.err.println(":");
                        extentKey.print(System.err, "         ");
                    } else {
                        System.err.println(" == null!!");
                    }
                }
                for (CommonHFSExtentDescriptor cur : currentRecordData = currentRecord.getRecordData()) {
                    resultList.add(cur);
                    totalBlockCount += cur.getBlockCount();
                }
            }
            result = resultList.toArray(new CommonHFSExtentDescriptor[resultList.size()]);
        }
        return result;
    }

    public CommonHFSExtentDescriptor[] getAllExtents(CommonHFSCatalogLeafRecord requestFile, CommonHFSForkType forkType) {
        if (requestFile instanceof CommonHFSCatalogFileRecord) {
            CommonHFSForkData forkData;
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)requestFile).getData();
            if (forkType == CommonHFSForkType.DATA_FORK) {
                forkData = catFile.getDataFork();
            } else if (forkType == CommonHFSForkType.RESOURCE_FORK) {
                forkData = catFile.getResourceFork();
            } else {
                throw new IllegalArgumentException("Illegal fork type!");
            }
            return this.getAllExtents(catFile.getFileID(), forkData, forkType);
        }
        throw new IllegalArgumentException("Not a file record!");
    }

    public CommonHFSExtentDescriptor[] getAllExtentDescriptors(CommonHFSCatalogLeafRecord requestFile, CommonHFSForkType forkType) {
        return this.getAllExtentDescriptors(this.getAllExtents(requestFile, forkType));
    }

    public CommonHFSExtentDescriptor[] getAllExtentDescriptors(CommonHFSCatalogNodeID fileID, CommonHFSForkData forkData, CommonHFSForkType forkType) {
        return this.getAllExtentDescriptors(this.getAllExtents(fileID, forkData, forkType));
    }

    protected CommonHFSExtentDescriptor[] getAllExtentDescriptors(CommonHFSExtentDescriptor[] descriptors) {
        LinkedList<CommonHFSExtentDescriptor> descTmp = new LinkedList<CommonHFSExtentDescriptor>();
        for (CommonHFSExtentDescriptor desc : descriptors) {
            if (desc.getStartBlock() == 0L && desc.getBlockCount() == 0L) break;
            descTmp.addLast(desc);
        }
        return descTmp.toArray(new CommonHFSExtentDescriptor[descTmp.size()]);
    }

    public CommonHFSExtentDescriptor[] getAllDataExtentDescriptors(CommonHFSCatalogNodeID fileID, CommonHFSForkData forkData) {
        return this.getAllExtentDescriptors(fileID, forkData, CommonHFSForkType.DATA_FORK);
    }

    public CommonHFSExtentDescriptor[] getAllDataExtentDescriptors(CommonHFSCatalogLeafRecord requestFile) {
        return this.getAllExtentDescriptors(requestFile, CommonHFSForkType.DATA_FORK);
    }

    public CommonHFSExtentDescriptor[] getAllResourceExtentDescriptors(CommonHFSCatalogNodeID fileID, CommonHFSForkData forkData) {
        return this.getAllExtentDescriptors(fileID, forkData, CommonHFSForkType.RESOURCE_FORK);
    }

    public CommonHFSExtentDescriptor[] getAllResourceExtentDescriptors(CommonHFSCatalogLeafRecord requestFile) {
        return this.getAllExtentDescriptors(requestFile, CommonHFSForkType.RESOURCE_FORK);
    }

    protected CommonHFSExtentIndexNode createCommonHFSExtentIndexNode(byte[] currentNodeData, int offset, int nodeSize) {
        return this.ops.createCommonHFSExtentIndexNode(currentNodeData, offset, nodeSize);
    }

    protected CommonHFSExtentLeafNode createCommonHFSExtentLeafNode(byte[] currentNodeData, int offset, int nodeSize) {
        return this.ops.createCommonHFSExtentLeafNode(currentNodeData, offset, nodeSize);
    }

    protected CommonHFSExtentKey createCommonHFSExtentKey(CommonHFSForkType forkType, CommonHFSCatalogNodeID fileID, int startBlock) {
        return this.ops.createCommonHFSExtentKey(forkType, fileID, startBlock);
    }

    class ExtentsOverflowFileSession
    extends BTreeFile.BTreeFileSession {
        final ReadableRandomAccessStream extentsFile;

        public ExtentsOverflowFileSession() {
            this.extentsFile = this.btreeStream;
        }

        protected ReadableRandomAccessStream getBTreeStream(CommonHFSVolumeHeader header) {
            return new ForkFilter(ForkFilter.ForkType.DATA, ExtentsOverflowFile.this.vol.getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID.EXTENTS_FILE).toLong(), header.getExtentsOverflowFile(), null, new ReadableRandomAccessSubstream(ExtentsOverflowFile.this.vol.hfsFile), 0L, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)ExtentsOverflowFile.this.vol.physicalBlockSize);
        }
    }
}

