/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.BTreeFile;
import org.catacombae.hfs.BTreeOperations;
import org.catacombae.hfs.CatalogOperations;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.io.ForkFilter;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTNode;
import org.catacombae.hfs.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileThreadRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolder;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderThread;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderThreadRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessSubstream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogFile
extends BTreeFile {
    private final CatalogOperations ops;

    CatalogFile(HFSVolume vol, BTreeOperations superOps, CatalogOperations ops) {
        super(vol, superOps);
        this.ops = ops;
    }

    CatalogFileSession openSession() {
        return new CatalogFileSession();
    }

    @Override
    public long getRootNodeNumber() {
        CatalogFileSession ses = this.openSession();
        return ses.bthr.getRootNodeNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonBTNode getRootNode() {
        CatalogFileSession ses = this.openSession();
        try {
            long rootNode = ses.bthr.getRootNodeNumber();
            if (rootNode == 0L) {
                CommonBTNode commonBTNode = null;
                return commonBTNode;
            }
            if (rootNode < 0L || rootNode > 0xFFFFFFFEL) {
                throw new RuntimeException("Internal error - rootNode out of range: " + rootNode);
            }
            CommonBTNode commonBTNode = this.getCatalogNode(rootNode);
            return commonBTNode;
        }
        finally {
            ses.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonHFSCatalogFolderRecord getRootFolder() {
        CatalogFileSession ses = this.openSession();
        try {
            CommonHFSCatalogFolderRecord commonHFSCatalogFolderRecord = this.doGetRootFolder(ses);
            return commonHFSCatalogFolderRecord;
        }
        finally {
            ses.close();
        }
    }

    private CommonHFSCatalogFolderRecord doGetRootFolder(CatalogFileSession ses) {
        CommonHFSCatalogNodeID parentID = this.vol.getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID.ROOT_PARENT);
        int nodeSize = ses.bthr.getNodeSize();
        long currentNodeOffset = ses.bthr.getRootNodeNumber() * (long)ses.bthr.getNodeSize();
        byte[] currentNodeData = new byte[nodeSize];
        ses.catalogFile.seek(currentNodeOffset);
        ses.catalogFile.readFully(currentNodeData);
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            CommonHFSCatalogIndexNode currentNode = this.newCatalogIndexNode(currentNodeData, 0, ses.bthr.getNodeSize(), ses.bthr);
            CommonBTIndexRecord<CommonHFSCatalogKey> matchingRecord = CatalogFile.findKey(currentNode, parentID);
            currentNodeOffset = matchingRecord.getIndex() * (long)nodeSize;
            ses.catalogFile.seek(currentNodeOffset);
            ses.catalogFile.readFully(currentNodeData);
            nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            CommonHFSCatalogLeafRecord[] recs;
            CommonHFSCatalogLeafNode leaf = this.newCatalogLeafNode(currentNodeData, 0, nodeSize, ses.bthr);
            for (CommonHFSCatalogLeafRecord rec : recs = leaf.getLeafRecords()) {
                if (rec.getKey().getParentID().toLong() != parentID.toLong()) continue;
                if (rec instanceof CommonHFSCatalogFolderRecord) {
                    return (CommonHFSCatalogFolderRecord)rec;
                }
                throw new RuntimeException("Error in internal structures:  root node is not a folder record, but a " + rec.getClass());
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + (Object)((Object)nodeDescriptor.getNodeType()));
    }

    public CommonBTHeaderNode getCatalogHeaderNode() {
        CommonBTNode firstNode = this.getCatalogNode(0L);
        if (firstNode instanceof CommonBTHeaderNode) {
            return (CommonBTHeaderNode)firstNode;
        }
        throw new RuntimeException("Unexpected node type at catalog node 0: " + firstNode.getClass());
    }

    @Override
    public CommonBTNode getNode(long nodeNumber) {
        return this.getCatalogNode(nodeNumber);
    }

    public CommonBTNode getCatalogNode(long nodeNumber) {
        long currentNodeNumber;
        CatalogFileSession ses = this.openSession();
        if (nodeNumber < 0L) {
            currentNodeNumber = ses.bthr.getRootNodeNumber();
            if (currentNodeNumber == 0L) {
                return null;
            }
        } else {
            currentNodeNumber = nodeNumber;
        }
        int nodeSize = ses.bthr.getNodeSize();
        byte[] currentNodeData = new byte[nodeSize];
        try {
            ses.catalogFile.seek(currentNodeNumber * (long)nodeSize);
            ses.catalogFile.readFully(currentNodeData);
        }
        catch (RuntimeException e) {
            System.err.println("RuntimeException in getCatalogNode. Printing additional information:");
            System.err.println("  nodeNumber=" + nodeNumber);
            System.err.println("  currentNodeNumber=" + currentNodeNumber);
            System.err.println("  nodeSize=" + nodeSize);
            System.err.println("  init.catalogFile.length()=" + ses.catalogFile.length());
            System.err.println("  (currentNodeNumber * nodeSize)=" + currentNodeNumber * (long)nodeSize);
            throw e;
        }
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.HEADER) {
            return this.createCommonBTHeaderNode(currentNodeData, 0, ses.bthr.getNodeSize());
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            return this.newCatalogIndexNode(currentNodeData, 0, ses.bthr.getNodeSize(), ses.bthr);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            return this.newCatalogLeafNode(currentNodeData, 0, ses.bthr.getNodeSize(), ses.bthr);
        }
        return null;
    }

    private static CommonBTIndexRecord<CommonHFSCatalogKey> findKey(CommonHFSCatalogIndexNode indexNode, CommonHFSCatalogNodeID parentID) {
        for (CommonBTIndexRecord rec : indexNode.getBTRecords()) {
            CommonHFSCatalogKey key = (CommonHFSCatalogKey)rec.getKey();
            if (key.getParentID().toLong() != parentID.toLong()) continue;
            return rec;
        }
        return null;
    }

    public LinkedList<CommonHFSCatalogLeafRecord> getPathTo(CommonHFSCatalogNodeID leafID) {
        CommonHFSCatalogLeafRecord leafRec = this.getRecord(leafID, this.vol.getEmptyString());
        if (leafRec != null) {
            return this.getPathTo(leafRec);
        }
        throw new RuntimeException("No folder thread found for leaf id " + leafID.toLong() + "!");
    }

    public LinkedList<CommonHFSCatalogLeafRecord> getPathTo(CommonHFSCatalogLeafRecord leaf) {
        if (leaf == null) {
            throw new IllegalArgumentException("argument \"leaf\" must not be null!");
        }
        LinkedList<CommonHFSCatalogLeafRecord> pathList = new LinkedList<CommonHFSCatalogLeafRecord>();
        pathList.addLast(leaf);
        CommonHFSCatalogNodeID parentID = leaf.getKey().getParentID();
        while (!parentID.equals(parentID.getReservedID(CommonHFSCatalogNodeID.ReservedID.ROOT_PARENT))) {
            CommonHFSCatalogLeafRecord parent = this.getRecord(parentID, this.vol.getEmptyString());
            if (parent == null) {
                throw new RuntimeException("No folder thread found!");
            }
            if (parent instanceof CommonHFSCatalogFolderThreadRecord) {
                CommonHFSCatalogFolderThreadRecord threadRec = (CommonHFSCatalogFolderThreadRecord)parent;
                CommonHFSCatalogFolderThread thread = threadRec.getData();
                pathList.addFirst(this.getRecord(thread.getParentID(), thread.getNodeName()));
                parentID = thread.getParentID();
                continue;
            }
            if (parent instanceof CommonHFSCatalogFileThreadRecord) {
                throw new RuntimeException("Tried to get folder thread (" + parentID + ",\"\") but found a file thread!");
            }
            throw new RuntimeException("Tried to get folder thread (" + parentID + ",\"\") but found a " + parent.getClass() + "!");
        }
        return pathList;
    }

    public CommonHFSCatalogLeafRecord getRecord(CommonHFSCatalogNodeID parentID, CommonHFSCatalogString nodeName) {
        CatalogFileSession ses = this.openSession();
        int nodeSize = ses.bthr.getNodeSize();
        long currentNodeOffset = ses.bthr.getRootNodeNumber() * (long)nodeSize;
        byte[] currentNodeData = new byte[ses.bthr.getNodeSize()];
        ses.catalogFile.seek(currentNodeOffset);
        ses.catalogFile.readFully(currentNodeData);
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            CommonHFSCatalogIndexNode currentNode = this.newCatalogIndexNode(currentNodeData, 0, nodeSize, ses.bthr);
            CommonBTIndexRecord<CommonHFSCatalogKey> matchingRecord = CatalogFile.findLEKey(currentNode, this.newCatalogKey(parentID, nodeName, ses.bthr));
            if (matchingRecord == null) {
                return null;
            }
            currentNodeOffset = matchingRecord.getIndex() * (long)nodeSize;
            ses.catalogFile.seek(currentNodeOffset);
            ses.catalogFile.readFully(currentNodeData);
            nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            CommonHFSCatalogLeafRecord[] recs;
            CommonHFSCatalogLeafNode leaf = this.newCatalogLeafNode(currentNodeData, 0, ses.bthr.getNodeSize(), ses.bthr);
            for (CommonHFSCatalogLeafRecord rec : recs = leaf.getLeafRecords()) {
                if (rec.getKey().compareTo(this.newCatalogKey(parentID, nodeName, ses.bthr)) != 0) continue;
                return rec;
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + (Object)((Object)nodeDescriptor.getNodeType()));
    }

    public CommonHFSCatalogLeafRecord[] listRecords(CommonHFSCatalogLeafRecord folderRecord) {
        if (folderRecord instanceof CommonHFSCatalogFolderRecord) {
            CommonHFSCatalogFolder folder = ((CommonHFSCatalogFolderRecord)folderRecord).getData();
            return this.listRecords(folder.getFolderID());
        }
        throw new RuntimeException("Invalid input (not a folder record).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonHFSCatalogLeafRecord[] listRecords(CommonHFSCatalogNodeID folderID) {
        CatalogFileSession init = this.openSession();
        try {
            CommonHFSCatalogLeafRecord[] commonHFSCatalogLeafRecordArray = this.collectFilesInDir(folderID, init.bthr.getRootNodeNumber(), init.header, init.bthr, init.catalogFile);
            return commonHFSCatalogLeafRecordArray;
        }
        finally {
            init.close();
        }
    }

    private CommonHFSCatalogLeafRecord[] collectFilesInDir(CommonHFSCatalogNodeID dirID, long currentNodeIndex, CommonHFSVolumeHeader header, CommonBTHeaderRecord bthr, ReadableRandomAccessStream catalogFile) {
        int nodeSize = bthr.getNodeSize();
        byte[] currentNodeData = new byte[nodeSize];
        catalogFile.seek(currentNodeIndex * (long)nodeSize);
        catalogFile.readFully(currentNodeData);
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            CommonHFSCatalogIndexNode currentNode = this.newCatalogIndexNode(currentNodeData, 0, nodeSize, bthr);
            List<CommonBTIndexRecord<CommonHFSCatalogKey>> matchingRecords = CatalogFile.findLEChildKeys(currentNode, dirID);
            LinkedList<CommonHFSCatalogLeafRecord> results = new LinkedList<CommonHFSCatalogLeafRecord>();
            for (CommonBTIndexRecord<CommonHFSCatalogKey> bir : matchingRecords) {
                CommonHFSCatalogLeafRecord[] partResult;
                for (CommonHFSCatalogLeafRecord curRes : partResult = this.collectFilesInDir(dirID, bir.getIndex(), header, bthr, catalogFile)) {
                    results.addLast(curRes);
                }
            }
            return results.toArray(new CommonHFSCatalogLeafRecord[results.size()]);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            CommonHFSCatalogLeafNode currentNode = this.newCatalogLeafNode(currentNodeData, 0, nodeSize, bthr);
            return CatalogFile.getChildrenTo(currentNode, dirID);
        }
        throw new RuntimeException("Illegal type for node! (" + (Object)((Object)nodeDescriptor.getNodeType()) + ")");
    }

    private static List<CommonBTIndexRecord<CommonHFSCatalogKey>> findLEChildKeys(CommonBTIndexNode<CommonHFSCatalogKey> indexNode, CommonHFSCatalogNodeID rootFolderID) {
        LinkedList<CommonBTIndexRecord<CommonHFSCatalogKey>> result = new LinkedList<CommonBTIndexRecord<CommonHFSCatalogKey>>();
        CommonBTIndexRecord largestMatchingRecord = null;
        CommonHFSCatalogKey largestMatchingKey = null;
        for (CommonBTIndexRecord record : indexNode.getBTRecords()) {
            CommonHFSCatalogKey key = (CommonHFSCatalogKey)record.getKey();
            if (key.getParentID().toLong() < rootFolderID.toLong() && (largestMatchingKey == null || key.compareTo(largestMatchingKey) > 0)) {
                largestMatchingKey = key;
                largestMatchingRecord = record;
                continue;
            }
            if (key.getParentID().toLong() != rootFolderID.toLong()) continue;
            result.addLast(record);
        }
        if (largestMatchingKey != null) {
            result.addFirst(largestMatchingRecord);
        }
        return result;
    }

    private static CommonHFSCatalogLeafRecord[] getChildrenTo(CommonHFSCatalogLeafNode leafNode, CommonHFSCatalogNodeID nodeID) {
        LinkedList<CommonHFSCatalogLeafRecord> children = new LinkedList<CommonHFSCatalogLeafRecord>();
        CommonHFSCatalogLeafRecord[] records = leafNode.getLeafRecords();
        for (int i = 0; i < records.length; ++i) {
            CommonHFSCatalogLeafRecord curRec = records[i];
            if (curRec.getKey().getParentID().toLong() != nodeID.toLong()) continue;
            children.addLast(curRec);
        }
        return children.toArray(new CommonHFSCatalogLeafRecord[children.size()]);
    }

    protected CommonHFSCatalogIndexNode newCatalogIndexNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
        return this.ops.newCatalogIndexNode(data, offset, nodeSize, bthr);
    }

    protected CommonHFSCatalogKey newCatalogKey(CommonHFSCatalogNodeID nodeID, CommonHFSCatalogString searchString, CommonBTHeaderRecord bthr) {
        return this.ops.newCatalogKey(nodeID, searchString, bthr);
    }

    protected CommonHFSCatalogLeafNode newCatalogLeafNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
        return this.ops.newCatalogLeafNode(data, offset, nodeSize, bthr);
    }

    protected CommonHFSCatalogLeafRecord newCatalogLeafRecord(byte[] data, int offset, CommonBTHeaderRecord bthr) {
        return this.ops.newCatalogLeafRecord(data, offset, bthr);
    }

    private static void printStructArray(PrintStream ps, String prefix, String variableName, PrintableStruct[] structs) {
        for (int i = 0; i < structs.length; ++i) {
            ps.println(prefix + variableName + "[" + i + "]:");
            structs[i].print(ps, prefix + " ");
        }
    }

    class CatalogFileSession
    extends BTreeFile.BTreeFileSession {
        final ReadableRandomAccessStream catalogFile;

        public CatalogFileSession() {
            this.catalogFile = this.btreeStream;
        }

        protected ReadableRandomAccessStream getBTreeStream(CommonHFSVolumeHeader header) {
            return new ForkFilter(ForkFilter.ForkType.DATA, CatalogFile.this.vol.getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID.CATALOG_FILE).toLong(), header.getCatalogFile(), CatalogFile.this.vol.extentsOverflowFile, new ReadableRandomAccessSubstream(CatalogFile.this.vol.hfsFile), 0L, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)CatalogFile.this.vol.physicalBlockSize);
        }
    }
}

